/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public class ZoomableLabel
extends JLabel {
    public static final String TEXT_RENDERING_ICON = "TextRenderingIcon";
    protected static final Graphics2D fmg = new BufferedImage(1, 1, 2).createGraphics();
    private int minimumWidth;
    private int maximumWidth;

    public int getIconWidth() {
        Icon icon = this.getIcon();
        if (icon == null) {
            return 0;
        }
        return this.getMap().getZoomed(icon.getIconWidth());
    }

    public NodeView getNodeView() {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            Dimension preferredSize = super.getPreferredSize();
            return preferredSize;
        }
        return ((ZoomableLabelUI)this.getUI()).getPreferredSize(this);
    }

    protected float getZoom() {
        float zoom = this.getMap().getZoom();
        return zoom;
    }

    protected MapView getMap() {
        return this.getNodeView().getMap();
    }

    @Override
    public void paint(Graphics g) {
        switch (this.getMap().getPaintingMode()) {
            case CLOUDS: {
                return;
            }
        }
        super.paint(g);
    }

    protected void updateText(String text) {
        try {
            this.updateTextUnsafe(text);
        }
        catch (Exception e1) {
            if (e1 instanceof AccessControlException) {
                LogUtils.warn(e1.getMessage());
            } else {
                LogUtils.severe(e1);
            }
            String localizedMessage = e1.getLocalizedMessage();
            if (text.length() > 603) {
                text = text.substring(0, 600) + "...";
            }
            try {
                this.updateTextUnsafe(localizedMessage + '\n' + text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextUnsafe(String nodeText) throws Exception {
        String[] lines;
        NodeView node = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
        MapView map = node.getMap();
        if (map == null || nodeText == null) {
            return;
        }
        boolean isHtml = nodeText.startsWith("<html>");
        boolean widthMustBeRestricted = !this.areInsetsFixed();
        boolean isLong = false;
        if (!isHtml) {
            lines = nodeText.split("\n");
            for (int line = 0; line < lines.length && !widthMustBeRestricted; ++line) {
                this.setText(lines[line]);
                int oldMaximumWidth = this.getMaximumWidth();
                try {
                    ModeController modeController = map.getModeController();
                    NodeStyleController nsc = NodeStyleController.getController(modeController);
                    double maxNodeWidth = nsc.getMaxWidth(node.getModel()).toBaseUnits();
                    this.setMaximumWidth(Integer.MAX_VALUE);
                    widthMustBeRestricted = this.getPreferredSize().width > map.getZoomed(maxNodeWidth);
                    continue;
                }
                finally {
                    this.setMaximumWidth(oldMaximumWidth);
                }
            }
            boolean bl = isLong = widthMustBeRestricted || lines.length > 1;
        }
        if (isHtml) {
            String htmlLongNodeHead;
            if (nodeText.indexOf("<img") >= 0 && nodeText.indexOf("<base ") < 0) {
                nodeText = "<html><base href=\"" + map.getModel().getURL() + "\">" + nodeText.substring(6);
            }
            if ((htmlLongNodeHead = ResourceController.getResourceController().getProperty("html_long_node_head")) != null && !htmlLongNodeHead.equals("")) {
                nodeText = nodeText.matches("(?ims).*<head>.*") ? nodeText.replaceFirst("(?ims).*<head>.*", "<head>" + htmlLongNodeHead) : nodeText.replaceFirst("(?ims)<html>", "<html><head>" + htmlLongNodeHead + "</head>");
            }
            this.setText(nodeText);
        } else if (nodeText.startsWith("<table>")) {
            lines = nodeText.split("\n");
            lines[0] = lines[0].substring(7);
            int startingLine = lines[0].matches("\\s*") ? 1 : 0;
            String text = "<html><table border=1 style=\"border-color: white\">";
            for (int line = startingLine; line < lines.length; ++line) {
                text = text + "<tr><td style=\"border-color: white;\">" + HtmlUtils.toXMLEscapedText(lines[line]).replaceAll("\t", "<td style=\"border-color: white\">");
            }
            this.setText(text);
        } else if (isLong) {
            String text = HtmlUtils.plainToHTML(nodeText);
            this.setText(text);
        } else {
            this.setText(nodeText);
        }
    }

    protected boolean areInsetsFixed() {
        return true;
    }

    public ZoomableLabel() {
        this.setUI(ZoomableLabelUI.createUI(this));
    }

    @Override
    public void updateUI() {
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        try {
            if (!this.useFractionalMetrics()) {
                return super.getFontMetrics(font);
            }
            fmg.setFont(font);
            FontMetrics fontMetrics = fmg.getFontMetrics();
            return fontMetrics;
        }
        catch (Exception e) {
            return super.getFontMetrics(font);
        }
    }

    protected boolean useFractionalMetrics() {
        MapView map = this.getMap();
        if (map.isPrinting()) {
            return true;
        }
        float zoom = map.getZoom();
        return 1.0f != zoom;
    }

    protected FontMetrics getFontMetrics() {
        if (!this.useFractionalMetrics()) {
            return super.getFontMetrics(this.getFont());
        }
        fmg.setFont(this.getFont());
        FontMetrics fontMetrics = fmg.getFontMetrics();
        return fontMetrics;
    }

    public String getLink(Point p) {
        View view = (View)this.getClientProperty("html");
        if (view == null) {
            return null;
        }
        Rectangle textR = ((ZoomableLabelUI)this.getUI()).getTextR(this);
        if (textR == null) {
            return null;
        }
        if (!textR.contains(p)) {
            return null;
        }
        int x = (int)((float)p.x / this.getZoom());
        int y = (int)((float)p.y / this.getZoom());
        int pos = view.viewToModel(x, y, textR);
        HTMLDocument document = (HTMLDocument)view.getDocument();
        String linkURL = HtmlUtils.getURLOfExistingLink(document, pos);
        return linkURL;
    }

    public Insets getZoomedInsets() {
        Insets unzoomedInsets = this.getInsets();
        float zoom = this.getZoom();
        Insets zoomedInsets = new Insets((int)((float)unzoomedInsets.top * zoom), (int)((float)unzoomedInsets.left * zoom), (int)((float)unzoomedInsets.bottom * zoom), (int)((float)unzoomedInsets.right * zoom));
        return zoomedInsets;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    protected int limitWidth(int width) {
        if (width < this.getMinimumWidth()) {
            return this.getMinimumWidth();
        }
        if (width > this.getMaximumWidth()) {
            return this.getMaximumWidth();
        }
        return width;
    }

    protected double limitWidth(double width) {
        if (width < (double)this.getMinimumWidth()) {
            return this.getMinimumWidth();
        }
        if (width > (double)this.getMaximumWidth()) {
            return this.getMaximumWidth();
        }
        return width;
    }

    static {
        fmg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

