/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeView;

abstract class AttributeTableModelDecoratorAdapter
extends AbstractTableModel
implements IAttributeTableModel,
TableModelListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final AttributeController attributeController;
    private AttributeRegistry attributeRegistry;
    private NodeAttributeTableModel nodeAttributeModel;
    private final TextController textController;

    public AttributeTableModelDecoratorAdapter(AttributeView attrView) {
        ModeController modeController = attrView.getMapView().getModeController();
        this.attributeController = AttributeController.getController(modeController);
        this.textController = TextController.getController(modeController);
        this.setNodeAttributeModel(attrView.getAttributes());
        this.setAttributeRegistry(attrView.getAttributeRegistry());
        this.getNodeAttributeModel().getNode();
        this.addListeners();
    }

    private void addListeners() {
        this.getNodeAttributeModel().addTableModelListener(this);
        this.getAttributeRegistry().addChangeListener(this);
    }

    public abstract boolean areAttributesVisible();

    public void editingCanceled() {
    }

    public AttributeController getAttributeController() {
        return this.attributeController;
    }

    public AttributeRegistry getAttributeRegistry() {
        return this.attributeRegistry;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getNodeAttributeModel().getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getNodeAttributeModel().getColumnName(columnIndex);
    }

    @Override
    public Quantity<LengthUnits> getColumnWidth(int col) {
        return this.getNodeAttributeModel().getColumnWidth(col);
    }

    @Override
    public NodeModel getNode() {
        return this.getNodeAttributeModel().getNode();
    }

    public NodeAttributeTableModel getNodeAttributeModel() {
        return this.nodeAttributeModel;
    }

    private void removeListeners() {
        this.getNodeAttributeModel().removeTableModelListener(this);
        this.getAttributeRegistry().removeChangeListener(this);
    }

    public void setAttributeRegistry(AttributeRegistry attributeRegistry) {
        this.attributeRegistry = attributeRegistry;
    }

    public void setColumnWidth(int col, Quantity<LengthUnits> width) {
        this.getAttributeController().performSetColumnWidth(this.getNodeAttributeModel(), col, width);
    }

    public void setNodeAttributeModel(NodeAttributeTableModel nodeAttributeModel) {
        this.nodeAttributeModel = nodeAttributeModel;
        int rowCount = nodeAttributeModel.getRowCount();
        this.cacheTransformedValues(0, rowCount - 1);
    }

    private void cacheTransformedValue(int row) {
        try {
            Object value = this.nodeAttributeModel.getValueAt(row, 1);
            if (value != null) {
                this.textController.getTransformedText(value.toString(), this.getNode(), null);
            }
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    public void viewRemoved(NodeView nodeView) {
        this.removeListeners();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case 0: 
            case 1: {
                this.cacheTransformedValues(e.getFirstRow(), e.getLastRow());
            }
        }
    }

    private void cacheTransformedValues(int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            this.cacheTransformedValue(row);
        }
    }
}

