/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class BezierEdgeView
extends EdgeView {
    private static final int CHILD_XCTRL = 20;
    private static final int XCTRL = 12;

    public BezierEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    protected void draw(Graphics2D g) {
        CubicCurve2D.Float graph = this.update();
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        g.draw(graph);
        if (this.isTargetEclipsed()) {
            g.setColor(g.getBackground());
            g.setStroke(EdgeView.getEclipsedStroke());
            g.draw(graph);
            g.setStroke(stroke);
            g.setColor(color);
        }
    }

    private CubicCurve2D.Float update() {
        Point startControlPoint = this.getControlPoint(this.getStartConnectorLocation());
        int zoomedXCTRL = this.getMap().getZoomed(12);
        int xctrl = startControlPoint.x * zoomedXCTRL;
        int yctrl = startControlPoint.y * zoomedXCTRL;
        Point endControlPoint = this.getControlPoint(this.getEndConnectorLocation());
        int zoomedChildXCTRL = this.getMap().getZoomed(20);
        int childXctrl = endControlPoint.x * zoomedChildXCTRL;
        int childYctrl = endControlPoint.y * zoomedChildXCTRL;
        CubicCurve2D.Float graph = new CubicCurve2D.Float();
        graph.setCurve(this.start.x, this.start.y, this.start.x + xctrl, this.start.y + yctrl, this.end.x + childXctrl, this.end.y + childYctrl, this.end.x, this.end.y);
        return graph;
    }

    @Override
    public boolean detectCollision(Point p) {
        CubicCurve2D.Float graph = this.update();
        return new CollisionDetector().detectCollision(p, graph);
    }
}

