/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.openmaps;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.openmaps.LocationChoosenListener;
import org.freeplane.plugin.openmaps.OpenMapsExtension;
import org.freeplane.plugin.openmaps.mapelements.OpenMapsDialog;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

@NodeHookDescriptor(hookName="plugins/openmaps/OpenMapsNodeHook.propterties", onceForMap=false)
public class OpenMapsNodeHook
extends PersistentNodeHook
implements LocationChoosenListener {
    static final String ICON_NAME = "internet";
    private OpenMapsDialog map;

    public OpenMapsNodeHook() {
        this.registerStateIconProvider();
    }

    public void chooseLocation() {
        this.map = new OpenMapsDialog();
        this.map.getController().addLocationChoosenListener(this);
    }

    public void removeLocationFromCurrentlySelectedNode() {
        NodeModel node = this.getCurrentlySelectedNode();
        OpenMapsExtension openMapsExtension = (OpenMapsExtension)node.getExtension(OpenMapsExtension.class);
        if (openMapsExtension != null) {
            super.undoableToggleHook(node, (IExtension)openMapsExtension);
            this.refreshNode(node);
        }
        MapModel map = Controller.getCurrentModeController().getController().getMap();
        Controller.getCurrentModeController().getMapController().setSaved(map, false);
    }

    @Override
    public void locationChoosenAction(ICoordinate locationChoosen, int zoom) {
        this.addChoosenLocationToSelectedNode(locationChoosen, zoom);
    }

    public void viewCurrentlySelectedLocation(NodeModel targetNode) {
        OpenMapsExtension openMapsExtension = targetNode == null ? (OpenMapsExtension)this.getCurrentlySelectedNode().getExtension(OpenMapsExtension.class) : (OpenMapsExtension)targetNode.getExtension(OpenMapsExtension.class);
        if (openMapsExtension != null) {
            this.map = new OpenMapsDialog();
            this.map.showZoomToLocation(openMapsExtension.getLocation(), openMapsExtension.getZoom());
            this.map.getController().addLocationChoosenListener(this);
        }
    }

    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    protected IExtension createExtension(NodeModel node, XMLElement element) {
        OpenMapsExtension extension = new OpenMapsExtension();
        this.loadLocationFromXML(element, extension);
        return extension;
    }

    protected Class<OpenMapsExtension> getExtensionClass() {
        return OpenMapsExtension.class;
    }

    protected void saveExtension(IExtension extension, XMLElement element) {
        OpenMapsExtension openMapsExtension = (OpenMapsExtension)extension;
        element.setAttribute("LAT", Double.toString(openMapsExtension.getLocation().getLat()));
        element.setAttribute("LON", Double.toString(openMapsExtension.getLocation().getLon()));
        element.setAttribute("ZOOM", Integer.toString(openMapsExtension.getZoom()));
        super.saveExtension(extension, element);
    }

    private void loadLocationFromXML(XMLElement element, OpenMapsExtension extension) {
        if (element != null) {
            double location_x = Double.parseDouble(element.getAttribute("LAT", null));
            double location_y = Double.parseDouble(element.getAttribute("LON", null));
            int zoom = Integer.parseInt(element.getAttribute("ZOOM", null));
            extension.updateLocation(location_x, location_y);
            extension.updateZoom(zoom);
        }
    }

    private void addChoosenLocationToSelectedNode(ICoordinate locationChoosen, int zoom) {
        NodeModel node = this.getCurrentlySelectedNode();
        OpenMapsExtension openMapsExtension = (OpenMapsExtension)node.getExtension(OpenMapsExtension.class);
        if (openMapsExtension == null) {
            openMapsExtension = new OpenMapsExtension();
            this.undoableActivateHook(node, openMapsExtension);
        }
        this.setLocationChoiceUndoable(openMapsExtension, locationChoosen, zoom);
        this.refreshNode(node);
    }

    private void setLocationChoiceUndoable(OpenMapsExtension extension, ICoordinate locationChoosen, int zoomChoosen) {
        Coordinate currentLocation = extension.getLocation();
        int currentZoom = extension.getZoom();
        if (!currentLocation.equals((Object)locationChoosen)) {
            IActor actor = this.createUndoActor(extension, locationChoosen, (ICoordinate)currentLocation, zoomChoosen, currentZoom);
            Controller.getCurrentModeController().execute(actor, Controller.getCurrentModeController().getController().getMap());
        }
    }

    private IActor createUndoActor(final OpenMapsExtension extension, final ICoordinate newlyChoosenLocation, final ICoordinate currentlyStoredLocation, final int newlyChoosenZoom, final int currentlyStoredZoom) {
        return new IActor(){
            private final ICoordinate oldLocation;
            private final int oldZoom;
            {
                this.oldLocation = currentlyStoredLocation;
                this.oldZoom = currentlyStoredZoom;
            }

            public void act() {
                extension.updateLocation(newlyChoosenLocation);
                extension.updateZoom(newlyChoosenZoom);
                MapModel map = Controller.getCurrentModeController().getController().getMap();
                Controller.getCurrentModeController().getMapController().setSaved(map, false);
            }

            public String getDescription() {
                return "setOpenMapsLocationChoiceUndoable";
            }

            public void undo() {
                if (this.oldLocation.getLat() == 500.0 && this.oldLocation.getLon() == 500.0) {
                    OpenMapsNodeHook.this.removeLocationFromCurrentlySelectedNode();
                } else {
                    extension.updateLocation(this.oldLocation);
                    extension.updateZoom(this.oldZoom);
                }
                OpenMapsNodeHook.this.refreshNode(OpenMapsNodeHook.this.getCurrentlySelectedNode());
            }
        };
    }

    private void refreshNode(NodeModel node) {
        Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
    }

    private NodeModel getCurrentlySelectedNode() {
        return Controller.getCurrentModeController().getMapController().getSelectedNode();
    }

    private void registerStateIconProvider() {
        ((IconController)Controller.getCurrentModeController().getExtension(IconController.class)).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                if (node.getExtension(OpenMapsExtension.class) != null) {
                    return IconStoreFactory.create().getUIIcon(OpenMapsNodeHook.ICON_NAME);
                }
                return null;
            }
        });
    }
}

