/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class ScriptRunnerAction
extends DefaultSyntaxAction {
    static ScriptEngineManager sem;
    private ScriptEngine engine;
    private String scriptExtension;

    public ScriptRunnerAction() {
        super("SCRIPT_EXECUTE");
    }

    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        try {
            ScriptEngine scriptEngine = this.getEngine(jTextComponent);
            if (scriptEngine != null) {
                this.getEngine(jTextComponent).eval(jTextComponent.getText());
            }
        }
        catch (ScriptException scriptException) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(jTextComponent), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptRunnerAction.ErrorExecutingScript") + scriptException.getMessage(), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptRunnerAction.ScriptError"), 0);
            ActionUtils.setCaretPosition(jTextComponent, scriptException.getLineNumber(), scriptException.getColumnNumber());
        }
    }

    private ScriptEngine getEngine(JTextComponent jTextComponent) {
        int n;
        if (this.engine == null) {
            if (sem == null) {
                sem = new ScriptEngineManager();
            }
            this.engine = sem.getEngineByExtension(this.scriptExtension);
        }
        if (this.engine == null && (n = JOptionPane.showOptionDialog(jTextComponent, MessageFormat.format(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptRunnerAction.ScriptEngineNotFound"), this.scriptExtension), "jsyntaxpane", 0, 0, null, null, null)) == 0) {
            this.setEnabled(false);
        }
        return this.engine;
    }

    public void setScriptExtension(String string) {
        this.scriptExtension = string;
    }
}

