/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.util.SwingUtils;

public class GotoLineDialog
extends JDialog
implements EscapeListener {
    private static final String PROPERTY_KEY = "GOTOLINE_DIALOG";
    private WeakReference<JTextComponent> text;
    private JButton jBtnOk;
    private JComboBox jCmbLineNumbers;

    private GotoLineDialog(JTextComponent jTextComponent) {
        super(SwingUtilities.getWindowAncestor(jTextComponent), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.text = new WeakReference<JTextComponent>(jTextComponent);
        this.setLocationRelativeTo(jTextComponent.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnOk);
        jTextComponent.getDocument().putProperty(PROPERTY_KEY, this);
        SwingUtils.addEscapeListener(this);
    }

    private void initComponents() {
        this.jCmbLineNumbers = new JComboBox();
        this.jBtnOk = new JButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.setTitle(resourceBundle.getString("GotoLineDialog.title"));
        this.setModal(true);
        this.setName("");
        this.setResizable(false);
        this.jCmbLineNumbers.setEditable(true);
        this.jCmbLineNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GotoLineDialog.this.jCmbLineNumbersActionPerformed(actionEvent);
            }
        });
        this.jBtnOk.setAction(this.jCmbLineNumbers.getAction());
        this.jBtnOk.setText(resourceBundle.getString("GotoLineDialog.jBtnOk.text"));
        this.jBtnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GotoLineDialog.this.jBtnOkActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jCmbLineNumbers, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnOk, -1, 47, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbLineNumbers, -2, -1, -2).addComponent(this.jBtnOk, -2, 26, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void setTextPos() {
        Object object = this.jCmbLineNumbers.getSelectedItem();
        if (object != null) {
            try {
                int n = Integer.parseInt(object.toString());
                ActionUtils.insertIntoCombo(this.jCmbLineNumbers, object);
                ActionUtils.setCaretPosition((JTextComponent)this.text.get(), n, 0);
                this.setVisible(false);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid Number: " + object, "Number Error", 0);
            }
        }
    }

    private void jCmbLineNumbersActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxEdited")) {
            this.setTextPos();
        }
    }

    private void jBtnOkActionPerformed(ActionEvent actionEvent) {
        this.setTextPos();
    }

    public static void showForEditor(JTextComponent jTextComponent) {
        GotoLineDialog gotoLineDialog = null;
        gotoLineDialog = jTextComponent.getDocument().getProperty(PROPERTY_KEY) == null ? new GotoLineDialog(jTextComponent) : (GotoLineDialog)jTextComponent.getDocument().getProperty(PROPERTY_KEY);
        gotoLineDialog.jCmbLineNumbers.requestFocusInWindow();
        gotoLineDialog.setVisible(true);
    }

    public void escapePressed() {
        this.setVisible(false);
    }
}

