/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.lang.reflect.Member;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.ActionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MemberCell
extends JPanel {
    private final JList list;
    private final boolean isSelected;
    private final Color backColor;
    private final Member member;
    private final Class theClass;

    public MemberCell(JList jList, boolean bl, Color color, Member member, Class clazz) {
        this.list = jList;
        this.isSelected = bl;
        this.backColor = color;
        this.member = member;
        this.theClass = clazz;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        SyntaxView.setRenderingHits((Graphics2D)graphics);
        graphics.setFont(this.list.getFont());
        super.paintComponent(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.isSelected ? this.list.getSelectionBackground() : this.backColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.isSelected ? this.list.getSelectionForeground() : this.list.getForeground());
        graphics.drawImage(this.getIcon(), 2, 0, null);
        int n = 6 + this.getIcon().getWidth(this);
        int n2 = fontMetrics.getHeight();
        if (this.member.getDeclaringClass().equals(this.theClass)) {
            object = this.list.getFont().deriveFont(1);
            graphics.setFont((Font)object);
        }
        n = this.drawString(this.getMemberName(), n, n2, graphics);
        graphics.setFont(this.list.getFont());
        n = this.drawString(this.getArguments(), n, n2, graphics);
        object = this.getReturnType();
        int n3 = fontMetrics.stringWidth((String)object);
        graphics.drawString((String)object, this.getWidth() - n3 - 4, fontMetrics.getAscent());
    }

    @Override
    public Dimension getPreferredSize() {
        Font font = this.list.getFont();
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        String string = this.getMemberName() + this.getArguments() + this.getReturnType() + "  ";
        return new Dimension(fontMetrics.stringWidth(string) + 20, Math.max(fontMetrics.getHeight(), 16));
    }

    private int drawString(String string, int n, int n2, Graphics graphics) {
        if (ActionUtils.isEmptyOrBlanks(string)) {
            return n;
        }
        int n3 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n, n2);
        return n + n3;
    }

    Map<Integer, Image> readIcons(String string) {
        HashMap<Integer, Image> hashMap = new HashMap<Integer, Image>();
        hashMap.put(1, this.readImage(string, ""));
        hashMap.put(2, this.readImage(string, "_private"));
        hashMap.put(4, this.readImage(string, "_protected"));
        hashMap.put(9, this.readImage(string, "_static"));
        hashMap.put(10, this.readImage(string, "_static_private"));
        hashMap.put(12, this.readImage(string, "_static_protected"));
        return hashMap;
    }

    private Image readImage(String string, String string2) {
        String string3 = string + string2 + ".png";
        URL uRL = this.getClass().getResource(string3);
        if (uRL == null) {
            return null;
        }
        Image image = new ImageIcon(uRL).getImage();
        return image;
    }

    protected String getMemberName() {
        return this.member.getName();
    }

    protected abstract String getArguments();

    protected abstract String getReturnType();

    protected abstract Image getIcon();
}

