/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarServiceProvider {
    public static final String SERVICES_ROOT = "META-INF/services/";
    private static final Logger LOG = Logger.getLogger(JarServiceProvider.class.getName());

    private JarServiceProvider() {
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = JarServiceProvider.class.getClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getServiceProviders(Class clazz) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ClassLoader classLoader = JarServiceProvider.getClassLoader();
        String string = SERVICES_ROOT + clazz.getName();
        Enumeration<URL> enumeration = classLoader.getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n = string2.indexOf("#");
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((string2 = string2.trim()).length() == 0) continue;
                    try {
                        Object obj = classLoader.loadClass(string2).newInstance();
                        arrayList.add(obj);
                    }
                    catch (Exception exception) {
                        LOG.warning("Could not load: " + string2);
                        LOG.warning(exception.getMessage());
                    }
                }
            }
            finally {
                if (bufferedReader == null) continue;
                bufferedReader.close();
            }
        }
        return arrayList;
    }

    public static Properties readProperties(Class clazz) {
        return JarServiceProvider.readProperties(clazz.getName());
    }

    public static Properties readProperties(String string) {
        InputStream inputStream;
        Properties properties = new Properties();
        String string2 = string.toLowerCase();
        if (!string2.endsWith(".properties")) {
            string2 = string2 + ".properties";
        }
        if ((inputStream = JarServiceProvider.findResource(string2)) != null) {
            try {
                properties.load(new InputStreamReader(inputStream, "UTF-8"));
            }
            catch (IOException iOException) {
                Logger.getLogger(JarServiceProvider.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        return properties;
    }

    public static Properties readProperties(String string, Locale locale) {
        Properties properties;
        int n = (string = string.toLowerCase()).lastIndexOf(".properties");
        if (n > 0) {
            string = string.substring(0, n);
        }
        Properties properties2 = JarServiceProvider.readProperties(string);
        if (locale != null && locale.getLanguage() != null) {
            string = string + "_" + locale.getLanguage();
            properties = JarServiceProvider.readProperties(string);
            properties2.putAll((Map<?, ?>)properties);
        }
        if (locale != null && locale.getCountry() != null) {
            string = string + "_" + locale.getCountry();
            properties = JarServiceProvider.readProperties(string);
            properties2.putAll((Map<?, ?>)properties);
        }
        return properties2;
    }

    public static Map<String, String> readStringsMap(String string) {
        Properties properties = JarServiceProvider.readProperties(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String string) {
        InputStream inputStream = JarServiceProvider.findResource(string);
        if (inputStream == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string2 = string2.trim().replace("\\n", "\n").replace("\\t", "\t");
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
            }
            return arrayList;
        }
    }

    public static InputStream findResource(String string, ClassLoader classLoader) {
        InputStream inputStream = null;
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = classLoader.getResource(SERVICES_ROOT + string);
        }
        if (uRL == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        } else {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                Logger.getLogger(JarServiceProvider.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        return inputStream;
    }

    public static InputStream findResource(String string) {
        return JarServiceProvider.findResource(string, JarServiceProvider.getClassLoader());
    }
}

