/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.FormulaUtils;
import org.freeplane.plugin.script.UniqueStack;

public class ScriptContext {
    private final UniqueStack<NodeWrapper> stack = new UniqueStack();

    public void accessNode(NodeModel accessedNode) {
        NodeWrapper nodeWrapper = this.stackLastLogNull("accessNode");
        if (nodeWrapper != null) {
            FormulaUtils.accessNode(nodeWrapper.getNodeModel(), accessedNode);
        }
    }

    public void accessBranch(NodeModel accessedNode) {
        NodeWrapper nodeWrapper = this.stackLastLogNull("accessBranch");
        if (nodeWrapper != null) {
            FormulaUtils.accessBranch(nodeWrapper.getNodeModel(), accessedNode);
        }
    }

    public void accessAll() {
        NodeWrapper nodeWrapper = this.stackLastLogNull("accessAll");
        if (nodeWrapper != null) {
            FormulaUtils.accessAll(nodeWrapper.getNodeModel());
        }
    }

    private NodeWrapper stackLastLogNull(String method) {
        NodeWrapper last = this.stack.last();
        return last;
    }

    public boolean push(NodeModel nodeModel, String script) {
        boolean success = this.stack.push(new NodeWrapper(nodeModel, script));
        if (!success) {
            LogUtils.warn((String)("Circular reference detected! Traceback (innermost last):\n " + this.stackTrace(nodeModel, script)));
        }
        return success;
    }

    public void pop() {
        this.stack.pop();
    }

    public NodeModel getStackFront() {
        return this.stack.first().getNodeModel();
    }

    public String stackTrace(NodeModel nodeModel, String script) {
        ArrayList<String> entries = new ArrayList<String>(this.stack.size());
        for (NodeWrapper node : this.stack) {
            entries.add(this.format(node.nodeModel, node.script, nodeModel));
        }
        entries.add(this.format(nodeModel, script, nodeModel));
        return StringUtils.join(entries.iterator(), (String)"\n -> ");
    }

    private String format(NodeModel nodeModel, String script, NodeModel nodeToHighlight) {
        return (nodeToHighlight.equals(nodeModel) ? "* " : "") + nodeModel.createID() + " " + this.limitLength(this.deformat(nodeModel.getText()), 30) + " -> " + this.limitLength(script, 60);
    }

    private String deformat(String string) {
        return HtmlUtils.htmlToPlain((String)string).replaceAll("\\s+", " ");
    }

    private String limitLength(String string, int maxLenght) {
        if (string == null || maxLenght >= string.length()) {
            return string;
        }
        maxLenght = maxLenght > 3 ? maxLenght - 3 : maxLenght;
        return string.substring(0, maxLenght) + "...";
    }

    public String toString() {
        return this.stack.toString();
    }

    private static final class NodeWrapper {
        private final NodeModel nodeModel;
        private final String script;

        public NodeWrapper(NodeModel nodeModel, String script) {
            this.nodeModel = nodeModel;
            this.script = script;
        }

        public NodeModel getNodeModel() {
            return this.nodeModel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodeModel == null ? 0 : this.nodeModel.hashCode());
            result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeWrapper other = (NodeWrapper)obj;
            if (this.nodeModel != other.nodeModel) {
                return false;
            }
            if (this.script == null && other.script != null) {
                return false;
            }
            return this.script.equals(other.script);
        }

        public String toString() {
            return this.nodeModel + "[" + this.script + "]";
        }
    }
}

