/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.ComboBoxEditor;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.script.IScriptEditorStarter;
import org.freeplane.features.script.IScriptStarter;
import org.freeplane.main.addons.AddOnInstaller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.ApplicationLifecycleListener;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.plugin.script.ExecuteScriptForAllNodes;
import org.freeplane.plugin.script.ExecuteScriptForSelectionAction;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.InternationalizedSecurityManager;
import org.freeplane.plugin.script.ScriptComboBoxEditor;
import org.freeplane.plugin.script.ScriptCompiler;
import org.freeplane.plugin.script.ScriptEditor;
import org.freeplane.plugin.script.ScriptEditorPanel;
import org.freeplane.plugin.script.ScriptEditorWindowConfigurationStorage;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingConfiguration;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingMenuEntryVisitor;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingPolicy;
import org.freeplane.plugin.script.addons.ManageAddOnsAction;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;
import org.freeplane.plugin.script.filter.ScriptConditionController;

class ScriptingRegistration {
    private final HashMap<String, Object> mScriptCookies = new HashMap();

    public ScriptingRegistration(ModeController modeController) {
        this.register(modeController);
    }

    public HashMap<String, Object> getScriptCookies() {
        return this.mScriptCookies;
    }

    private void register(ModeController modeController) {
        modeController.addExtension(IScriptEditorStarter.class, (IExtension)new IScriptEditorStarter(){

            public String startEditor(String pScriptInput) {
                ScriptModel scriptModel = new ScriptModel(pScriptInput);
                ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(scriptModel, false);
                scriptEditorPanel.setVisible(true);
                return scriptModel.getScript();
            }

            public ComboBoxEditor createComboBoxEditor(Dimension minimumSize) {
                ScriptComboBoxEditor scriptComboBoxEditor = new ScriptComboBoxEditor();
                if (minimumSize != null) {
                    scriptComboBoxEditor.setMinimumSize(minimumSize);
                }
                return scriptComboBoxEditor;
            }
        });
        modeController.addExtension(IScriptStarter.class, (IExtension)new IScriptStarter(){

            public void executeScript(NodeModel node, String script) {
                ScriptingEngine.executeScript(node, script);
            }
        });
        this.registerScriptAddOns();
        if (!modeController.getController().getViewController().isHeadless()) {
            this.registerGuiStuff(modeController);
            ScriptCompiler.compileScriptsOnPath(ScriptResources.getClasspath());
            this.createUserScriptsDirectory();
            this.createInitScriptsDirectory();
            this.createUserLibDirectory();
        }
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(100, (IElementaryConditionController)new ScriptConditionController());
        ScriptingPolicy.installRestrictingPolicy();
        System.setSecurityManager(new InternationalizedSecurityManager());
    }

    private void registerGuiStuff(ModeController modeController) {
        this.addPropertiesToOptionPanel();
        modeController.addAction((AFreeplaneAction)new ScriptEditor());
        modeController.addAction((AFreeplaneAction)new ExecuteScriptForAllNodes());
        modeController.addAction((AFreeplaneAction)new ExecuteScriptForSelectionAction());
        final ManageAddOnsAction manageAddOnsAction = new ManageAddOnsAction();
        modeController.addAction((AFreeplaneAction)manageAddOnsAction);
        modeController.addExtension(AddOnInstaller.class, (IExtension)new AddOnInstaller(){

            public void install(URL url) {
                ManageAddOnsDialog dialog = manageAddOnsAction.getDialog();
                dialog.install(url);
            }
        });
        ScriptingConfiguration configuration = new ScriptingConfiguration();
        this.updateMenus(modeController, configuration);
        this.registerInitScripts(configuration);
    }

    private void addPropertiesToOptionPanel() {
        URL preferences = this.getClass().getResource("preferences.xml");
        if (preferences == null) {
            throw new RuntimeException("cannot open preferences");
        }
        Controller.getCurrentController().addOptionValidator(new IValidator(){

            public IValidator.ValidationResult validate(Properties properties) {
                boolean classpathIsSet;
                IValidator.ValidationResult result = new IValidator.ValidationResult();
                String readAccessString = properties.getProperty("execute_scripts_without_file_restriction");
                String writeAccessString = properties.getProperty("execute_scripts_without_write_restriction");
                String classpath = properties.getProperty("script_classpath");
                boolean readAccess = readAccessString != null && Boolean.parseBoolean(readAccessString);
                boolean writeAccess = writeAccessString != null && Boolean.parseBoolean(writeAccessString);
                boolean bl = classpathIsSet = classpath != null && classpath.length() > 0;
                if (classpathIsSet && !readAccess) {
                    result.addError(TextUtils.getText((String)"OptionPanel.validate_classpath_needs_readaccess"));
                }
                if (writeAccess && !readAccess) {
                    result.addWarning(TextUtils.getText((String)"OptionPanel.validate_write_without_read"));
                }
                return result;
            }
        });
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        modeController.getOptionPanelBuilder().load(preferences);
    }

    private void updateMenus(ModeController modeController, ScriptingConfiguration configuration) {
        ScriptingMenuEntryVisitor builder = new ScriptingMenuEntryVisitor(configuration, modeController);
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "userScripts", (EntryVisitor)builder, EntryVisitor.ILLEGAL);
        modeController.getUserInputListenerFactory().addBuildPhaseListener((BuildPhaseListener)builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerScriptAddOns() {
        File[] addonXmlFiles = AddOnsController.getController().getAddOnsDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".script.xml");
            }
        });
        IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
        for (File file : addonXmlFiles) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                StdXMLReader reader = new StdXMLReader((InputStream)inputStream);
                parser.setReader((IXMLReader)reader);
                ScriptAddOnProperties addOn = new ScriptAddOnProperties((XMLElement)parser.parse());
                addOn.setAddOnPropertiesFile(file);
                AddOnsController.getController().registerInstalledAddOn((AddOnProperties)addOn);
            }
            catch (Exception e) {
                try {
                    LogUtils.warn((String)("error parsing " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
                continue;
            }
            FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
        }
    }

    private void registerInitScripts(ScriptingConfiguration configuration) {
        final List<IScript> initScripts = configuration.getInitScripts();
        if (!initScripts.isEmpty()) {
            Controller.getCurrentController().addApplicationLifecycleListener(new ApplicationLifecycleListener(){

                public void onStartupFinished() {
                    for (IScript script : initScripts) {
                        LogUtils.info((String)("running init script " + script.getScript()));
                        script.execute(null);
                    }
                }
            });
        }
    }

    private void createUserScriptsDirectory() {
        this.createDirIfNotExists(ScriptResources.getUserScriptsDir(), "user scripts");
    }

    private void createInitScriptsDirectory() {
        this.createDirIfNotExists(ScriptResources.getInitScriptsDir(), "init scripts");
    }

    private void createDirIfNotExists(File scriptDir, String what) {
        if (!scriptDir.exists()) {
            LogUtils.info((String)("creating " + what + " directory " + scriptDir));
            scriptDir.mkdirs();
        }
    }

    private void createUserLibDirectory() {
        File libDir = ScriptResources.getUserLibDir();
        if (!libDir.exists()) {
            LogUtils.info((String)("creating user lib directory " + libDir));
            libDir.mkdirs();
        }
    }

    private final class ScriptModel
    implements ScriptEditorPanel.IScriptModel {
        private final String mOriginalScript;
        private String mScript;

        public ScriptModel(String pScript) {
            this.mScript = pScript;
            this.mOriginalScript = pScript;
        }

        @Override
        public int addNewScript() {
            return 0;
        }

        @Override
        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            String marshalled = ResourceController.getResourceController().getProperty(pWindow_preference_storage_property);
            return ScriptEditorWindowConfigurationStorage.decorateDialog(marshalled, pPanel);
        }

        @Override
        public void endDialog(boolean pIsCanceled) {
            if (pIsCanceled) {
                this.mScript = this.mOriginalScript;
            }
        }

        @Override
        public Object executeScript(int pIndex, PrintStream pOutStream, IFreeplaneScriptErrorHandler pErrorHandler) {
            ModeController modeController = Controller.getCurrentModeController();
            ScriptingPermissions restrictedPermissions = ScriptingPermissions.getPermissiveScriptingPermissions();
            return ScriptingEngine.executeScript(modeController.getMapController().getSelectedNode(), this.mScript, pErrorHandler, pOutStream, null, restrictedPermissions);
        }

        @Override
        public int getAmountOfScripts() {
            return 1;
        }

        public String getScript() {
            return this.mScript;
        }

        @Override
        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            return new ScriptEditorPanel.ScriptHolder("Script", this.mScript);
        }

        @Override
        public boolean isDirty() {
            return !StringUtils.equals((String)this.mScript, (String)this.mOriginalScript);
        }

        @Override
        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            this.mScript = pScript.getScript();
        }

        @Override
        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            pStorage.storeDialogPositions(pPanel, pWindow_preference_storage_property);
        }
    }
}

