/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.EnterPasswordDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.encrypt.DesEncrypter;

class SignedScriptHandler {
    public static final String FREEPLANE_SCRIPT_KEY_NAME = "FreeplaneScriptKey";
    private static KeyStore mKeyStore = null;
    private static final String SIGN_PREFIX = "//SIGN:";
    private static final String SIGN_PREFIX_REGEXP = "//SIGN\\((.+?)\\):(.*)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeystore(char[] pPassword) {
        if (mKeyStore != null) {
            return;
        }
        FileInputStream fis = null;
        try {
            mKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(System.getProperty("user.home") + File.separator + ".keystore");
            mKeyStore.load(fis, pPassword);
        }
        catch (FileNotFoundException e) {
            LogUtils.warn((Throwable)e);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogUtils.severe((Throwable)e);
                }
            }
        }
    }

    public boolean isScriptSigned(String pScript, OutputStream pOutStream) {
        ScriptContents content = new ScriptContents(pScript);
        if (content.mSignature != null) {
            try {
                Signature instanceVerify = Signature.getInstance("SHA1withDSA");
                if (content.mKeyName == null) {
                    return false;
                }
                this.initializeKeystore(null);
                instanceVerify.initVerify(mKeyStore.getCertificate(content.mKeyName));
                instanceVerify.update(content.mScript.getBytes());
                boolean verify = instanceVerify.verify(DesEncrypter.fromBase64((String)content.mSignature));
                return verify;
            }
            catch (Exception e) {
                LogUtils.severe((Throwable)e);
                try {
                    pOutStream.write(e.toString().getBytes());
                    pOutStream.write("\n".getBytes());
                }
                catch (Exception e1) {
                    LogUtils.severe((Throwable)e1);
                }
            }
        }
        return false;
    }

    public String signScript(String pScript) {
        ScriptContents content = new ScriptContents(pScript);
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(UITools.getCurrentFrame(), false);
        pwdDialog.setModal(true);
        pwdDialog.setVisible(true);
        if (pwdDialog.getResult() == -1) {
            return content.mScript;
        }
        char[] password = pwdDialog.getPassword().toString().toCharArray();
        this.initializeKeystore(password);
        try {
            Signature instance = Signature.getInstance("SHA1withDSA");
            String keyName = FREEPLANE_SCRIPT_KEY_NAME;
            ResourceController resourceController = ResourceController.getResourceController();
            String propertyKeyName = resourceController.getProperty("script_user_key_name_for_signing");
            if (propertyKeyName == null || propertyKeyName.trim().length() == 0) {
                resourceController.setProperty("script_user_key_name_for_signing", FREEPLANE_SCRIPT_KEY_NAME);
                propertyKeyName = keyName;
            }
            keyName = content.mKeyName != null ? content.mKeyName : (content.mKeyName = propertyKeyName);
            instance.initSign((PrivateKey)mKeyStore.getKey(keyName, password));
            instance.update(content.mScript.getBytes());
            byte[] signature = instance.sign();
            content.mSignature = DesEncrypter.toBase64((byte[])signature);
            return content.toString();
        }
        catch (Exception e) {
            if (!(e instanceof KeyStoreException)) {
                LogUtils.severe((Throwable)e);
            }
            UITools.errorMessage((Object)e.getLocalizedMessage());
            return content.mScript;
        }
    }

    static class ScriptContents {
        private static final Pattern SIGNATURE_WITH_KEY = Pattern.compile("//SIGN\\((.+?)\\):(.*)");
        String mKeyName;
        String mScript;
        String mSignature;

        public ScriptContents(String pScript) {
            int indexOfSignaturePrefix = pScript.lastIndexOf(SignedScriptHandler.SIGN_PREFIX);
            int indexOfSignature = indexOfSignaturePrefix + SignedScriptHandler.SIGN_PREFIX.length();
            if (indexOfSignaturePrefix > 0 && pScript.length() > indexOfSignature) {
                this.mSignature = pScript.substring(indexOfSignature);
                this.mScript = pScript.substring(0, indexOfSignaturePrefix);
                this.mKeyName = null;
            } else {
                Matcher matcher = SIGNATURE_WITH_KEY.matcher(pScript);
                if (matcher.find()) {
                    this.mScript = pScript.substring(0, matcher.start());
                    this.mKeyName = matcher.group(1);
                    this.mSignature = matcher.group(2);
                } else {
                    this.mSignature = null;
                    this.mScript = pScript;
                    this.mKeyName = null;
                }
            }
        }

        public String toString() {
            String prefix = this.mKeyName != null ? "//SIGN(" + this.mKeyName + "):" : SignedScriptHandler.SIGN_PREFIX;
            return this.mScript + prefix + this.mSignature + "\n";
        }
    }
}

