/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.EdgeProxy;
import org.freeplane.plugin.script.proxy.FontProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class NodeStyleProxy
extends AbstractProxy<NodeModel>
implements Proxy.NodeStyle {
    NodeStyleProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    @Override
    public IStyle getStyle() {
        return LogicalStyleModel.getStyle((NodeModel)((NodeModel)this.getDelegate()));
    }

    @Override
    public String getName() {
        IStyle style = this.getStyle();
        return style == null ? null : StyleTranslatedObject.toKeyString((IStyle)style);
    }

    @Override
    public Proxy.Node getStyleNode() {
        NodeModel styleNode = MapStyleModel.getExtension((MapModel)((NodeModel)this.getDelegate()).getMap()).getStyleNode(this.getStyle());
        return new NodeProxy(styleNode, this.getScriptContext());
    }

    @Override
    public Color getBackgroundColor() {
        return this.getStyleController().getBackgroundColor((NodeModel)this.getDelegate());
    }

    @Override
    public String getBackgroundColorCode() {
        return ColorUtils.colorToString((Color)this.getBackgroundColor());
    }

    @Override
    public Proxy.Edge getEdge() {
        return new EdgeProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Font getFont() {
        return new FontProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Color getTextColor() {
        return this.getStyleController().getColor((NodeModel)this.getDelegate());
    }

    @Override
    @Deprecated
    public Color getNodeTextColor() {
        return this.getTextColor();
    }

    @Override
    public String getTextColorCode() {
        return ColorUtils.colorToString((Color)this.getTextColor());
    }

    @Override
    public boolean isFloating() {
        return NodeStyleProxy.hasStyle((NodeModel)this.getDelegate(), StyleTranslatedObject.toKeyString((IStyle)MapStyleModel.FLOATING_STYLE));
    }

    @Override
    public int getMinNodeWidth() {
        return this.getMinNodeWidthQuantity().toBaseUnitsRounded();
    }

    public Quantity<LengthUnits> getMinNodeWidthQuantity() {
        return this.getStyleController().getMinWidth((NodeModel)this.getDelegate());
    }

    @Override
    public int getMaxNodeWidth() {
        return this.getMaxNodeWidthQuantity().toBaseUnitsRounded();
    }

    public Quantity<LengthUnits> getMaxNodeWidthQuantity() {
        return this.getStyleController().getMaxWidth((NodeModel)this.getDelegate());
    }

    private MLogicalStyleController getLogicalStyleController() {
        return (MLogicalStyleController)LogicalStyleController.getController();
    }

    private MNodeStyleController getStyleController() {
        return (MNodeStyleController)NodeStyleController.getController();
    }

    @Override
    public void setStyle(IStyle key) {
        this.getLogicalStyleController().setStyle((NodeModel)this.getDelegate(), key);
    }

    @Override
    public void setName(String styleName) {
        if (styleName != null) {
            IStyle styleString;
            MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)((NodeModel)this.getDelegate()).getMap());
            Set styles = mapStyleModel.getStyles();
            if (styles.contains(styleString = StyleFactory.create((String)styleName))) {
                this.setStyle(styleString);
                return;
            }
            IStyle styleNamedObject = StyleFactory.create((TranslatedObject)new TranslatedObject(styleName));
            if (styles.contains(styleNamedObject)) {
                this.setStyle(styleNamedObject);
                return;
            }
            for (IStyle style : styles) {
                if (!style.toString().equals(styleName)) continue;
                this.setStyle(style);
                return;
            }
            throw new IllegalArgumentException("style '" + styleName + "' not found");
        }
        this.setStyle(null);
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getStyleController().setBackgroundColor((NodeModel)this.getDelegate(), color);
    }

    @Override
    public void setBackgroundColorCode(String rgbString) {
        this.setBackgroundColor(ColorUtils.stringToColor((String)rgbString));
    }

    @Override
    public void setTextColor(Color color) {
        this.getStyleController().setColor((NodeModel)this.getDelegate(), color);
    }

    @Override
    @Deprecated
    public void setNodeTextColor(Color color) {
        this.setTextColor(color);
    }

    @Override
    public void setTextColorCode(String rgbString) {
        this.setTextColor(ColorUtils.stringToColor((String)rgbString));
    }

    @Override
    public void setFloating(boolean floating) {
        if (floating) {
            this.setStyle(MapStyleModel.FLOATING_STYLE);
        } else if (MapStyleModel.FLOATING_STYLE.equals(this.getStyle())) {
            this.setStyle(null);
        }
    }

    public static boolean hasStyle(NodeModel nodeModel, String styleName) {
        Collection styles = LogicalStyleController.getController().getStyles(nodeModel);
        for (IStyle style : styles) {
            if (!StyleTranslatedObject.toKeyString((IStyle)style).equals(styleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMinNodeWidth(int width) {
        Quantity<LengthUnits> quantity = this.inPixels(width);
        this.setMinNodeWidth(quantity);
    }

    public Quantity<LengthUnits> inPixels(int width) {
        Quantity quantity = width != -1 ? new Quantity((double)width, (Enum)LengthUnits.px) : null;
        return quantity;
    }

    @Override
    public void setMinNodeWidth(Quantity<LengthUnits> width) {
        this.getStyleController().setMinNodeWidth((NodeModel)this.getDelegate(), width);
    }

    @Override
    public void setMinNodeWidth(String width) {
        this.getStyleController().setMinNodeWidth((NodeModel)this.getDelegate(), Quantity.fromString((String)width, (Enum)LengthUnits.px));
    }

    @Override
    public void setMaxNodeWidth(int width) {
        Quantity<LengthUnits> quantity = this.inPixels(width);
        this.setMaxNodeWidth(quantity);
    }

    @Override
    public void setMaxNodeWidth(Quantity<LengthUnits> width) {
        this.getStyleController().setMaxNodeWidth((NodeModel)this.getDelegate(), width);
    }

    @Override
    public void setMaxNodeWidth(String width) {
        this.getStyleController().setMaxNodeWidth((NodeModel)this.getDelegate(), Quantity.fromString((String)width, (Enum)LengthUnits.px));
    }

    @Override
    public boolean isNumberingEnabled() {
        return NodeStyleModel.getNodeNumbering((NodeModel)((NodeModel)this.getDelegate()));
    }

    @Override
    public void setNumberingEnabled(boolean enabled) {
        this.getStyleController().setNodeNumbering((NodeModel)this.getDelegate(), Boolean.valueOf(enabled));
    }
}

