/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.freeplane.core.util.FreeplaneIconUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.NodeContainsCondition;
import org.freeplane.plugin.script.proxy.ControllerProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public class ScriptApiTest {
    ControllerProxy c;
    NodeProxy node;
    private Proxy.Map map;
    private Comparator<NodeProxy> nodeComparator = new Comparator<NodeProxy>(){

        @Override
        public int compare(NodeProxy o1, NodeProxy o2) {
            return new Integer(System.identityHashCode(o1.getDelegate())).compareTo(System.identityHashCode(o2.getDelegate()));
        }
    };

    public ScriptApiTest(ControllerProxy c, NodeProxy node) {
        this.c = c;
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAll(ControllerProxy c, NodeProxy node) {
        long startMillis = System.currentTimeMillis();
        int failures = 0;
        int errors = 0;
        int pass = 0;
        Method tearDown = null;
        try {
            tearDown = ScriptApiTest.class.getMethod("tearDown", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Method method : ScriptApiTest.class.getMethods()) {
            if (!method.getName().startsWith("test")) continue;
            ScriptApiTest instance = new ScriptApiTest(c, node);
            try {
                method.invoke((Object)instance, new Object[0]);
                LogUtils.info((String)(method.getName() + ": pass"));
                ++pass;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof TestException) {
                    LogUtils.warn((String)(method.getName() + ": failure: " + e.getCause().getMessage()), (Throwable)e.getCause());
                    ++failures;
                    continue;
                }
                LogUtils.warn((String)(method.getName() + ": error invoking test: " + e.getCause().getMessage()), (Throwable)e.getCause());
                ++errors;
            }
            catch (Throwable e) {
                LogUtils.warn((String)(method.getName() + ": other error: " + e.getMessage()), (Throwable)e);
                ++errors;
            }
            finally {
                try {
                    if (tearDown != null) {
                        tearDown.invoke((Object)instance, new Object[0]);
                    }
                }
                catch (Throwable e) {
                    LogUtils.warn((String)("failure executing tearDown after " + method.getName()), (Throwable)e);
                }
            }
        }
        double seconds = (double)(System.currentTimeMillis() - startMillis) / 1000.0;
        String message = null;
        String iconKey = null;
        if (errors + failures == 0) {
            message = "success! " + pass + " tests passed in " + seconds + " seconds";
            iconKey = "button_ok";
        } else {
            message = "error! test result: " + errors + " errors, " + failures + " failures; " + pass + " tests passed in " + seconds + " seconds";
            iconKey = "button_cancel";
        }
        LogUtils.info((String)message);
        c.setStatusInfo("standard", message, iconKey);
    }

    public void tearDown() {
        if (this.map != null) {
            this.map.close(true, false);
        }
    }

    public void test_AttributesRO_get_String_name() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("first value should be found", "va1", this.map.getRoot().getAttributes().get("a1"));
        this.assertEquals("should return null for non-existing attributes", null, this.map.getRoot().getAttributes().get("x"));
    }

    private Proxy.Map setupMapWithSomeAttributes() {
        this.createTestMap();
        this.map.getRoot().getAttributes().add("a1", "va1");
        this.map.getRoot().getAttributes().add("a1", "va2");
        this.map.getRoot().getAttributes().add("a1", "va3");
        this.map.getRoot().getAttributes().add("b1", "vb1");
        return this.map;
    }

    private void assertEquals(String message, Object expected, Object actual) {
        boolean isEqual;
        message = message == null || message.length() == 0 ? "Failure" : message;
        boolean bl = isEqual = expected == null && actual == null || expected != null && actual != null && expected.equals(actual);
        if (!isEqual) {
            this.fail(message + ". Expected: " + expected + ", but was: " + actual);
        }
    }

    private void assertTrue(String message, boolean test) {
        if (!test) {
            this.fail(message);
        }
    }

    private void assertFalse(String message, boolean test) {
        if (test) {
            this.fail(message);
        }
    }

    private void fail(String m) {
        throw new TestException(m);
    }

    private Proxy.Map createTestMap() {
        this.map = this.c.newMap();
        this.map.getRoot().createChild("first node");
        this.map.getRoot().createChild("second node");
        return this.map;
    }

    private Proxy.Node firstChild(Proxy.Node node) {
        return node.getChildren().get(0);
    }

    private Proxy.Node firstChild() {
        return this.firstChild(this.map.getRoot());
    }

    public void test_AttributesRO_getAll_String_name() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("all values should be found", this.list("va1", "va2", "va3"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("all values should be found", Collections.singletonList("vb1"), this.map.getRoot().getAttributes().getAll("b1"));
        this.assertEquals("should return empty list for non-existing attributes", Collections.EMPTY_LIST, this.map.getRoot().getAttributes().getAll("x"));
    }

    public void test_AttributesRO_getAttributeNames() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("all names should be found", this.list("a1", "a1", "a1", "b1"), this.map.getRoot().getAttributes().getAttributeNames());
    }

    public void test_AttributesRO_get_int_index() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("find by index", "va1", this.map.getRoot().getAttributes().get(0));
        this.assertEquals("find by index", "va2", this.map.getRoot().getAttributes().get(1));
        this.assertEquals("find by index", "va3", this.map.getRoot().getAttributes().get(2));
        this.assertEquals("find by index", "vb1", this.map.getRoot().getAttributes().get(3));
        try {
            this.map.getRoot().getAttributes().get(4);
            this.fail("expect IndexOutOfBoundsException on get(int) with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_AttributesRO_findAttribute_String_name() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("first matching attribute should be found", 0, this.map.getRoot().getAttributes().findFirst("a1"));
    }

    public void test_AttributesRO_size() {
        this.map = this.setupMapWithSomeAttributes();
        this.assertEquals("count attributes", 4, this.map.getRoot().getAttributes().size());
    }

    public void test_Attributes_set_int_index_String_value() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().set(3, (Object)"VB1");
        this.map.getRoot().getAttributes().set(1, (Object)"VA2");
        this.assertEquals("values should be updated", this.list("va1", "VA2", "va3"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("values should be updated", this.list("VB1"), this.map.getRoot().getAttributes().getAll("b1"));
        try {
            this.map.getRoot().getAttributes().set(4, (Object)"xx");
            this.fail("expect IndexOutOfBoundsException on set(int, value) with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_Attributes_set_int_index_String_name_String_value() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().set(1, "c1", "VC1");
        this.assertEquals("values should be updated", this.list("va1", "va3"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("values should be updated", 1, this.map.getRoot().getAttributes().findFirst("c1"));
        this.assertEquals("values should be updated", "VC1", this.map.getRoot().getAttributes().get(1));
        try {
            this.map.getRoot().getAttributes().set(4, "xx", "yy");
            this.fail("expect IndexOutOfBoundsException on set(int, name, value) with illegal index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_Attributes_remove_String_name() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().remove("a1");
        this.assertEquals("first matching attribute should be removed", this.list("va2", "va3"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("first matching attribute should be removed", 3, this.map.getRoot().getAttributes().size());
    }

    private <T> List<T> list(T ... args) {
        return Arrays.asList(args);
    }

    private <T> Set<T> set(T ... args) {
        return this.set(Arrays.asList(args));
    }

    private <T> Set<T> set(List<T> list) {
        TreeSet<Object> set = null;
        set = list.size() > 0 && list.get(0) instanceof Proxy.Node ? new TreeSet<NodeProxy>(this.nodeComparator) : new TreeSet<T>();
        set.addAll(list);
        return set;
    }

    public void test_Attributes_removeAll_String_name() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().removeAll("a1");
        this.assertEquals("all matching attributes should be removed", this.list(new Object[0]), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("all matching attribute should be removed", 1, this.map.getRoot().getAttributes().size());
    }

    public void test_Attributes_remove_int_index() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().remove(2);
        this.map.getRoot().getAttributes().remove(1);
        this.assertEquals("attribute should be removed", this.list("va1"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("attribute should be removed", 2, this.map.getRoot().getAttributes().size());
    }

    public void test_Attributes_set_String_name_String_value() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().set("a1", (Object)"VA1");
        this.map.getRoot().getAttributes().set("c1", (Object)"vc1");
        this.assertEquals("first matching attribute should be changed", this.list("VA1", "va2", "va3"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("attribute should be added", this.list("vc1"), this.map.getRoot().getAttributes().getAll("c1"));
        this.assertEquals("attribute should be added", 5, this.map.getRoot().getAttributes().size());
    }

    public void test_Attributes_add_String_name_String_value() {
        this.map = this.setupMapWithSomeAttributes();
        this.map.getRoot().getAttributes().add("a1", "va1");
        this.map.getRoot().getAttributes().set("c1", (Object)"vc1");
        this.assertEquals("attribute should be added", this.list("va1", "va2", "va3", "va1"), this.map.getRoot().getAttributes().getAll("a1"));
        this.assertEquals("attribute should be added", this.list("vc1"), this.map.getRoot().getAttributes().getAll("c1"));
        this.assertEquals("attribute should be added", 6, this.map.getRoot().getAttributes().size());
    }

    public void test_ControllerRO_getSelected() {
        this.map = this.c.newMap();
        this.assertEquals("new root node should be selected", this.map.getRoot(), this.c.getSelected());
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        Proxy.Node secondChild = this.map.getRoot().createChild("child 2");
        this.assertEquals("root node should still be selected after adding nodes", this.map.getRoot(), this.c.getSelected());
        this.c.selectMultipleNodes(this.list(firstChild, secondChild));
        this.assertEquals("last selected node should be returned", secondChild, this.c.getSelected());
    }

    public void test_ControllerRO_getSelecteds() {
        this.map = this.c.newMap();
        this.assertEquals("new root node should be selected", this.map.getRoot(), this.c.getSelected());
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        Proxy.Node secondChild = this.map.getRoot().createChild("child 2");
        this.assertEquals("root node should still be selected after adding nodes", this.set(this.map.getRoot()), this.set(this.c.getSelecteds()));
        this.c.selectMultipleNodes(this.list(firstChild, secondChild));
        this.assertEquals("only the nodes selected via selectMultipleNodes should be returned", this.set(firstChild, secondChild), this.set(this.c.getSelecteds()));
    }

    public void test_ControllerRO_getSortedSelection_boolean_differentSubtrees() {
    }

    public void test_ControllerRO_find_ICondition_condition() {
        this.map = this.c.newMap();
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        Proxy.Node secondChild = this.map.getRoot().createChild("child 2");
        List<Proxy.Node> found = this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 2", false));
        this.assertEquals("one matching node should be found", this.list(secondChild), found);
    }

    public void test_ControllerRO_find_Closure_closure() {
    }

    public void test_Controller_centerOnNode_Node_center() {
        this.map = this.c.newMap();
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        this.c.centerOnNode(firstChild);
    }

    public void test_Controller_select_Node_toSelect() {
        this.map = this.c.newMap();
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        Proxy.Node secondChild = this.map.getRoot().createChild("child 2");
        Proxy.Node thirdChild = this.map.getRoot().createChild("child 3");
        this.c.select(secondChild);
        Set<Proxy.Node> set = this.set(secondChild);
        Set<Proxy.Node> selected = this.set(this.c.getSelecteds());
        this.assertEquals("one node should be selected", set, selected);
        this.c.select(firstChild);
        this.assertEquals("one node should be selected", this.set(firstChild), this.set(this.c.getSelecteds()));
        this.c.select(thirdChild);
        this.assertEquals("one node should be selected", this.set(thirdChild), this.set(this.c.getSelecteds()));
    }

    public void test_Controller_selectBranch_Node_branchRoot() {
        this.map = this.c.newMap();
        Proxy.Node child1 = this.map.getRoot().createChild("child 1");
        Proxy.Node child2 = this.map.getRoot().createChild("child 2");
        Proxy.Node grandchild1 = child1.createChild("child 1.1");
        Proxy.Node grandchild2 = child1.createChild("child 1.2");
        Proxy.Node grandGrandChild = child1.createChild("child 1.1.1");
        this.c.selectBranch(child1);
        this.assertEquals("all node of the branch should be selected", this.set(child1, grandchild1, grandchild2, grandGrandChild), this.set(this.c.getSelecteds()));
        this.c.selectBranch(child2);
        this.assertEquals("one node should be selected", this.set(child2), this.set(this.c.getSelecteds()));
    }

    public void test_Controller_selectMultipleNodes_List_Node_toSelect() {
    }

    public void test_Controller_undo_redo_stuff() {
        this.map = this.c.newMap();
        this.map.getRoot().createChild("child 1");
        this.assertFalse("node should be there before undo", this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 1", false)).isEmpty());
        this.c.undo();
        this.assertTrue("node should be away after undo", this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 1", false)).isEmpty());
        this.c.redo();
        this.assertFalse("node should be there after redo", this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 1", false)).isEmpty());
        this.c.deactivateUndo();
        this.c.undo();
        this.assertTrue("node should still be there after undo since undo is deactivated", this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 1", false)).isEmpty());
    }

    public void test_Controller_setStatusInfo_String_info() {
        this.c.setStatusInfo("test statusinfo");
        this.c.setStatusInfo(null);
    }

    public void test_Controller_setStatusInfo_String_infoPanelKey_String_info() {
        String infoPanelKey = "testStatusPanel";
        this.c.setStatusInfo("testStatusPanel", "someid");
        this.c.setStatusInfo("testStatusPanel", (String)null);
    }

    public void test_Controller_setStatusInfo_String_infoPanelKey_Icon_icon() {
        List keys = FreeplaneIconUtils.listStandardIconKeys();
        this.assertTrue("find out about the available icons with FreeplaneIconUtils.listStandardIconKeys() -> " + keys, keys.contains("button_ok"));
        this.c.setStatusInfo("standard", FreeplaneIconUtils.createStandardIcon((String)"button_ok"));
        this.c.setStatusInfo(null);
    }

    public void test_Controller_setStatusInfo_String_infoPanelKey_String_info_String_iconKey() {
        List keys = FreeplaneIconUtils.listStandardIconKeys();
        String iconKey = "button_ok";
        this.assertTrue("check if FreeplaneIconUtils.listStandardIconKeys() contains 'button_ok'; list content: " + keys, keys.contains("button_ok"));
        String infoPanelKey = "standard";
        this.c.setStatusInfo("standard", "hi there!", "button_ok");
        this.c.setStatusInfo("standard", (String)null);
    }

    public void test_Controller_newMap() {
        this.map = this.c.newMap();
    }

    public void test_MapRO_getRoot() {
        this.map = this.c.newMap();
        this.assertEquals("the root node shouldn't have a parent", null, this.map.getRoot().getParent());
    }

    public void test_MapRO_node_String_id() {
        this.map = this.c.newMap();
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        String id = firstChild.getId();
        this.assertEquals("get by id returned wrong node", firstChild, this.map.node(id));
    }

    public void test_MapRO_getFile() {
        this.map = this.c.newMap();
        this.assertTrue("the file of a new map should be null", this.map.getFile() == null);
    }

    public void test_Map_close() {
        Proxy.Map originalMap = this.node.getMap();
        this.map = this.c.newMap();
        this.map.getRoot().createChild("child 1");
        this.assertFalse("a new map should have been opened", originalMap.equals(this.map));
        this.map.close(true, false);
        this.assertEquals("the original map should be selected again", originalMap.getName(), this.c.getSelected().getMap().getName());
        this.map = this.c.newMap();
    }

    public void test_Map_save() {
    }

    public void test_NodeRO_getAttributes() {
        this.createTestMap();
        this.map.getRoot().getAttributes().add("a1", "va1");
        this.assertEquals("value should be found", "va1", this.map.getRoot().getAttributes().get(0));
    }

    public void test_NodeRO_getChildPosition_Node_childNode() {
        this.map = this.c.newMap();
        Proxy.Node child1 = this.map.getRoot().createChild("child 1");
        Proxy.Node child2 = this.map.getRoot().createChild("child 2");
        this.assertEquals("wrong position", 0, this.map.getRoot().getChildPosition(child1));
        this.assertEquals("wrong position", 1, this.map.getRoot().getChildPosition(child2));
    }

    public void test_NodeRO_getChildren() {
        this.map = this.c.newMap();
        Proxy.Node child1 = this.map.getRoot().createChild("child 1");
        Proxy.Node child2 = this.map.getRoot().createChild("child 2");
        List<Proxy.Node> children = this.map.getRoot().getChildren();
        this.assertEquals("wrong children count", 2, children.size());
        this.assertEquals("wrong order", child1, children.get(0));
        this.assertEquals("wrong order", child2, children.get(1));
    }

    public void test_NodeRO_getIcons() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertTrue("by default a node has no icons", root.getIcons().getIcons().isEmpty());
        root.getIcons().add("bee");
        this.assertEquals("one icon added", 1, root.getIcons().getIcons().size());
    }

    public void test_NodeRO_getLink() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertEquals("by default a node has no links", null, root.getLink().getText());
        String url = "file://blabla.txt";
        root.getLink().setText("file://blabla.txt");
        this.assertEquals("a link should have been added", "file://blabla.txt", root.getLink().getText());
    }

    public void test_NodeRO_getMap() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertEquals("???", this.map, root.getMap());
    }

    public void test_NodeRO_getId() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertTrue("unknown node id pattern in '" + root.getId() + "'", root.getId().matches("ID_[1-9]\\d+"));
    }

    public void test_NodeRO_getNodeID() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertTrue("unknown node id pattern in '" + root.getNodeID() + "'", root.getNodeID().matches("ID_[1-9]\\d+"));
    }

    public void test_NodeRO_getNodeLevel_boolean_countHidden() {
        this.createTestMap();
        this.assertEquals("root is level 0", 0, this.map.getRoot().getNodeLevel(true));
        Proxy.Node child = this.firstChild();
        this.assertEquals("children are at level 1", 1, child.getNodeLevel(false));
        Proxy.Node grandchild = child.createChild();
        this.assertEquals("grandchildren are at level 2", 2, grandchild.getNodeLevel(false));
        this.assertEquals("grandchildren are at level 2 - countHidden only matters if there are hidden nodes", 2, grandchild.getNodeLevel(true));
    }

    public void test_NodeRO_getNote_getPlain() {
        this.map = this.c.newMap();
        Proxy.Node rootNode = this.map.getRoot();
        String plainText = " xx\nx ";
        rootNode.setNote(" xx\nx ");
        this.assertEquals("", HtmlUtils.plainToHTML((String)" xx\nx "), rootNode.getNoteText());
        this.assertEquals("", HtmlUtils.plainToHTML((String)" xx\nx "), rootNode.getNote().getText());
        this.assertEquals("", " xx\nx ", rootNode.getNote().getPlain());
        String xml = "<x> yyy </x>";
        rootNode.setNote("<x> yyy </x>");
        this.assertEquals("", HtmlUtils.plainToHTML((String)"<x> yyy </x>"), rootNode.getNoteText());
        this.assertEquals("", HtmlUtils.plainToHTML((String)"<x> yyy </x>"), rootNode.getNote().getText());
        this.assertEquals("", "<x> yyy </x>", rootNode.getNote().getPlain());
        rootNode.setNote("<html> <em>zzzzz</em> </hmtl>");
        this.assertEquals("", "zzzzz", rootNode.getNote().getPlain());
    }

    public void test_NodeRO_getNote() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        root.setNote(" xxx ");
        this.assertEquals("", HtmlUtils.plainToHTML((String)" xxx "), root.getNote().getText());
        this.assertEquals("", HtmlUtils.plainToHTML((String)" xxx "), root.getNoteText());
        root.setNote(" x\nxx ");
        this.assertEquals("", HtmlUtils.plainToHTML((String)" x\nxx "), root.getNote().getText());
        this.assertEquals("", HtmlUtils.plainToHTML((String)" x\nxx "), root.getNoteText());
    }

    public void test_NodeRO_getParent() {
        this.createTestMap();
        Proxy.Node root = this.map.getRoot();
        this.assertEquals("root has no parent", null, root.getParent());
        Proxy.Node child = this.firstChild(root);
        this.assertEquals("", root, child.getParent());
    }

    public void test_NodeRO_getPlainText() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        String plainText = " xxx ";
        root.setText(" xxx ");
        this.assertEquals("", " xxx ", root.getText());
        this.assertEquals("plain text should be kept untouched", " xxx ", root.getPlainText());
        String xml = "<x> yyy </x>";
        root.setText("<x> yyy </x>");
        this.assertEquals("xml tags are not stripped", "<x> yyy </x>", root.getPlainText());
        root.setText("<html> <em>zzzzz</em> </hmtl>");
        this.assertEquals("html tags should be stripped", "zzzzz", root.getPlainText());
    }

    public void test_NodeRO_getPlainTextContent() {
    }

    public void test_NodeRO_getText() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        root.setText(" xxx ");
        this.assertEquals("", " xxx ", root.getText());
        root.setText(" x\nxx ");
        this.assertEquals("", " x\nxx ", root.getText());
    }

    public void test_NodeRO_isDescendantOf_Node_p() {
        this.createTestMap();
        Proxy.Node root = this.map.getRoot();
        this.assertTrue("a node is its own descendant", root.isDescendantOf(root));
        this.assertFalse("siblings aren't descendants of each other", this.firstChild(root).isDescendantOf(root.getChildren().get(1)));
        this.assertFalse("siblings aren't descendants of each other", root.getChildren().get(1).isDescendantOf(this.firstChild(root)));
        this.assertTrue("children are descendants of their parents", this.firstChild(root).isDescendantOf(root));
        Proxy.Node grandchild = this.firstChild(root).createChild();
        this.assertTrue("grandchildren are descendants of their parents", this.firstChild(root).isDescendantOf(root));
        this.assertTrue("grandchildren are descendants of their grandparents", grandchild.isDescendantOf(root));
    }

    public void test_NodeRO_isFolded() {
        this.createTestMap();
        Proxy.Node root = this.map.getRoot();
        Proxy.Node child = this.firstChild();
        Proxy.Node grandchild = child.createChild("grandchild");
        this.assertFalse("initially nothing should be folded", root.isFolded());
        this.assertFalse("initially nothing should be folded", child.isFolded());
        root.setFolded(true);
        this.assertFalse("root isn't foldable", root.isFolded());
        child.setFolded(true);
        this.assertTrue("node should be folded now", child.isFolded());
        this.assertFalse("folding is not recursive in terms of isFolded()", grandchild.isFolded());
        child.setFolded(false);
        this.assertFalse("node should be unfolded again", child.isFolded());
        grandchild.setFolded(true);
        this.assertFalse("a node without children is not foldable", grandchild.isFolded());
        grandchild.createChild("grandgrandchild");
        grandchild.setFolded(true);
        this.assertTrue("node should be folded now", grandchild.isFolded());
        this.c.undo();
        this.assertFalse("folding should be undone now", grandchild.isFolded());
    }

    public void test_NodeRO_isLeaf() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        this.assertTrue("even root is a leaf, if single", root.isLeaf());
        root.createChild("child");
        this.assertFalse("root is never a leaf, even without children", root.isLeaf());
        this.assertTrue("child without children should be leaf", this.firstChild(root).isLeaf());
        this.firstChild(root).createChild("grandchild");
        this.assertFalse("child with children is not a leaf", this.firstChild(root).isLeaf());
    }

    public void test_NodeRO_isRoot() {
        this.createTestMap();
        this.assertTrue("root has no parent", this.map.getRoot().getParent() == null);
    }

    public void test_NodeRO_isVisible() {
        this.map = this.c.newMap();
        this.map.getRoot().createChild("first node");
        this.map.getRoot().createChild("second node");
        this.assertTrue("initially all nodes should be visible", this.firstChild().isVisible());
        new Filter((ICondition)new NodeContainsCondition("filter_node", "first", false), true, true, true).applyFilter((Object)this, Controller.getCurrentController().getMap(), true);
        this.assertTrue("first node should be  matched by the filter", this.firstChild().isVisible());
        this.assertFalse("second node should not be matched by the filter", this.map.getRoot().getChildren().get(1).isVisible());
        this.c.setStatusInfo("filter", (String)null);
    }

    public void test_NodeRO_find_ICondition_condition() {
        this.map = this.c.newMap();
        Proxy.Node firstChild = this.map.getRoot().createChild("child 1");
        Proxy.Node secondChild = this.map.getRoot().createChild("child 2");
        List<Proxy.Node> found = this.c.find((ICondition)new NodeContainsCondition("filter_node", "child 2", false));
        this.assertEquals("one matching node should be found", this.list(secondChild), found);
    }

    public void test_NodeRO_getLastModifiedAt() {
        this.map = this.c.newMap();
        Proxy.Node child = this.map.getRoot().createChild("a node");
        Date initialLastModifiedAt = child.getLastModifiedAt();
        long diff = System.currentTimeMillis() - initialLastModifiedAt.getTime();
        this.assertTrue("lastModifiedAt seems to be set incorrectly. It says it's " + diff + " ms ago", diff >= 0L && diff < 1000L);
        diff = initialLastModifiedAt.getTime() - child.getCreatedAt().getTime();
        this.assertTrue("modifiedAt and createdAt should be set nearly to the same timestamp initially but modifiedAt = " + initialLastModifiedAt.getTime() + ", createdAt = " + child.getCreatedAt().getTime(), diff >= 0L && diff < 50L);
        Date epoch = new Date(0L);
        child.setLastModifiedAt(epoch);
        child.setText("changed");
        this.assertTrue("lastModifiedAt should be changed after changing the node text", child.getLastModifiedAt().after(epoch));
    }

    public void test_NodeRO_getCreatedAt() {
        this.map = this.c.newMap();
        Proxy.Node child = this.map.getRoot().createChild("a node");
        Date initialCreatedAt = child.getCreatedAt();
        long diff = System.currentTimeMillis() - initialCreatedAt.getTime();
        this.assertTrue("createdAt seems to be set incorrectly. It says it's " + diff + " ms ago", diff >= 0L && diff < 1000L);
        Date epoch = new Date(0L);
        child.setCreatedAt(epoch);
        child.setText("changed");
        this.assertEquals("createdAt should not be changed after changing the node text", epoch, child.getCreatedAt());
    }

    public void test_Node_createChild() {
        this.map = this.c.newMap();
        this.assertEquals("", 0, this.map.getRoot().getChildren().size());
        this.map.getRoot().createChild();
        this.assertEquals("child should be created", 1, this.map.getRoot().getChildren().size());
    }

    public void test_Node_createChild_int_position() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        Proxy.Node child1 = root.createChild("child 1");
        Proxy.Node child2 = root.createChild("child 2");
        this.assertEquals("wrong position", 0, root.getChildPosition(child1));
        this.assertEquals("wrong position", 1, root.getChildPosition(child2));
        Proxy.Node child3 = root.createChild(0);
        this.assertEquals("wrong insert position", 0, root.getChildPosition(child3));
        this.assertEquals("node should be shifted", 1, root.getChildPosition(child1));
        this.assertEquals("node should be shifted", 2, root.getChildPosition(child2));
        Proxy.Node child4 = root.createChild(3);
        this.assertEquals("wrong insert position", 3, root.getChildPosition(child4));
        this.assertEquals("node should be shifted", 0, root.getChildPosition(child3));
        this.assertEquals("node should be shifted", 1, root.getChildPosition(child1));
        try {
            root.createChild(-1);
            this.fail("a negative position should lead to an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            root.createChild(5);
            this.fail("too large positions should lead to an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void test_Node_delete() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        Proxy.Node child1 = root.createChild("child 1");
        Proxy.Node child2 = root.createChild("child 2");
        this.assertEquals("", 2, root.getChildren().size());
        child1.delete();
        this.assertEquals("deletion failed", 1, root.getChildren().size());
        this.assertEquals("wrong node deleted", child2, root.getChildren().get(0));
    }

    public void test_Node_moveTo_Node_parentNode() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        Proxy.Node child1 = root.createChild("child 1");
        Proxy.Node child2 = root.createChild("child 2");
        Proxy.Node grandchild = child1.createChild("grandchild");
        this.assertEquals("child2 should have no children", 0, child2.getChildren().size());
        grandchild.moveTo(child2);
        this.assertEquals("grandchild should be a child of child2 now", child2, grandchild.getParent());
    }

    public void test_Node_moveTo_Node_parentNode_int_position() {
        this.map = this.c.newMap();
        Proxy.Node root = this.map.getRoot();
        Proxy.Node child1 = root.createChild("child 1");
        Proxy.Node child2 = root.createChild("child 2");
        Proxy.Node grandchild = child1.createChild("grandchild");
        this.assertEquals("wrong count of children", 2, root.getChildren().size());
        grandchild.moveTo(root, 1);
        this.assertEquals("wrong position", child1, root.getChildren().get(0));
        this.assertEquals("wrong position", grandchild, root.getChildren().get(1));
        this.assertEquals("wrong position", child2, root.getChildren().get(2));
    }

    public void test_Node_setFolded_boolean_folded() {
        this.createTestMap();
        Proxy.Node child = this.firstChild();
        child.createChild("grandchild");
        child.setFolded(true);
        this.assertTrue("node should be folded now", child.isFolded());
        child.setFolded(false);
        this.assertFalse("node should be unfolded again", child.isFolded());
    }

    public void test_Node_setPlainNote_String_text() {
    }

    public void test_Node_setNoteText_String_text() {
    }

    public void test_Node_setText_String_text() {
    }

    public void test_Node_setLastModifiedAt_Date_date() {
    }

    public void test_Node_setCreatedAt_Date_date() {
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String message, Throwable cause) {
            super(message, cause);
        }

        public TestException(String message) {
            super(message);
        }
    }
}

