/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.jsyntaxpane;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class NodeIdHighLighter
implements SyntaxComponent,
CaretListener {
    private final Pattern nodeIdPattern = Pattern.compile("(ID_\\d+)|(\"ID_\\d+\")");
    private JEditorPane pane;
    private Status status;
    private ArrayList<NodeModel> nodesOriginallyFolded = new ArrayList(50);
    private NodeModel originallySelectedNode = null;

    @Override
    public void caretUpdate(CaretEvent e) {
        this.handle(e.getDot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(int pos) {
        SyntaxDocument doc = ActionUtils.getSyntaxDocument((JTextComponent)this.pane);
        if (doc != null) {
            try {
                doc.readLock();
                Token token = doc.getTokenAt(pos);
                if (token == null || !this.handle(doc, token)) {
                    this.deHighlight();
                }
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private boolean handle(SyntaxDocument doc, Token token) {
        Matcher matcher = this.nodeIdPattern.matcher(token.getText((Document)doc));
        if (matcher.matches()) {
            String id = matcher.group(1);
            NodeModel node = Controller.getCurrentController().getMap().getNodeForID(id);
            if (node != null) {
                MapController mapController = Controller.getCurrentModeController().getMapController();
                NodeModel selectedNode = mapController.getSelectedNode();
                if (node.equals(selectedNode)) {
                    return true;
                }
                NodeModel originallySelectedNode = this.originallySelectedNode;
                if (originallySelectedNode == null) {
                    originallySelectedNode = mapController.getSelectedNode();
                } else {
                    this.deHighlight();
                }
                this.originallySelectedNode = originallySelectedNode;
                mapController.displayNode(node, this.nodesOriginallyFolded);
                mapController.select(node);
                this.pane.setToolTipText(node.getText());
                return true;
            }
            this.pane.setToolTipText("<html><body bgcolor='#CC0000'>" + TextUtils.format((String)this.getResourceKey("node_is_not_defined"), (Object[])new Object[]{id}) + "</body></html>");
        } else {
            this.deHighlight();
        }
        return false;
    }

    public void deHighlight() {
        if (this.originallySelectedNode == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return;
        }
        MapController mapController = controller.getModeController().getMapController();
        mapController.displayNode(this.originallySelectedNode);
        mapController.select(this.originallySelectedNode);
        this.foldOriginallyFolded(mapController);
        this.originallySelectedNode = null;
        this.pane.setToolTipText(null);
    }

    private void foldOriginallyFolded(MapController mapController) {
        int countNodesOriginallyUnfolded = this.nodesOriginallyFolded.size();
        if (countNodesOriginallyUnfolded > 0) {
            for (int i = countNodesOriginallyUnfolded - 1; i >= 0; --i) {
                mapController.setFolded(this.nodesOriginallyFolded.get(i), true);
            }
            this.nodesOriginallyFolded.clear();
        }
    }

    public void config(Configuration config) {
    }

    public void install(JEditorPane editor) {
        this.pane = editor;
        this.pane.addCaretListener(this);
        this.handle(editor.getCaretPosition());
        this.status = Status.INSTALLING;
        this.addWindowListener();
    }

    private void addWindowListener() {
        this.pane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                SwingUtilities.getWindowAncestor(NodeIdHighLighter.this.pane).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        e.getWindow().removeWindowListener(this);
                        NodeIdHighLighter.this.deHighlight();
                    }
                });
            }
        });
    }

    public void deinstall(JEditorPane editor) {
        this.status = Status.DEINSTALLING;
        this.deHighlight();
        this.pane.removeCaretListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            this.pane.removeCaretListener(this);
            if (this.status.equals((Object)Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.deHighlight();
            }
        }
    }

    public String getResourceKey(String key) {
        return "org.freeplane.plugin.script.NodeIdHighlighter." + key;
    }

    private static enum Status {
        INSTALLING,
        DEINSTALLING;

    }
}

