/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class TitledPickList
extends JPanel
implements ListSelectionListener,
CaretListener,
FocusListener,
KeyListener {
    private final JTextField choice;
    boolean ignoreTextChanges = false;
    private final JList optionsList;
    private final Vector listeners = new Vector(0);

    public TitledPickList(String[] options, String titleText) {
        super(new BorderLayout());
        this.choice = new JTextField();
        this.choice.addCaretListener(this);
        this.choice.addFocusListener(this);
        this.choice.addKeyListener(this);
        this.optionsList = new JList<String>(options);
        this.optionsList.setSelectionMode(0);
        this.optionsList.addListSelectionListener(this);
        JScrollPane scrollableList = new JScrollPane(this.optionsList);
        JPanel pickListPanel = new JPanel(new BorderLayout());
        pickListPanel.add((Component)this.choice, "North");
        pickListPanel.add((Component)scrollableList, "Center");
        JLabel title = new JLabel();
        title.setText(titleText);
        this.add((Component)title, "North");
        this.add((Component)pickListPanel, "Center");
    }

    @Override
    public void caretUpdate(CaretEvent ce) {
        if (!this.ignoreTextChanges && this.choice.hasFocus()) {
            ListModel model = this.optionsList.getModel();
            String key = this.choice.getText().toLowerCase();
            if (key != null) {
                int i = 0;
                int modelSize = model.getSize();
                String listEntry = (String)model.getElementAt(i);
                while (++i < modelSize && !listEntry.toLowerCase().startsWith(key)) {
                    listEntry = (String)model.getElementAt(i);
                }
                if (i < modelSize) {
                    this.optionsList.setSelectedValue(listEntry, true);
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateTextFromList();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.updateTextFromList();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void updateTextFromList() {
        Object value = this.optionsList.getSelectedValue();
        if (value != null) {
            this.choice.setText(value.toString());
        }
    }

    public Object getSelection() {
        return this.optionsList.getSelectedValue();
    }

    public void setSelection(Object value) {
        this.optionsList.setSelectedValue(value.toString(), true);
        this.updateTextFromList();
    }

    public void setSelection(int index) {
        this.optionsList.setSelectedIndex(index);
        this.updateTextFromList();
    }

    public int getIndex() {
        return this.optionsList.getSelectedIndex();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.optionsList.hasFocus()) {
            this.updateTextFromList();
        }
        this.fireValueChanged();
    }

    public void addTitledPickListListener(TitledPickListListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeTitledPickListListener(TitledPickListListener listener) {
        this.listeners.removeElement(listener);
    }

    void fireValueChanged() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((TitledPickListListener)listenerList.nextElement()).valueChanged(new TitledPickListEvent(this));
        }
    }

    static interface TitledPickListListener
    extends EventListener {
        public void valueChanged(TitledPickListEvent var1);
    }

    class TitledPickListEvent
    extends EventObject {
        public TitledPickListEvent(Object source) {
            super(source);
        }
    }
}

