/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.playlist.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jlgui.player.amp.PlayerUI;
import javazoom.jlgui.player.amp.playlist.Playlist;
import javazoom.jlgui.player.amp.playlist.PlaylistItem;
import javazoom.jlgui.player.amp.skin.AbsoluteLayout;
import javazoom.jlgui.player.amp.skin.ActiveJButton;
import javazoom.jlgui.player.amp.skin.DropTargetAdapter;
import javazoom.jlgui.player.amp.skin.Skin;
import javazoom.jlgui.player.amp.skin.UrlDialog;
import javazoom.jlgui.player.amp.tag.TagInfo;
import javazoom.jlgui.player.amp.tag.TagInfoFactory;
import javazoom.jlgui.player.amp.tag.ui.TagInfoDialog;
import javazoom.jlgui.player.amp.util.Config;
import javazoom.jlgui.player.amp.util.FileSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlaylistUI
extends JPanel
implements ActionListener,
ChangeListener {
    private static Log log = LogFactory.getLog((Class)PlaylistUI.class);
    public static int MAXDEPTH = 4;
    private Config config = null;
    private Skin ui = null;
    private Playlist playlist = null;
    private PlayerUI player = null;
    private int topIndex = 0;
    private int currentSelection = -1;
    private Vector exts = null;
    private boolean isSearching = false;
    private JPopupMenu fipopup = null;

    public PlaylistUI() {
        this.setDoubleBuffered(true);
        this.setLayout(new AbsoluteLayout());
        this.config = Config.getInstance();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PlaylistUI.this.handleMouseClick(mouseEvent);
            }
        });
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            public void processDrop(Object object) {
                PlaylistUI.this.processDnD(object);
            }
        };
        DropTarget dropTarget = new DropTarget(this, 1, dropTargetAdapter, true);
    }

    public void setPlayer(PlayerUI playerUI) {
        this.player = playerUI;
    }

    public void setSkin(Skin skin) {
        this.ui = skin;
    }

    public Skin getSkin() {
        return this.ui;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public void loadUI() {
        int n;
        this.removeAll();
        this.ui.getPlaylistPanel().setParent(this);
        this.add((Component)this.ui.getAcPlSlider(), this.ui.getAcPlSlider().getConstraints());
        this.ui.getAcPlSlider().setValue(100);
        this.ui.getAcPlSlider().removeChangeListener(this);
        this.ui.getAcPlSlider().addChangeListener(this);
        this.add((Component)this.ui.getAcPlUp(), this.ui.getAcPlUp().getConstraints());
        this.ui.getAcPlUp().removeActionListener(this);
        this.ui.getAcPlUp().addActionListener(this);
        this.add((Component)this.ui.getAcPlDown(), this.ui.getAcPlDown().getConstraints());
        this.ui.getAcPlDown().removeActionListener(this);
        this.ui.getAcPlDown().addActionListener(this);
        this.add((Component)this.ui.getAcPlAdd(), this.ui.getAcPlAdd().getConstraints());
        this.ui.getAcPlAdd().removeActionListener(this);
        this.ui.getAcPlAdd().addActionListener(this);
        this.add((Component)this.ui.getAcPlAddPopup(), this.ui.getAcPlAddPopup().getConstraints());
        this.ui.getAcPlAddPopup().setVisible(false);
        ActiveJButton[] activeJButtonArray = this.ui.getAcPlAddPopup().getItems();
        for (n = 0; n < activeJButtonArray.length; ++n) {
            activeJButtonArray[n].addActionListener(this);
        }
        this.add((Component)this.ui.getAcPlRemove(), this.ui.getAcPlRemove().getConstraints());
        this.ui.getAcPlRemove().removeActionListener(this);
        this.ui.getAcPlRemove().addActionListener(this);
        this.add((Component)this.ui.getAcPlRemovePopup(), this.ui.getAcPlRemovePopup().getConstraints());
        this.ui.getAcPlRemovePopup().setVisible(false);
        activeJButtonArray = this.ui.getAcPlRemovePopup().getItems();
        for (n = 0; n < activeJButtonArray.length; ++n) {
            activeJButtonArray[n].removeActionListener(this);
            activeJButtonArray[n].addActionListener(this);
        }
        this.add((Component)this.ui.getAcPlSelect(), this.ui.getAcPlSelect().getConstraints());
        this.ui.getAcPlSelect().removeActionListener(this);
        this.ui.getAcPlSelect().addActionListener(this);
        this.add((Component)this.ui.getAcPlSelectPopup(), this.ui.getAcPlSelectPopup().getConstraints());
        this.ui.getAcPlSelectPopup().setVisible(false);
        activeJButtonArray = this.ui.getAcPlSelectPopup().getItems();
        for (n = 0; n < activeJButtonArray.length; ++n) {
            activeJButtonArray[n].removeActionListener(this);
            activeJButtonArray[n].addActionListener(this);
        }
        this.add((Component)this.ui.getAcPlMisc(), this.ui.getAcPlMisc().getConstraints());
        this.ui.getAcPlMisc().removeActionListener(this);
        this.ui.getAcPlMisc().addActionListener(this);
        this.add((Component)this.ui.getAcPlMiscPopup(), this.ui.getAcPlMiscPopup().getConstraints());
        this.ui.getAcPlMiscPopup().setVisible(false);
        activeJButtonArray = this.ui.getAcPlMiscPopup().getItems();
        for (n = 0; n < activeJButtonArray.length; ++n) {
            activeJButtonArray[n].removeActionListener(this);
            activeJButtonArray[n].addActionListener(this);
        }
        this.add((Component)this.ui.getAcPlList(), this.ui.getAcPlList().getConstraints());
        this.ui.getAcPlList().removeActionListener(this);
        this.ui.getAcPlList().addActionListener(this);
        this.add((Component)this.ui.getAcPlListPopup(), this.ui.getAcPlListPopup().getConstraints());
        this.ui.getAcPlListPopup().setVisible(false);
        activeJButtonArray = this.ui.getAcPlListPopup().getItems();
        for (n = 0; n < activeJButtonArray.length; ++n) {
            activeJButtonArray[n].removeActionListener(this);
            activeJButtonArray[n].addActionListener(this);
        }
        this.fipopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.ui.getResource("playlist.popup.info"));
        jMenuItem.setActionCommand("InfoPL");
        jMenuItem.removeActionListener(this);
        jMenuItem.addActionListener(this);
        this.fipopup.add(jMenuItem);
        this.fipopup.addSeparator();
        jMenuItem = new JMenuItem(this.ui.getResource("playlist.popup.play"));
        jMenuItem.setActionCommand("PlayPL");
        jMenuItem.removeActionListener(this);
        jMenuItem.addActionListener(this);
        this.fipopup.add(jMenuItem);
        this.fipopup.addSeparator();
        jMenuItem = new JMenuItem(this.ui.getResource("playlist.popup.remove"));
        jMenuItem.setActionCommand("RemovePL");
        jMenuItem.removeActionListener(this);
        jMenuItem.addActionListener(this);
        this.fipopup.add(jMenuItem);
        this.validate();
        this.repaint();
    }

    public void initPlayList() {
        this.topIndex = 0;
        this.nextCursor();
    }

    public void nextCursor() {
        this.currentSelection = this.playlist.getSelectedIndex();
        int n = this.playlist.getPlaylistSize();
        int n2 = this.ui.getPlaylistPanel().getLines();
        while (this.currentSelection - this.topIndex > n2 - 1) {
            this.topIndex += 2;
        }
        if (this.topIndex >= n) {
            this.topIndex = n - 1;
        }
        while (this.currentSelection < this.topIndex) {
            this.topIndex -= 2;
        }
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        this.resetScrollBar();
        this.repaint();
    }

    protected int getIndex(int n) {
        int n2 = this.playlist.getPlaylistSize();
        if (n2 == 0) {
            return -1;
        }
        for (int i = 0; i < 100; ++i) {
            if (!this.ui.getPlaylistPanel().isIndexArea(n, i)) continue;
            if (this.topIndex + i > n2 - 1) {
                return -1;
            }
            return this.topIndex + i;
        }
        return -1;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.ui.getAcPlSlider()) {
            int n = this.playlist.getPlaylistSize();
            float f = (float)(100 - this.ui.getAcPlSlider().getValue()) / 100.0f;
            int n2 = (int)(f * (float)(n - 1));
            if (n2 != this.topIndex) {
                this.topIndex = n2;
                this.paintList();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final ActionEvent actionEvent2 = actionEvent;
        new Thread("PlaylistUIActionEvent"){

            public void run() {
                PlaylistUI.this.processActionEvent(actionEvent2);
            }
        }.start();
    }

    public void processActionEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        log.debug((Object)("Action=" + string + " (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        int n = this.playlist.getPlaylistSize();
        if (string.equals("ScrollUpPL")) {
            --this.topIndex;
            if (this.topIndex < 0) {
                this.topIndex = 0;
            }
            this.resetScrollBar();
            this.paintList();
        } else if (string.equals("ScrollDownPL")) {
            ++this.topIndex;
            if (this.topIndex > n - 1) {
                this.topIndex = n - 1;
            }
            this.resetScrollBar();
            this.paintList();
        } else if (string.equals("AddPopupPL")) {
            this.ui.getAcPlAdd().setVisible(false);
            this.ui.getAcPlAddPopup().setVisible(true);
        } else if (string.equals("RemovePopupPL")) {
            this.ui.getAcPlRemove().setVisible(false);
            this.ui.getAcPlRemovePopup().setVisible(true);
        } else if (string.equals("SelectPopupPL")) {
            this.ui.getAcPlSelect().setVisible(false);
            this.ui.getAcPlSelectPopup().setVisible(true);
        } else if (string.equals("MiscPopupPL")) {
            this.ui.getAcPlMisc().setVisible(false);
            this.ui.getAcPlMiscPopup().setVisible(true);
        } else if (string.equals("ListPopupPL")) {
            this.ui.getAcPlList().setVisible(false);
            this.ui.getAcPlListPopup().setVisible(true);
        } else if (string.equals("InfoPL")) {
            this.popupFileInfo();
        } else if (string.equals("PlayPL")) {
            int n2 = this.playlist.getPlaylistSize();
            PlaylistItem playlistItem = null;
            for (int i = n2 - 1; i >= 0 && !(playlistItem = this.playlist.getItemAt(i)).isSelected(); --i) {
            }
            if (playlistItem != null && playlistItem.getTagInfo() != null) {
                this.player.pressStop();
                this.player.setCurrentSong(playlistItem);
                this.playlist.setCursor(this.playlist.getIndex(playlistItem));
                this.player.pressStart();
            }
        } else if (string.equals("RemovePL")) {
            this.delSelectedItems();
        } else if (string.equals("AddFilePL")) {
            this.ui.getAcPlAddPopup().setVisible(false);
            this.ui.getAcPlAdd().setVisible(true);
            File[] fileArray = FileSelector.selectFile(this.player.getLoader(), 1, true, this.config.getExtensions(), this.ui.getResource("playlist.popup.add.file"), new File(this.config.getLastDir()));
            if (FileSelector.getInstance().getDirectory() != null) {
                this.config.setLastDir(FileSelector.getInstance().getDirectory().getPath());
            }
            this.addFiles(fileArray);
        } else if (string.equals("AddURLPL")) {
            this.ui.getAcPlAddPopup().setVisible(false);
            this.ui.getAcPlAdd().setVisible(true);
            UrlDialog urlDialog = new UrlDialog(this.config.getTopParent(), this.ui.getResource("playlist.popup.add.url"), this.player.getLoader().getLocation().x, this.player.getLoader().getLocation().y + this.player.getHeight(), null);
            urlDialog.show();
            if (urlDialog.getFile() != null) {
                PlaylistItem playlistItem = new PlaylistItem(urlDialog.getFile(), urlDialog.getURL(), -1L, false);
                this.playlist.appendItem(playlistItem);
                this.resetScrollBar();
                this.repaint();
            }
        } else if (string.equals("AddDirPL")) {
            this.ui.getAcPlAddPopup().setVisible(false);
            this.ui.getAcPlAdd().setVisible(true);
            File[] fileArray = FileSelector.selectFile(this.player.getLoader(), 4, false, "", this.ui.getResource("playlist.popup.add.dir"), new File(this.config.getLastDir()));
            if (FileSelector.getInstance().getDirectory() != null) {
                this.config.setLastDir(FileSelector.getInstance().getDirectory().getPath());
            }
            if (fileArray == null || !fileArray[0].isDirectory()) {
                return;
            }
            this.addDir(fileArray[0]);
        } else if (string.equals("RemoveAllPL")) {
            this.ui.getAcPlRemovePopup().setVisible(false);
            this.ui.getAcPlRemove().setVisible(true);
            this.delAllItems();
        } else if (string.equals("RemoveSelPL")) {
            this.ui.getAcPlRemovePopup().setVisible(false);
            this.ui.getAcPlRemove().setVisible(true);
            this.delSelectedItems();
        } else if (string.equals("RemoveMiscPL")) {
            this.ui.getAcPlRemovePopup().setVisible(false);
            this.ui.getAcPlRemove().setVisible(true);
        } else if (string.equals("RemoveCropPL")) {
            this.ui.getAcPlRemovePopup().setVisible(false);
            this.ui.getAcPlRemove().setVisible(true);
        } else if (string.equals("SelectAllPL")) {
            this.ui.getAcPlSelectPopup().setVisible(false);
            this.ui.getAcPlSelect().setVisible(true);
            this.selFunctions(1);
        } else if (string.equals("SelectInvPL")) {
            this.ui.getAcPlSelectPopup().setVisible(false);
            this.ui.getAcPlSelect().setVisible(true);
            this.selFunctions(-1);
        } else if (string.equals("SelectZeroPL")) {
            this.ui.getAcPlSelectPopup().setVisible(false);
            this.ui.getAcPlSelect().setVisible(true);
            this.selFunctions(0);
        } else if (string.equals("MiscOptsPL")) {
            this.ui.getAcPlMiscPopup().setVisible(false);
            this.ui.getAcPlMisc().setVisible(true);
        } else if (string.equals("MiscFilePL")) {
            this.ui.getAcPlMiscPopup().setVisible(false);
            this.ui.getAcPlMisc().setVisible(true);
            this.popupFileInfo();
        } else if (string.equals("MiscSortPL")) {
            this.ui.getAcPlMiscPopup().setVisible(false);
            this.ui.getAcPlMisc().setVisible(true);
        } else if (string.equals("ListLoadPL")) {
            String string2;
            this.ui.getAcPlListPopup().setVisible(false);
            this.ui.getAcPlList().setVisible(true);
            File[] fileArray = FileSelector.selectFile(this.player.getLoader(), 1, true, this.config.getExtensions(), this.ui.getResource("playlist.popup.list.load"), new File(this.config.getLastDir()));
            if (FileSelector.getInstance().getDirectory() != null) {
                this.config.setLastDir(FileSelector.getInstance().getDirectory().getPath());
            }
            if (fileArray != null && fileArray[0] != null && ((string2 = fileArray[0].getName()).toLowerCase().endsWith(this.ui.getResource("playlist.extension.m3u")) || string2.toLowerCase().endsWith(this.ui.getResource("playlist.extension.pls")))) {
                if (this.player.loadPlaylist(this.config.getLastDir() + string2)) {
                    this.config.setPlaylistFilename(this.config.getLastDir() + string2);
                    this.playlist.begin();
                    this.playlist.setCursor(-1);
                    this.topIndex = 0;
                }
                this.resetScrollBar();
                this.repaint();
            }
        } else if (string.equals("ListSavePL")) {
            this.ui.getAcPlListPopup().setVisible(false);
            this.ui.getAcPlList().setVisible(true);
        } else if (string.equals("ListNewPL")) {
            this.ui.getAcPlListPopup().setVisible(false);
            this.ui.getAcPlList().setVisible(true);
        }
    }

    public void popupFileInfo() {
        int n = this.playlist.getPlaylistSize();
        PlaylistItem playlistItem = null;
        for (int i = n - 1; i >= 0 && !(playlistItem = this.playlist.getItemAt(i)).isSelected(); --i) {
        }
        if (playlistItem != null) {
            TagInfo tagInfo = playlistItem.getTagInfo();
            TagInfoFactory tagInfoFactory = TagInfoFactory.getInstance();
            TagInfoDialog tagInfoDialog = tagInfoFactory.getTagInfoDialog(tagInfo);
            tagInfoDialog.setLocation(this.player.getLoader().getLocation().x, this.player.getLoader().getLocation().y + this.player.getHeight());
            tagInfoDialog.show();
        }
    }

    private void selFunctions(int n) {
        PlaylistItem playlistItem;
        int n2 = this.playlist.getPlaylistSize();
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2 && (playlistItem = this.playlist.getItemAt(i)) != null; ++i) {
            if (n == -1) {
                playlistItem.setSelected(!playlistItem.isSelected());
                continue;
            }
            if (n == 0) {
                playlistItem.setSelected(false);
                continue;
            }
            if (n != 1) continue;
            playlistItem.setSelected(true);
        }
        this.repaint();
    }

    private void delAllItems() {
        int n = this.playlist.getPlaylistSize();
        if (n == 0) {
            return;
        }
        this.playlist.removeAllItems();
        this.topIndex = 0;
        this.ui.getAcPlSlider().setValue(100);
        this.repaint();
    }

    private void delSelectedItems() {
        int n;
        int n2 = this.playlist.getPlaylistSize();
        boolean bl = false;
        for (n = n2 - 1; n >= 0; --n) {
            if (!this.playlist.getItemAt(n).isSelected()) continue;
            this.playlist.removeItemAt(n);
            bl = true;
        }
        if (bl) {
            n = this.playlist.getPlaylistSize();
            if (this.topIndex >= n) {
                this.topIndex = n - 1;
            }
            if (this.topIndex < 0) {
                this.topIndex = 0;
            }
            this.resetScrollBar();
            this.repaint();
        }
    }

    public void addFiles(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (string.toLowerCase().endsWith(this.ui.getResource("skin.extension")) || string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.m3u")) || string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.pls"))) continue;
                PlaylistItem playlistItem = new PlaylistItem(string, fileArray[i].getAbsolutePath(), -1L, true);
                this.playlist.appendItem(playlistItem);
                this.resetScrollBar();
                this.repaint();
            }
        }
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.ui.getAcPlAddPopup().setVisible(false);
        this.ui.getAcPlAdd().setVisible(true);
        this.ui.getAcPlRemovePopup().setVisible(false);
        this.ui.getAcPlRemove().setVisible(true);
        this.ui.getAcPlSelectPopup().setVisible(false);
        this.ui.getAcPlSelect().setVisible(true);
        this.ui.getAcPlMiscPopup().setVisible(false);
        this.ui.getAcPlMisc().setVisible(true);
        this.ui.getAcPlListPopup().setVisible(false);
        this.ui.getAcPlList().setVisible(true);
        if (this.ui.getPlaylistPanel().isInSelectArea(n2, n3) && (n = this.getIndex(n3)) != -1) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (this.fipopup != null) {
                    this.fipopup.show(this, n2, n3);
                }
            } else {
                PlaylistItem playlistItem = this.playlist.getItemAt(n);
                if (playlistItem != null) {
                    playlistItem.setSelected(!playlistItem.isSelected());
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                        this.player.pressStop();
                        this.player.setCurrentSong(playlistItem);
                        this.playlist.setCursor(n);
                        this.player.pressStart();
                    }
                }
            }
            this.repaint();
        }
    }

    public void processDnD(Object object) {
        log.debug((Object)"Playlist DnD");
        if (object instanceof List) {
            List list = (List)object;
            if (list != null && list.size() > 0) {
                ArrayList<File> arrayList = new ArrayList<File>();
                ArrayList<File> arrayList2 = new ArrayList<File>();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    File file = (File)listIterator.next();
                    if (!file.exists() || !file.canRead()) continue;
                    if (file.isFile()) {
                        arrayList.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    arrayList2.add(file);
                }
                this.addFiles(arrayList);
                this.addDirs(arrayList2);
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                ArrayList<File> arrayList = new ArrayList<File>();
                ArrayList<File> arrayList3 = new ArrayList<File>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
                while (stringTokenizer.hasMoreTokens()) {
                    File file;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("file://") && (string2 = string2.substring(7, string2.length())).endsWith("\r")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!(file = new File(string2)).exists() || !file.canRead()) continue;
                    if (file.isFile()) {
                        arrayList.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    arrayList3.add(file);
                }
                this.addFiles(arrayList);
                this.addDirs(arrayList3);
            }
        } else {
            log.info((Object)"Unknown dropped objects");
        }
    }

    public void addFiles(List list) {
        if (list.size() > 0) {
            File[] fileArray = list.toArray(new File[list.size()]);
            this.addFiles(fileArray);
        }
    }

    public void addDirs(List list) {
        if (list.size() > 0) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                this.addDir((File)listIterator.next());
            }
        }
    }

    private void resetScrollBar() {
        int n = this.playlist.getPlaylistSize();
        float f = n < 1 ? 0.0f : (float)this.topIndex / (float)(n - 1) * 100.0f;
        this.ui.getAcPlSlider().setValue(100 - (int)f);
    }

    public void paintList() {
        if (!this.isVisible()) {
            return;
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        this.ui.getPlaylistPanel().paintBackground(graphics);
        this.ui.getPlaylistPanel().paintList(graphics);
    }

    private void addDir(File file) {
        String string = this.config.getExtensions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (this.exts == null) {
            this.exts = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.exts.add("." + stringTokenizer.nextElement());
            }
        }
        AddThread addThread = new AddThread(file);
        addThread.start();
        Thread thread = new Thread("Refresh"){

            public void run() {
                while (PlaylistUI.this.isSearching) {
                    PlaylistUI.this.resetScrollBar();
                    PlaylistUI.this.repaint();
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        thread.start();
    }

    private void addMusicRecursive(File file, int n) {
        if (file == null || n > MAXDEPTH) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.addMusicRecursive(file2, n + 1);
                continue;
            }
            if (!this.isMusicFile(stringArray[i])) continue;
            PlaylistItem playlistItem = new PlaylistItem(stringArray[i], file + File.separator + stringArray[i], -1L, true);
            this.playlist.appendItem(playlistItem);
        }
    }

    private boolean isMusicFile(String string) {
        int n = this.exts.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.exts.elementAt(i).toString().toLowerCase();
            if (string2.equalsIgnoreCase(".wsz") || string2.equalsIgnoreCase(".m3u") || string2.equalsIgnoreCase(".pls") || !string.toLowerCase().endsWith(this.exts.elementAt(i).toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    class AddThread
    extends Thread {
        private File fsFile;

        public AddThread(File file) {
            super("Add");
            this.fsFile = file;
        }

        public void run() {
            PlaylistUI.this.isSearching = true;
            PlaylistUI.this.addMusicRecursive(this.fsFile, 0);
            PlaylistUI.this.isSearching = false;
            PlaylistUI.this.resetScrollBar();
            PlaylistUI.this.repaint();
        }
    }
}

