/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.player.amp.tag.TagInfo;

public class FlacInfo
implements TagInfo {
    protected int channels = -1;
    protected int bitspersample = -1;
    protected int samplerate = -1;
    protected long size = 0L;
    protected String location = null;

    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        this.loadInfo(file);
    }

    public void load(URL uRL) throws IOException, UnsupportedAudioFileException {
        this.location = uRL.toString();
        this.loadInfo(uRL);
    }

    public void load(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        this.loadInfo(inputStream);
    }

    protected void loadInfo(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(File file) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("flac")) {
            throw new UnsupportedAudioFileException("Not Flac audio format");
        }
        AudioFormat audioFormat = audioFileFormat.getFormat();
        this.channels = audioFormat.getChannels();
        this.samplerate = (int)audioFormat.getSampleRate();
        this.bitspersample = audioFormat.getSampleSizeInBits();
    }

    protected void loadInfo(URL uRL) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
        this.loadInfo(audioFileFormat);
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.samplerate;
    }

    public int getBitsPerSample() {
        return this.bitspersample;
    }

    public Vector getComment() {
        return null;
    }

    public String getYear() {
        return null;
    }

    public String getGenre() {
        return null;
    }

    public int getTrack() {
        return -1;
    }

    public String getAlbum() {
        return null;
    }

    public String getArtist() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public long getPlayTime() {
        return -1L;
    }

    public int getBitRate() {
        return -1;
    }
}

