/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;

public class BMPLoader {
    private InputStream is;
    private int curPos = 0;
    private int bitmapOffset;
    private int width;
    private int height;
    private short bitsPerPixel;
    private int compression;
    private int actualSizeOfBitmap;
    private int scanLineSize;
    private int actualColorsUsed;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private int noOfEntries;
    private byte[] byteData;
    private int[] intData;

    public Image getBMPImage(InputStream inputStream) throws Exception {
        this.read(inputStream);
        return Toolkit.getDefaultToolkit().createImage(this.getImageSource());
    }

    protected int readInt() throws IOException {
        int n = this.is.read();
        int n2 = this.is.read();
        int n3 = this.is.read();
        int n4 = this.is.read();
        this.curPos += 4;
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    protected short readShort() throws IOException {
        int n = this.is.read();
        int n2 = this.is.read();
        this.curPos += 4;
        return (short)((n2 << 8) + n);
    }

    protected void getFileHeader() throws IOException, Exception {
        int n = 19778;
        short s = 0;
        short s2 = 0;
        n = this.readShort();
        if (n != 19778) {
            throw new Exception("Not a BMP file");
        }
        int n2 = this.readInt();
        s = this.readShort();
        s2 = this.readShort();
        this.bitmapOffset = this.readInt();
    }

    protected void getBitmapHeader() throws IOException {
        int n = this.readInt();
        this.width = this.readInt();
        this.height = this.readInt();
        short s = this.readShort();
        this.bitsPerPixel = this.readShort();
        this.compression = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        int n5 = this.readInt();
        int n6 = this.readInt();
        boolean bl = this.height < 0;
        int n7 = this.width * this.height;
        this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.actualSizeOfBitmap = n2 != 0 ? n2 : this.scanLineSize * this.height;
        this.actualColorsUsed = n5 != 0 ? n5 : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
    }

    protected void getPalette() throws IOException {
        this.noOfEntries = this.actualColorsUsed;
        if (this.noOfEntries > 0) {
            this.r = new byte[this.noOfEntries];
            this.g = new byte[this.noOfEntries];
            this.b = new byte[this.noOfEntries];
            for (int i = 0; i < this.noOfEntries; ++i) {
                this.b[i] = (byte)this.is.read();
                this.g[i] = (byte)this.is.read();
                this.r[i] = (byte)this.is.read();
                int n = this.is.read();
                this.curPos += 4;
            }
        }
    }

    protected void unpack(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        for (int i = 0; i < n3; ++i) {
            int n7 = byArray[n5++] & n6;
            int n8 = (byArray[n5++] & n6) << 8;
            int n9 = (byArray[n5++] & n6) << 16;
            nArray[n4] = 0xFF000000 | n7 | n8 | n9;
            ++n4;
        }
    }

    protected void unpack(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws Exception {
        int n5;
        int n6;
        int n7 = n3;
        int n8 = n;
        switch (n2) {
            case 1: {
                n6 = 1;
                n5 = 8;
                break;
            }
            case 4: {
                n6 = 15;
                n5 = 2;
                break;
            }
            case 8: {
                n6 = -1;
                n5 = 1;
                break;
            }
            default: {
                throw new Exception("Unsupported bits-per-pixel value");
            }
        }
        int n9 = 0;
        while (true) {
            int n10 = 8 - n2;
            for (int i = 0; i < n5; ++i) {
                byte by = byArray[n8];
                by = (byte)(by >> n10);
                byArray2[n7] = (byte)(by & n6);
                ++n7;
                if (++n9 == n4) {
                    return;
                }
                n10 -= n2;
            }
            ++n8;
        }
    }

    protected int readScanLine(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        while (n2 > 0) {
            n3 = this.is.read(byArray, n, n2);
            if (n3 == -1) {
                return n5 == 0 ? -1 : n5;
            }
            if (n3 == n2) {
                return n4;
            }
            n2 -= n3;
            n += n3;
            n5 += n3;
        }
        return n4;
    }

    protected void getPixelData() throws IOException, Exception {
        long l = this.bitmapOffset - this.curPos;
        if (l > 0L) {
            this.is.skip(l);
            this.curPos = (int)((long)this.curPos + l);
        }
        int n = this.scanLineSize;
        if (this.bitsPerPixel > 8) {
            this.intData = new int[this.width * this.height];
        } else {
            this.byteData = new byte[this.width * this.height];
        }
        byte[] byArray = new byte[this.actualSizeOfBitmap];
        int n2 = 0;
        int n3 = (this.height - 1) * this.width;
        for (int i = this.height - 1; i >= 0; --i) {
            int n4 = this.readScanLine(byArray, n2, n);
            if (n4 < n) {
                throw new Exception("Scan line ended prematurely after " + n4 + " bytes");
            }
            if (this.bitsPerPixel > 8) {
                this.unpack(byArray, n2, this.intData, n3, this.width);
            } else {
                this.unpack(byArray, n2, this.bitsPerPixel, this.byteData, n3, this.width);
            }
            n2 += n;
            n3 -= this.width;
        }
    }

    public void read(InputStream inputStream) throws IOException, Exception {
        this.is = inputStream;
        this.getFileHeader();
        this.getBitmapHeader();
        if (this.compression != 0) {
            throw new Exception("BMP Compression not supported");
        }
        this.getPalette();
        this.getPixelData();
    }

    public MemoryImageSource getImageSource() {
        ColorModel colorModel = this.noOfEntries > 0 ? new IndexColorModel((int)this.bitsPerPixel, this.noOfEntries, this.r, this.g, this.b) : ColorModel.getRGBdefault();
        MemoryImageSource memoryImageSource = this.bitsPerPixel > 8 ? new MemoryImageSource(this.width, this.height, colorModel, this.intData, 0, this.width) : new MemoryImageSource(this.width, this.height, colorModel, this.byteData, 0, this.width);
        return memoryImageSource;
    }
}

