/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.decoder;

import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.decoder.UnBitArrayBase;
import davaguine.jmac.decoder.UnBitArrayState;
import davaguine.jmac.info.APEFileInfo;
import davaguine.jmac.info.APEInfo;
import davaguine.jmac.info.APETag;
import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.info.WaveHeader;
import davaguine.jmac.prediction.IPredictorDecompress;
import davaguine.jmac.prediction.PredictorDecompress3950toCurrent;
import davaguine.jmac.prediction.PredictorDecompressNormal3930to3950;
import davaguine.jmac.tools.CircleBuffer;
import davaguine.jmac.tools.Crc32;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.Prepare;
import java.io.IOException;

public class APEDecompress
extends IAPEDecompress {
    private static final int DECODE_BLOCK_SIZE = 4096;
    protected int m_nBlockAlign;
    protected int m_nCurrentFrame;
    protected int m_nRealFrame;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected int m_nCurrentBlock;
    protected boolean m_bIsRanged;
    protected boolean m_bDecompressorInitialized;
    protected Prepare m_Prepare = new Prepare();
    protected WaveFormat m_wfeInput;
    protected Crc32 m_nCRC;
    protected long m_nStoredCRC;
    protected int m_nSpecialCodes;
    protected APEInfo m_spAPEInfo;
    protected UnBitArrayBase m_spUnBitArray;
    protected UnBitArrayState m_BitArrayStateX = new UnBitArrayState();
    protected UnBitArrayState m_BitArrayStateY = new UnBitArrayState();
    protected IPredictorDecompress m_spNewPredictorX;
    protected IPredictorDecompress m_spNewPredictorY;
    protected int m_nLastX;
    protected boolean m_bErrorDecodingCurrentFrame;
    protected int m_nCurrentFrameBufferBlock;
    protected int m_nFrameBufferFinishedBlocks;
    protected CircleBuffer m_cbFrameBuffer = new CircleBuffer();

    public APEDecompress(APEInfo pAPEInfo) {
        this(pAPEInfo, -1, -1);
    }

    public APEDecompress(APEInfo pAPEInfo, int nStartBlock) {
        this(pAPEInfo, nStartBlock, -1);
    }

    public APEDecompress(APEInfo pAPEInfo, int nStartBlock, int nFinishBlock) {
        this.m_spAPEInfo = pAPEInfo;
        if (this.m_spAPEInfo.getApeInfoFileVersion() < 3930) {
            throw new JMACException("Unsupported Version");
        }
        this.m_wfeInput = this.m_spAPEInfo.getApeInfoWaveFormatEx();
        this.m_nBlockAlign = this.m_spAPEInfo.getApeInfoBlockAlign();
        this.m_bDecompressorInitialized = false;
        this.m_nCurrentFrame = 0;
        this.m_nRealFrame = 0;
        this.m_nCurrentBlock = 0;
        this.m_nCurrentFrameBufferBlock = 0;
        this.m_nFrameBufferFinishedBlocks = 0;
        this.m_bErrorDecodingCurrentFrame = false;
        this.m_nStartBlock = nStartBlock < 0 ? 0 : Math.min(nStartBlock, this.m_spAPEInfo.getApeInfoTotalBlocks());
        this.m_nFinishBlock = nFinishBlock < 0 ? this.m_spAPEInfo.getApeInfoTotalBlocks() : Math.min(nFinishBlock, this.m_spAPEInfo.getApeInfoTotalBlocks());
        this.m_bIsRanged = this.m_nStartBlock != 0 || this.m_nFinishBlock != this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    public int GetData(byte[] pBuffer, int nBlocks) throws IOException {
        int nBlocksToRetrieve;
        this.InitializeDecompressor();
        int nBlocksUntilFinish = this.m_nFinishBlock - this.m_nCurrentBlock;
        int nBlocksLeft = nBlocksToRetrieve = Math.min(nBlocks, nBlocksUntilFinish);
        int nBlocksThisPass = 1;
        int index = 0;
        while (nBlocksLeft > 0 && nBlocksThisPass > 0) {
            this.FillFrameBuffer();
            int nFrameBufferBlocks = this.m_nFrameBufferFinishedBlocks;
            nBlocksThisPass = Math.min(nBlocksLeft, nFrameBufferBlocks);
            if (nBlocksThisPass <= 0) continue;
            this.m_cbFrameBuffer.Get(pBuffer, index, nBlocksThisPass * this.m_nBlockAlign);
            index += nBlocksThisPass * this.m_nBlockAlign;
            nBlocksLeft -= nBlocksThisPass;
            this.m_nFrameBufferFinishedBlocks -= nBlocksThisPass;
        }
        int nBlocksRetrieved = nBlocksToRetrieve - nBlocksLeft;
        this.m_nCurrentBlock += nBlocksRetrieved;
        return nBlocksRetrieved;
    }

    public void Seek(int nBlockOffset) throws IOException {
        this.InitializeDecompressor();
        if ((nBlockOffset += this.m_nStartBlock) >= this.m_nFinishBlock) {
            nBlockOffset = this.m_nFinishBlock - 1;
        }
        if (nBlockOffset < this.m_nStartBlock) {
            nBlockOffset = this.m_nStartBlock;
        }
        int nBaseFrame = nBlockOffset / this.m_spAPEInfo.getApeInfoBlocksPerFrame();
        int nBlocksToSkip = nBlockOffset % this.m_spAPEInfo.getApeInfoBlocksPerFrame();
        int nBytesToSkip = nBlocksToSkip * this.m_nBlockAlign;
        this.m_nCurrentBlock = nBaseFrame * this.getApeInfoBlocksPerFrame();
        this.m_nCurrentFrameBufferBlock = nBaseFrame * this.getApeInfoBlocksPerFrame();
        this.m_nCurrentFrame = nBaseFrame;
        this.m_nFrameBufferFinishedBlocks = 0;
        this.m_cbFrameBuffer.Empty();
        this.SeekToFrame(this.m_nCurrentFrame);
        byte[] spTempBuffer = new byte[nBytesToSkip];
        int nBlocksRetrieved = this.GetData(spTempBuffer, nBlocksToSkip);
        if (nBlocksRetrieved != nBlocksToSkip) {
            throw new JMACException("Undefined Error");
        }
    }

    public int getApeInfoDecompressCurrentBlock() {
        return this.m_nCurrentBlock - this.m_nStartBlock;
    }

    public int getApeInfoDecompressCurrentMS() {
        int nSampleRate = this.m_spAPEInfo.getApeInfoSampleRate();
        if (nSampleRate > 0) {
            return (int)((long)this.m_nCurrentBlock * 1000L / (long)nSampleRate);
        }
        return 0;
    }

    public int getApeInfoDecompressTotalBlocks() {
        return this.m_nFinishBlock - this.m_nStartBlock;
    }

    public int getApeInfoDecompressLengthMS() {
        int nSampleRate = this.m_spAPEInfo.getApeInfoSampleRate();
        if (nSampleRate > 0) {
            return (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)nSampleRate);
        }
        return 0;
    }

    public int getApeInfoDecompressCurrentBitRate() throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(this.m_nCurrentFrame);
    }

    public int getApeInfoDecompressAverageBitrate() throws IOException {
        if (this.m_bIsRanged || !this.m_spAPEInfo.getApeInfoIoSource().isLocal()) {
            int nBlocksPerFrame = this.m_spAPEInfo.getApeInfoBlocksPerFrame();
            int nStartFrame = this.m_nStartBlock / nBlocksPerFrame;
            int nFinishFrame = (this.m_nFinishBlock + nBlocksPerFrame - 1) / nBlocksPerFrame;
            int nTotalBytes = this.m_spAPEInfo.getApeInfoFrameBytes(nStartFrame) * (this.m_nStartBlock % nBlocksPerFrame) / nBlocksPerFrame;
            if (nFinishFrame != nStartFrame) {
                nTotalBytes += this.m_spAPEInfo.getApeInfoFrameBytes(nFinishFrame) * (this.m_nFinishBlock % nBlocksPerFrame) / nBlocksPerFrame;
            }
            int nTotalFrames = this.m_spAPEInfo.getApeInfoTotalFrames();
            for (int nFrame = nStartFrame + 1; nFrame < nFinishFrame && nFrame < nTotalFrames; ++nFrame) {
                nTotalBytes += this.m_spAPEInfo.getApeInfoFrameBytes(nFrame);
            }
            int nTotalMS = (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)this.m_spAPEInfo.getApeInfoSampleRate());
            if (nTotalMS != 0) {
                return nTotalBytes * 8 / nTotalMS;
            }
        } else {
            return this.m_spAPEInfo.getApeInfoAverageBitrate();
        }
        return 0;
    }

    public int getApeInfoWavHeaderBytes() {
        if (this.m_bIsRanged) {
            return 44;
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderBytes();
    }

    public byte[] getApeInfoWavHeaderData(int nMaxBytes) {
        if (this.m_bIsRanged) {
            if (44 > nMaxBytes) {
                return null;
            }
            WaveFormat wfeFormat = this.m_spAPEInfo.getApeInfoWaveFormatEx();
            WaveHeader WAVHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(WAVHeader, (this.m_nFinishBlock - this.m_nStartBlock) * this.m_spAPEInfo.getApeInfoBlockAlign(), wfeFormat, 0);
            return WAVHeader.write();
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderData(nMaxBytes);
    }

    public int getApeInfoWavTerminatingBytes() {
        if (this.m_bIsRanged) {
            return 0;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingBytes();
    }

    public byte[] getApeInfoWavTerminatingData(int nMaxBytes) throws IOException {
        if (this.m_bIsRanged) {
            return null;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingData(nMaxBytes);
    }

    public WaveFormat getApeInfoWaveFormatEx() {
        return this.m_spAPEInfo.getApeInfoWaveFormatEx();
    }

    public File getApeInfoIoSource() {
        return this.m_spAPEInfo.getApeInfoIoSource();
    }

    public int getApeInfoBlocksPerFrame() {
        return this.m_spAPEInfo.getApeInfoBlocksPerFrame();
    }

    public int getApeInfoFileVersion() {
        return this.m_spAPEInfo.getApeInfoFileVersion();
    }

    public int getApeInfoCompressionLevel() {
        return this.m_spAPEInfo.getApeInfoCompressionLevel();
    }

    public int getApeInfoFormatFlags() {
        return this.m_spAPEInfo.getApeInfoFormatFlags();
    }

    public int getApeInfoSampleRate() {
        return this.m_spAPEInfo.getApeInfoSampleRate();
    }

    public int getApeInfoBitsPerSample() {
        return this.m_spAPEInfo.getApeInfoBitsPerSample();
    }

    public int getApeInfoBytesPerSample() {
        return this.m_spAPEInfo.getApeInfoBytesPerSample();
    }

    public int getApeInfoChannels() {
        return this.m_spAPEInfo.getApeInfoChannels();
    }

    public int getApeInfoBlockAlign() {
        return this.m_spAPEInfo.getApeInfoBlockAlign();
    }

    public int getApeInfoFinalFrameBlocks() {
        return this.m_spAPEInfo.getApeInfoFinalFrameBlocks();
    }

    public int getApeInfoTotalFrames() {
        return this.m_spAPEInfo.getApeInfoTotalFrames();
    }

    public int getApeInfoWavDataBytes() {
        return this.m_spAPEInfo.getApeInfoWavDataBytes();
    }

    public int getApeInfoWavTotalBytes() {
        return this.m_spAPEInfo.getApeInfoWavTotalBytes();
    }

    public int getApeInfoApeTotalBytes() {
        return this.m_spAPEInfo.getApeInfoApeTotalBytes();
    }

    public int getApeInfoTotalBlocks() {
        return this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    public int getApeInfoLengthMs() {
        return this.m_spAPEInfo.getApeInfoLengthMs();
    }

    public int getApeInfoAverageBitrate() {
        return this.m_spAPEInfo.getApeInfoAverageBitrate();
    }

    public int getApeInfoSeekByte(int nFrame) {
        return this.m_spAPEInfo.getApeInfoSeekByte(nFrame);
    }

    public int getApeInfoFrameBytes(int nFrame) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBytes(nFrame);
    }

    public int getApeInfoFrameBlocks(int nFrame) {
        return this.m_spAPEInfo.getApeInfoFrameBlocks(nFrame);
    }

    public int getApeInfoFrameBitrate(int nFrame) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(nFrame);
    }

    public int getApeInfoDecompressedBitrate() {
        return this.m_spAPEInfo.getApeInfoDecompressedBitrate();
    }

    public int getApeInfoPeakLevel() {
        return this.m_spAPEInfo.getApeInfoPeakLevel();
    }

    public int getApeInfoSeekBit(int nFrame) {
        return this.m_spAPEInfo.getApeInfoSeekBit(nFrame);
    }

    public APETag getApeInfoTag() {
        return this.m_spAPEInfo.getApeInfoTag();
    }

    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_spAPEInfo.getApeInfoInternalInfo();
    }

    public void SeekToFrame(int nFrameIndex) throws IOException {
        int nSeekRemainder = (this.m_spAPEInfo.getApeInfoSeekByte(nFrameIndex) - this.m_spAPEInfo.getApeInfoSeekByte(0)) % 4;
        this.m_spUnBitArray.FillAndResetBitArray(nFrameIndex == this.m_nRealFrame ? -1 : this.m_spAPEInfo.getApeInfoSeekByte(nFrameIndex) - nSeekRemainder, nSeekRemainder * 8);
        this.m_nRealFrame = nFrameIndex;
    }

    protected void DecodeBlocksToFrameBuffer(int nBlocks) throws IOException {
        int nBlocksProcessed = 0;
        try {
            if (this.m_wfeInput.nChannels == 2) {
                if ((this.m_nSpecialCodes & 1) > 0 && (this.m_nSpecialCodes & 2) > 0) {
                    for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                        this.m_Prepare.unprepare(0, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    }
                } else if ((this.m_nSpecialCodes & 4) > 0) {
                    for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                        int X = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                        this.m_Prepare.unprepare(X, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    }
                } else if (this.m_spAPEInfo.getApeInfoFileVersion() >= 3950) {
                    for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                        int X;
                        int nY = this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateY);
                        int nX = this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX);
                        int Y = this.m_spNewPredictorY.DecompressValue(nY, this.m_nLastX);
                        this.m_nLastX = X = this.m_spNewPredictorX.DecompressValue(nX, Y);
                        this.m_Prepare.unprepare(X, Y, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    }
                } else {
                    for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                        int X = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                        int Y = this.m_spNewPredictorY.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateY));
                        this.m_Prepare.unprepare(X, Y, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                        this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                    }
                }
            } else if ((this.m_nSpecialCodes & 1) > 0) {
                for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                    this.m_Prepare.unprepare(0, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                    this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                }
            } else {
                for (nBlocksProcessed = 0; nBlocksProcessed < nBlocks; ++nBlocksProcessed) {
                    int X = this.m_spNewPredictorX.DecompressValue(this.m_spUnBitArray.DecodeValueRange(this.m_BitArrayStateX));
                    this.m_Prepare.unprepare(X, 0, this.m_wfeInput, this.m_cbFrameBuffer.GetDirectWritePointer(), this.m_nCRC);
                    this.m_cbFrameBuffer.UpdateAfterDirectWrite(this.m_nBlockAlign);
                }
            }
        }
        catch (JMACException e) {
            this.m_bErrorDecodingCurrentFrame = true;
        }
        this.m_nCurrentFrameBufferBlock += nBlocks;
    }

    protected void FillFrameBuffer() throws IOException {
        int nFrameBlocks;
        int nBlocksThisPass;
        int nMaxBlocks = this.m_cbFrameBuffer.MaxAdd() / this.m_nBlockAlign;
        boolean invalidChecksum = false;
        for (int nBlocksLeft = nMaxBlocks; nBlocksLeft > 0 && (nFrameBlocks = this.getApeInfoFrameBlocks(this.m_nCurrentFrame)) >= 0; nBlocksLeft -= nBlocksThisPass) {
            int nFrameOffsetBlocks = this.m_nCurrentFrameBufferBlock % this.getApeInfoBlocksPerFrame();
            int nFrameBlocksLeft = nFrameBlocks - nFrameOffsetBlocks;
            nBlocksThisPass = Math.min(nFrameBlocksLeft, nBlocksLeft);
            if (nFrameOffsetBlocks == 0) {
                this.StartFrame();
            }
            int nFrameBufferBytes = this.m_cbFrameBuffer.MaxGet();
            this.DecodeBlocksToFrameBuffer(nBlocksThisPass);
            if (nFrameOffsetBlocks + nBlocksThisPass < nFrameBlocks) continue;
            this.EndFrame();
            if (!this.m_bErrorDecodingCurrentFrame) continue;
            this.m_cbFrameBuffer.RemoveTail(this.m_cbFrameBuffer.MaxGet() - nFrameBufferBytes);
            byte cSilence = this.getApeInfoBitsPerSample() == 8 ? (byte)127 : 0;
            for (int z = 0; z < nFrameBlocks * this.m_nBlockAlign; ++z) {
                this.m_cbFrameBuffer.GetDirectWritePointer().append(cSilence);
                this.m_cbFrameBuffer.UpdateAfterDirectWrite(1);
            }
            this.SeekToFrame(this.m_nCurrentFrame);
            invalidChecksum = true;
        }
        if (invalidChecksum) {
            throw new JMACException("Invalid Checksum");
        }
    }

    protected void StartFrame() throws IOException {
        this.m_nCRC = new Crc32();
        this.m_nStoredCRC = this.m_spUnBitArray.DecodeValue(0);
        this.m_bErrorDecodingCurrentFrame = false;
        this.m_nSpecialCodes = 0;
        if (this.m_spAPEInfo.getApeInfoFileVersion() > 3820) {
            if ((this.m_nStoredCRC & 0x80000000L) > 0L) {
                this.m_nSpecialCodes = (int)this.m_spUnBitArray.DecodeValue(0);
            }
            this.m_nStoredCRC &= Integer.MAX_VALUE;
        }
        this.m_spNewPredictorX.Flush();
        this.m_spNewPredictorY.Flush();
        this.m_spUnBitArray.FlushState(this.m_BitArrayStateX);
        this.m_spUnBitArray.FlushState(this.m_BitArrayStateY);
        this.m_spUnBitArray.FlushBitArray();
        this.m_nLastX = 0;
    }

    protected void EndFrame() {
        this.m_nFrameBufferFinishedBlocks += this.getApeInfoFrameBlocks(this.m_nCurrentFrame);
        ++this.m_nCurrentFrame;
        this.m_spUnBitArray.Finalize();
        if (this.m_nCRC.checksum() != this.m_nStoredCRC) {
            this.m_bErrorDecodingCurrentFrame = true;
        }
    }

    protected void InitializeDecompressor() throws IOException {
        if (this.m_bDecompressorInitialized) {
            return;
        }
        this.m_bDecompressorInitialized = true;
        this.m_cbFrameBuffer.CreateBuffer((this.getApeInfoBlocksPerFrame() + 4096) * this.m_nBlockAlign, this.m_nBlockAlign * 64);
        this.m_spUnBitArray = UnBitArrayBase.CreateUnBitArray(this, this.m_spAPEInfo.getApeInfoFileVersion());
        if (this.m_spAPEInfo.getApeInfoFileVersion() >= 3950) {
            this.m_spNewPredictorX = new PredictorDecompress3950toCurrent(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
            this.m_spNewPredictorY = new PredictorDecompress3950toCurrent(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
        } else {
            this.m_spNewPredictorX = new PredictorDecompressNormal3930to3950(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
            this.m_spNewPredictorY = new PredictorDecompressNormal3930to3950(this.m_spAPEInfo.getApeInfoCompressionLevel(), this.m_spAPEInfo.getApeInfoFileVersion());
        }
        this.Seek(-1);
    }
}

