/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.tools.ByteArrayWriter;
import davaguine.jmac.tools.JMACException;
import java.io.UnsupportedEncodingException;

public class APETagField {
    public static final int TAG_FIELD_FLAG_READ_ONLY = 1;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_MASK = 6;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_TEXT_UTF8 = 0;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_BINARY = 2;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_EXTERNAL_INFO = 4;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_RESERVED = 6;
    private String m_spFieldName;
    private byte[] m_spFieldValue;
    private int m_nFieldFlags;

    public APETagField(String pFieldName, byte[] pFieldValue) {
        this(pFieldName, pFieldValue, 0);
    }

    public APETagField(String pFieldName, byte[] pFieldValue, int nFlags) {
        this.m_spFieldName = pFieldName;
        this.m_spFieldValue = pFieldValue;
        this.m_nFieldFlags = nFlags;
        this.m_spFieldValue = new byte[pFieldValue.length];
        System.arraycopy(pFieldValue, 0, this.m_spFieldValue, 0, pFieldValue.length);
        this.m_nFieldFlags = nFlags;
    }

    public int GetFieldSize() {
        try {
            return this.m_spFieldName.getBytes("US-ASCII").length + 1 + this.m_spFieldValue.length + 4 + 4;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMACException("Unsupported Encoding", e);
        }
    }

    public String GetFieldName() {
        return this.m_spFieldName;
    }

    public byte[] GetFieldValue() {
        return this.m_spFieldValue;
    }

    public int GetFieldValueSize() {
        return this.m_spFieldValue.length;
    }

    public int GetFieldFlags() {
        return this.m_nFieldFlags;
    }

    public int SaveField(ByteArrayWriter writer) {
        writer.writeInt(this.m_spFieldValue.length);
        writer.writeInt(this.m_nFieldFlags);
        writer.writeZString(this.m_spFieldName, "US-ASCII");
        writer.writeBytes(this.m_spFieldValue);
        return this.GetFieldSize();
    }

    public boolean GetIsReadOnly() {
        return (this.m_nFieldFlags & 1) > 0;
    }

    public boolean GetIsUTF8Text() {
        return (this.m_nFieldFlags & 6) == 0;
    }

    void SetFieldFlags(int nFlags) {
        this.m_nFieldFlags = nFlags;
    }
}

