/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.tools;

import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.tools.ByteArrayReader;
import davaguine.jmac.tools.ByteBuffer;
import davaguine.jmac.tools.Crc32;
import davaguine.jmac.tools.IntegerPointer;

public class Prepare {
    public void prepare(ByteArrayReader pRawData, int nBytes, WaveFormat pWaveFormatEx, int[] pOutputX, int[] pOutputY, Crc32 pCRC, IntegerPointer pSpecialCodes, IntegerPointer pPeakLevel) {
        pCRC.init();
        pSpecialCodes.value = 0;
        int nTotalBlocks = nBytes / pWaveFormatEx.nBlockAlign;
        if (pWaveFormatEx.wBitsPerSample == 8) {
            if (pWaveFormatEx.nChannels == 2) {
                for (int nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                    short b1 = pRawData.readUnsignedByte();
                    short b2 = pRawData.readUnsignedByte();
                    int R = b1 - 128;
                    int L = b2 - 128;
                    pCRC.append((byte)b1);
                    pCRC.append((byte)b2);
                    if (Math.abs(L) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(L);
                    }
                    if (Math.abs(R) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(R);
                    }
                    pOutputY[nBlockIndex] = L - R;
                    pOutputX[nBlockIndex] = R + pOutputY[nBlockIndex] / 2;
                }
            } else if (pWaveFormatEx.nChannels == 1) {
                for (int nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                    short b1 = pRawData.readUnsignedByte();
                    int R = b1 - 128;
                    pCRC.append((byte)b1);
                    if (Math.abs(R) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(R);
                    }
                    pOutputX[nBlockIndex] = R;
                }
            }
        } else if (pWaveFormatEx.wBitsPerSample == 24) {
            if (pWaveFormatEx.nChannels == 2) {
                for (int nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                    long nTemp = 0L;
                    short b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 0);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 8);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    pCRC.append((byte)b);
                    int R = ((nTemp |= (long)(b << 16)) & 0x800000L) > 0L ? (int)(nTemp & 0x7FFFFFL) - 0x800000 : (int)(nTemp & 0x7FFFFFL);
                    nTemp = 0L;
                    b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 0);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 8);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    pCRC.append((byte)b);
                    int L = ((nTemp |= (long)(b << 16)) & 0x800000L) > 0L ? (int)(nTemp & 0x7FFFFFL) - 0x800000 : (int)(nTemp & 0x7FFFFFL);
                    if (Math.abs(L) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(L);
                    }
                    if (Math.abs(R) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(R);
                    }
                    pOutputY[nBlockIndex] = L - R;
                    pOutputX[nBlockIndex] = R + pOutputY[nBlockIndex] / 2;
                }
            } else if (pWaveFormatEx.nChannels == 1) {
                for (int nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                    long nTemp = 0L;
                    short b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 0);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    nTemp |= (long)(b << 8);
                    pCRC.append((byte)b);
                    b = pRawData.readUnsignedByte();
                    pCRC.append((byte)b);
                    int R = ((nTemp |= (long)(b << 16)) & 0x800000L) > 0L ? (int)(nTemp & 0x7FFFFFL) - 0x800000 : (int)(nTemp & 0x7FFFFFL);
                    if (Math.abs(R) > pPeakLevel.value) {
                        pPeakLevel.value = Math.abs(R);
                    }
                    pOutputX[nBlockIndex] = R;
                }
            }
        } else if (pWaveFormatEx.nChannels == 2) {
            int LPeak = 0;
            int RPeak = 0;
            int nBlockIndex = 0;
            for (nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                short R = pRawData.readShort();
                pCRC.append(R);
                short L = pRawData.readShort();
                pCRC.append(L);
                if (Math.abs(L) > LPeak) {
                    LPeak = Math.abs(L);
                }
                if (Math.abs(R) > RPeak) {
                    RPeak = Math.abs(R);
                }
                pOutputY[nBlockIndex] = L - R;
                pOutputX[nBlockIndex] = R + pOutputY[nBlockIndex] / 2;
            }
            if (LPeak == 0) {
                pSpecialCodes.value |= 1;
            }
            if (RPeak == 0) {
                pSpecialCodes.value |= 2;
            }
            if (Math.max(LPeak, RPeak) > pPeakLevel.value) {
                pPeakLevel.value = Math.max(LPeak, RPeak);
            }
            nBlockIndex = 0;
            while (pOutputY[nBlockIndex++] == 0) {
                if (nBlockIndex != nBytes / 4) continue;
                pSpecialCodes.value |= 4;
                break;
            }
        } else if (pWaveFormatEx.nChannels == 1) {
            int nPeak = 0;
            for (int nBlockIndex = 0; nBlockIndex < nTotalBlocks; ++nBlockIndex) {
                int R = pRawData.readUnsignedShort();
                pCRC.append((short)R);
                if (Math.abs(R) > nPeak) {
                    nPeak = Math.abs(R);
                }
                pOutputX[nBlockIndex] = R;
            }
            if (nPeak > pPeakLevel.value) {
                pPeakLevel.value = nPeak;
            }
            if (nPeak == 0) {
                pSpecialCodes.value |= 1;
            }
        }
        pCRC.prefinalizeCrc();
        pCRC.finalizeCrc();
        if (pSpecialCodes.value != 0) {
            pCRC.doSpecial();
        }
    }

    public void unprepare(int X, int Y, WaveFormat waveFormat, ByteBuffer output, Crc32 crc) {
        short channels = waveFormat.nChannels;
        short bitsPerSample = waveFormat.wBitsPerSample;
        if (channels == 2) {
            if (bitsPerSample == 16) {
                short nR = (short)(X - Y / 2);
                short nL = (short)(nR + Y);
                output.append(nR, nL);
                crc.append(nR, nL);
            } else if (bitsPerSample == 8) {
                byte R = (byte)(X - Y / 2 + 128);
                byte L = (byte)(R + Y);
                output.append(R, L);
                crc.append(R, L);
            } else if (bitsPerSample == 24) {
                int RV = X - Y / 2;
                int LV = RV + Y;
                if (RV < 0) {
                    RV = RV + 0x800000 | 0x800000;
                }
                if (LV < 0) {
                    LV = LV + 0x800000 | 0x800000;
                }
                output.append24(RV, LV);
                crc.append24(RV, LV);
            }
        } else if (channels == 1) {
            if (bitsPerSample == 16) {
                output.append((short)X);
                crc.append((short)X);
            } else if (bitsPerSample == 8) {
                byte R = (byte)(X + 128);
                output.append(R);
                crc.append(R);
            } else if (bitsPerSample == 24) {
                if (X < 0) {
                    X = X + 0x800000 | 0x800000;
                }
                output.append24(X);
                crc.append24(X);
            }
        }
    }

    public void unprepareOld(int[] pInputX, int[] pInputY, int nBlocks, WaveFormat pWaveFormatEx, ByteBuffer output, Crc32 crc, int nFileVersion) {
        crc.init();
        short channels = pWaveFormatEx.nChannels;
        short bitsPerSample = pWaveFormatEx.wBitsPerSample;
        if (channels == 2) {
            if (bitsPerSample == 16) {
                int pX = 0;
                int pY = 0;
                while (pX < nBlocks) {
                    short R = (short)(pInputX[pX] - pInputY[pY] / 2);
                    output.append(R);
                    crc.append(R);
                    R = (short)(R + pInputY[pY]);
                    output.append(R);
                    crc.append(R);
                    ++pX;
                    ++pY;
                }
            } else if (bitsPerSample == 8) {
                if (nFileVersion > 3830) {
                    for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                        byte R = (byte)(pInputX[SampleIndex] - pInputY[SampleIndex] / 2 + 128);
                        output.append(R);
                        crc.append(R);
                        R = (byte)(R + pInputY[SampleIndex]);
                        output.append(R);
                        crc.append(R);
                    }
                } else {
                    for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                        byte R = (byte)(pInputX[SampleIndex] - pInputY[SampleIndex] / 2);
                        output.append(R);
                        crc.append(R);
                        R = (byte)(R + pInputY[SampleIndex]);
                        output.append(R);
                        crc.append(R);
                    }
                }
            } else if (bitsPerSample == 24) {
                for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                    int RV = pInputX[SampleIndex] - pInputY[SampleIndex] / 2;
                    int LV = RV + pInputY[SampleIndex];
                    int nTemp = 0;
                    nTemp = RV < 0 ? RV + 0x800000 | 0x800000 : RV;
                    output.append24(nTemp);
                    crc.append24(nTemp);
                    nTemp = 0;
                    nTemp = LV < 0 ? LV + 0x800000 | 0x800000 : LV;
                    output.append24(nTemp);
                    crc.append24(nTemp);
                }
            }
        } else if (channels == 1) {
            if (bitsPerSample == 8) {
                if (nFileVersion > 3830) {
                    for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                        byte R = (byte)(pInputX[SampleIndex] + 128);
                        output.append(R);
                        crc.append(R);
                    }
                } else {
                    for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                        byte R = (byte)pInputX[SampleIndex];
                        output.append(R);
                        crc.append(R);
                    }
                }
            } else if (bitsPerSample == 24) {
                for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                    int RV = pInputX[SampleIndex];
                    int nTemp = 0;
                    nTemp = RV < 0 ? RV + 0x800000 | 0x800000 : RV;
                    output.append24(nTemp);
                    crc.append24(nTemp);
                }
            } else {
                for (int SampleIndex = 0; SampleIndex < nBlocks; ++SampleIndex) {
                    short R = (short)pInputX[SampleIndex];
                    output.append(R);
                    crc.append(R);
                }
            }
        }
        crc.prefinalizeCrc();
    }
}

