/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class SwingSearchWindow
extends JFrame
implements GUISearchWindow {
    public static int SEARCH_EXTERNAL_WINDOW = 0;
    public static int SEARCH_TABBED_PANE = 1;
    public static int SEARCH_MENU_BAR = 2;
    int style = 0;
    private boolean isSetup = false;
    String defaultMessage = "Search PDF Here";
    JTextField searchText = null;
    JCheckBox searchAll;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList results;
    MouseListener ML;
    ActionListener AL = null;
    WindowListener WL;
    KeyListener KL;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    JButton searchButton = null;
    private int itemFoundCount = 0;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    final JPanel nav = new JPanel();
    Values commonValues;
    SwingGUI currentGUI;
    PdfDecoder decode_pdf;
    private boolean deleteOnClick;

    public SwingSearchWindow(Values values, SwingGUI swingGUI, PdfDecoder pdfDecoder) {
        this.commonValues = values;
        this.currentGUI = swingGUI;
        this.decode_pdf = pdfDecoder;
    }

    public Component getContentPanel() {
        return this.getContentPane();
    }

    public void find() {
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new JTextField(this.defaultMessage);
            this.searchButton = new JButton(Messages.getMessage("PdfViewerSearch.Button"));
            this.nav.setLayout(new BorderLayout());
            this.WL = new WindowListener(){

                public void windowOpened(WindowEvent windowEvent) {
                }

                public void windowClosing(WindowEvent windowEvent) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }

                public void windowClosed(WindowEvent windowEvent) {
                }

                public void windowIconified(WindowEvent windowEvent) {
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                }

                public void windowActivated(WindowEvent windowEvent) {
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                }
            };
            this.addWindowListener(this.WL);
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            this.nav.add((Component)this.searchAll, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.results = new SearchList(this.listModel, this.textPages);
            this.results.setSelectionMode(1);
            this.ML = new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (!SwingSearchWindow.this.commonValues.isProcessing()) {
                        Integer n;
                        Object v;
                        float f = SwingSearchWindow.this.currentGUI.getScaling();
                        int n2 = SwingSearchWindow.this.currentGUI.getPDFDisplayInset();
                        int n3 = SwingSearchWindow.this.results.getSelectedIndex();
                        SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                        if (n3 != -1 && (v = SwingSearchWindow.this.textPages.get(n = new Integer(n3))) != null) {
                            int n4 = (Integer)v;
                            Rectangle rectangle = (Rectangle)SwingSearchWindow.this.textRectangles.get(n);
                            if (SwingSearchWindow.this.commonValues.getCurrentPage() != n4) {
                                SwingSearchWindow.this.commonValues.setCurrentPage(n4);
                                SwingSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.decode_pdf.setPageParameters(f, SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.currentGUI.decodePage(false);
                                SwingSearchWindow.this.decode_pdf.invalidate();
                            }
                            int n5 = SwingSearchWindow.this.decode_pdf.getScrollInterval();
                            int n6 = (int)((float)(rectangle.x - SwingSearchWindow.this.currentGUI.cropX) * f) + n2;
                            int n7 = (int)((float)(SwingSearchWindow.this.currentGUI.cropH - (rectangle.y - SwingSearchWindow.this.currentGUI.cropY)) * f) + n2;
                            int n8 = (int)((float)rectangle.width * f);
                            int n9 = (int)((float)rectangle.height * f);
                            Rectangle rectangle2 = new Rectangle(n6 - n5, n7 - n9 - n5, n8 + n5 * 2, n9 + n5 * 2);
                            SwingSearchWindow.this.decode_pdf.scrollRectToVisible(rectangle2);
                            SwingSearchWindow.this.decode_pdf.setFoundTextArea(rectangle);
                            SwingSearchWindow.this.decode_pdf.invalidate();
                            SwingSearchWindow.this.decode_pdf.repaint();
                        }
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            };
            this.results.addMouseListener(this.ML);
            this.AL = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SwingSearchWindow.this.isSearch) {
                        try {
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        SwingSearchWindow.this.searcher.interrupt();
                        SwingSearchWindow.this.isSearch = false;
                        SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                }
            };
            this.searchButton.addActionListener(this.AL);
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.KL = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    char c;
                    int n;
                    if (SwingSearchWindow.this.searchText.getText().length() == 0) {
                        SwingSearchWindow.this.currentGUI.nextSearch.setVisible(false);
                        SwingSearchWindow.this.currentGUI.previousSearch.setVisible(false);
                    }
                    if (SwingSearchWindow.this.deleteOnClick) {
                        SwingSearchWindow.this.deleteOnClick = false;
                        SwingSearchWindow.this.searchText.setText("");
                    }
                    if ((n = keyEvent.getID()) == 400 && (c = keyEvent.getKeyChar()) == '\n') {
                        if (SwingSearchWindow.this.decode_pdf.isDecoding()) {
                            JOptionPane.showMessageDialog(null, "File must be open before you can search.");
                        } else {
                            try {
                                SwingSearchWindow.this.currentGUI.nextSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(false);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(false);
                                SwingSearchWindow.this.isSearch = false;
                                SwingSearchWindow.this.searchText();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            };
            this.searchText.addKeyListener(this.KL);
            if (this.style == SEARCH_EXTERNAL_WINDOW || this.style == SEARCH_TABBED_PANE) {
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().add(this.results);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)jScrollPane, "Center");
                this.getContentPane().add((Component)this.nav, "North");
                Container container = this.commonValues.getModeOfOperation() == 1 ? this.currentGUI.getFrame().getContentPane() : this.currentGUI.getFrame();
                int n = 230;
                int n2 = container.getHeight();
                int n3 = container.getLocationOnScreen().x;
                int n4 = container.getWidth() + n3;
                int n5 = container.getLocationOnScreen().y;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n6 = dimension.width;
                if (n4 + n > n6 && this.style == SEARCH_EXTERNAL_WINDOW) {
                    n4 = n6 - n;
                    container.setSize(n4 - n3, container.getHeight());
                }
                this.setSize(n, n2);
                this.setLocation(n4, n5);
                this.searchAll.setFocusable(false);
                this.searchText.grabFocus();
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
        if (this.style == SEARCH_EXTERNAL_WINDOW) {
            this.setVisible(true);
        }
    }

    public void removeSearchWindow(boolean bl) {
        this.setVisible(false);
        this.setVisible(false);
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        if (this.isSetup && !bl) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
    }

    private void searchText() throws Exception {
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        this.searchButton.setText(Messages.getMessage("PdfViewerSearchButton.Stop"));
        this.searchButton.invalidate();
        this.searchButton.repaint();
        this.isSearch = true;
        this.searchCount.setText(Messages.getMessage("PdfViewerSearch.Scanning1"));
        this.searchCount.repaint();
        this.searcher = new SwingWorker(){

            public Object construct() {
                try {
                    SwingSearchWindow.this.listModel.removeAllElements();
                    SwingSearchWindow.this.results.repaint();
                    int n = 0;
                    SwingSearchWindow.this.textPages.clear();
                    SwingSearchWindow.this.textRectangles.clear();
                    SwingSearchWindow.this.itemFoundCount = 0;
                    SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                    String string = SwingSearchWindow.this.searchText.getText();
                    PdfPageData pdfPageData = SwingSearchWindow.this.decode_pdf.getPdfPageData();
                    int n2 = 1;
                    int n3 = SwingSearchWindow.this.commonValues.getPageCount() + 1;
                    if (!SwingSearchWindow.this.searchAll.isSelected()) {
                        n2 = SwingSearchWindow.this.commonValues.getCurrentPage();
                        n3 = n2 + 1;
                    }
                    for (int i = n2; i < n3; ++i) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            PdfGroupingAlgorithms pdfGroupingAlgorithms;
                            if (i == SwingSearchWindow.this.commonValues.getCurrentPage()) {
                                pdfGroupingAlgorithms = SwingSearchWindow.this.decode_pdf.getGroupingObject();
                            } else {
                                SwingSearchWindow.this.decode_pdf.decodePageInBackground(i);
                                pdfGroupingAlgorithms = SwingSearchWindow.this.decode_pdf.getBackgroundGroupingObject();
                            }
                            pdfGroupingAlgorithms.generateTeasers();
                            int n4 = pdfPageData.getMediaBoxX(i);
                            int n5 = pdfPageData.getMediaBoxWidth(i);
                            int n6 = pdfPageData.getMediaBoxY(i);
                            int n7 = pdfPageData.getMediaBoxHeight(i);
                            float[] fArray = pdfGroupingAlgorithms.findTextInRectangle(n4, n7, n5 + n4, n6, i, string, false, true);
                            float[] fArray2 = pdfGroupingAlgorithms.getEndPoints();
                            String[] stringArray = pdfGroupingAlgorithms.getTeasers();
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (fArray != null && stringArray != null) {
                                SwingSearchWindow.this.itemFoundCount = SwingSearchWindow.this.itemFoundCount + stringArray.length;
                                int n8 = fArray.length;
                                int n9 = 0;
                                for (int j = 0; j < n8; j += 2) {
                                    int n10 = (int)fArray[j];
                                    int n11 = (int)fArray[j + 1];
                                    int n12 = (int)fArray2[j];
                                    int n13 = (int)fArray2[j + 1];
                                    final String string2 = stringArray[j / 2];
                                    Runnable runnable = new Runnable(){

                                        public void run() {
                                            (this).SwingSearchWindow.this.listModel.addElement(string2);
                                        }
                                    };
                                    SwingUtilities.invokeAndWait(runnable);
                                    Integer n14 = new Integer(n);
                                    ++n;
                                    SwingSearchWindow.this.textRectangles.put(n14, new Rectangle(n10, n13, n12 - n10, n11 - n13));
                                    SwingSearchWindow.this.textPages.put(n14, new Integer(i));
                                    ++n9;
                                }
                            }
                            if (!(fArray != null | i % 16 == 0)) continue;
                            SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + i);
                            SwingSearchWindow.this.searchCount.invalidate();
                            SwingSearchWindow.this.searchCount.repaint();
                            continue;
                        }
                        catch (PdfException pdfException) {
                            // empty catch block
                        }
                    }
                    SwingSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
                    SwingSearchWindow.this.results.invalidate();
                    SwingSearchWindow.this.results.repaint();
                    SwingSearchWindow.this.results.setSelectedIndex(0);
                    SwingSearchWindow.this.results.setLength(SwingSearchWindow.this.listModel.capacity());
                    SwingSearchWindow.this.currentGUI.setResults(SwingSearchWindow.this.results);
                    SwingSearchWindow.this.isSearch = false;
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                    SwingSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "An error occured during search. Some results may be missing.\n\nPlease send the file to IDRSolutions for investigation.");
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                }
                return null;
            }
        };
        this.searcher.start();
    }

    public int getListLength() {
        return this.listModel.capacity();
    }

    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    public boolean isSearchVisible() {
        return this.isVisible();
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    public Map getTextRectangles() {
        return this.textRectangles;
    }

    public SearchList getResults() {
        return this.results;
    }
}

