/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.Function;
import org.jpedal.io.PdfObjectReader;

class Sampled
extends Function {
    private float[] domain;
    private float[] encode;
    private float[] decode;
    int[] size;
    int order = 1;
    float[] samples;
    boolean flateDecode = false;
    boolean debugFunction = false;
    int[] t1;

    Sampled(byte[] byArray, Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        int n;
        this.flateDecode = map.get("Filter") != null && map.get("Filter").equals("/FlateDecode");
        int n2 = Integer.parseInt((String)map.get("BitsPerSample"));
        int n3 = (int)Math.pow(2.0, n2) - 1;
        String string = (String)map.get("Order");
        if (string != null) {
            this.order = Integer.parseInt(string);
        }
        string = pdfObjectReader.getValue((String)map.get("Size"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        this.size = new int[stringTokenizer.countTokens()];
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.size[n4] = Integer.parseInt(stringTokenizer.nextToken());
            ++n4;
        }
        string = (String)map.get("Encode");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.encode = new float[stringTokenizer.countTokens()];
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.encode[n4] = Float.parseFloat(stringTokenizer.nextToken());
                ++n4;
            }
        } else {
            n = this.size.length;
            this.encode = new float[n * 2];
            for (int i = 0; i < n; ++i) {
                this.encode[i * 2 + 1] = this.size[i] - 1;
            }
        }
        if ((string = (String)map.get("Decode")) != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.decode = new float[stringTokenizer.countTokens()];
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.decode[n4] = Float.parseFloat(stringTokenizer.nextToken());
                ++n4;
            }
        } else {
            n = fArray2.length;
            this.decode = new float[n];
            System.arraycopy(fArray2, 0, this.decode, 0, n);
        }
        this.samples = new float[byArray.length];
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l = 0L;
            long l2 = (1L << n2) - 1L;
            float f = 1L << n2;
            int n5 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                while (n5 < n2) {
                    l = (l << 8) + (long)((InputStream)byteArrayInputStream).read();
                    n5 += 8;
                }
                long l3 = l >> n5 - n2 & l2;
                n5 -= n2;
                this.samples[i] = (float)l3 / f;
            }
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " reading stream for separation colorspace");
        }
        this.domain = fArray;
        this.range = fArray2;
    }

    public final String[] compute(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            fArray2 = this.domain;
        }
        int n = this.range.length / 2;
        float[] fArray3 = new float[n];
        String[] stringArray = new String[n];
        try {
            this.compute(fArray, fArray3, fArray2);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = String.valueOf(fArray3[n - i - 1]);
            }
        }
        catch (Exception exception) {
            System.out.println("Sampled exception " + exception);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public final void compute(float[] fArray, float[] fArray2, float[] fArray3) {
        this.computejpedal(fArray, fArray2, fArray3);
    }

    public final void computejpedal(float[] fArray, float[] fArray2, float[] fArray3) {
        int n = fArray3.length / 2;
        int n2 = this.range.length / 2;
        float[] fArray4 = new float[n2];
        float[] fArray5 = fArray;
        float[] fArray6 = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            int n3;
            float f;
            int n4;
            fArray5[i] = this.min(this.max(fArray5[i], fArray3[i * 2]), fArray3[i * 2 + 1]);
            fArray6[i * 2] = this.interpolate(fArray5[i], fArray3[i * 2], fArray3[i * 2 + 1], this.encode[i * 2], this.encode[i * 2 + 1]);
            fArray6[i * 2] = this.min(this.max(fArray6[i * 2], 0.0f), this.size[i] - 1);
            if (n2 == n) {
                n4 = (int)fArray6[i * 2];
                if (fArray6[i * 2] - (float)((int)fArray6[i * 2]) > 0.0f) {
                    n4 = (int)fArray6[i * 2] + 1;
                }
                float f2 = (float)n4 - fArray6[i * 2];
                f = 1.0f - f2;
                int n5 = (int)fArray6[i * 2] * n2;
                n3 = n4 * n2;
                fArray4[i] = f2 * this.samples[n5] + f * this.samples[n3];
                fArray4[i] = this.interpolate(fArray4[i], 0.0f, 1.0f, this.decode[i * 2], this.decode[i * 2 + 1]);
                fArray2[fArray2.length - (i + 1)] = this.min(this.max(fArray4[i], this.range[i * 2]), this.range[i * 2 + 1]);
                continue;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                int n6 = (int)fArray6[i * 2];
                if (fArray6[i * 2] - (float)((int)fArray6[i * 2]) > 0.0f) {
                    n6 = (int)fArray6[i * 2] + 1;
                }
                f = (float)n6 - fArray6[i * 2];
                float f3 = 1.0f - f;
                n3 = (int)fArray6[i * 2] * n2 + n4;
                int n7 = n6 * n2 + n4;
                fArray4[n4] = f * this.samples[n3] + f3 * this.samples[n7];
                fArray4[n4] = this.interpolate(fArray4[n4], 0.0f, 1.0f, this.decode[n4 * 2], this.decode[n4 * 2 + 1]);
                fArray2[n4] = this.min(this.max(fArray4[n4], this.range[n4 * 2]), this.range[n4 * 2 + 1]);
            }
        }
        if (this.debugFunction) {
            float[] fArray7 = new float[fArray2.length];
            float[] fArray8 = new float[fArray2.length];
            this.computexpdf(fArray, fArray7, fArray3);
            for (int i = 0; i < fArray2.length; ++i) {
                fArray8[i] = fArray7[i] - fArray2[i];
                if (fArray8[i] < 0.0f) {
                    fArray8[i] = -fArray8[i];
                }
                if (!(fArray8[i] > 0.1f)) continue;
                System.out.println(i + " diff=" + fArray8[i] + " new=" + fArray7[i] + " old=" + fArray2[i]);
                System.exit(1);
            }
        }
    }

    private float interpolate(float f, float f2, float f3, float f4, float f5) {
        return (f - f2) * (f5 - f4) / (f3 - f2) + f4;
    }

    private float min(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        return f;
    }

    private float max(float f, float f2) {
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public final void computemul(float[] fArray, float[] fArray2, float[] fArray3) {
        this.clip(fArray, fArray3);
        int n = fArray3.length / 2;
        int n2 = this.range.length / 2;
        if (this.debugFunction) {
            System.out.println("===========================");
        }
        int n3 = fArray3.length;
        double[] dArray = new double[n3 * 2];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        int[] nArray = new int[n];
        double[] dArray4 = new double[1 << n3];
        this.preCalcValues(fArray, fArray3, n, n2, dArray, dArray2, dArray3, nArray);
        int n4 = 0;
        this.t1 = new int[n + 1];
        this.t1[0] = 0;
        for (int i = 0; i < n; ++i) {
            this.t1[i + 1] = n4 = (n4 > 0 ? n4 : 1) * this.size[i];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d4 = Math.ceil(dArray[j * 2]);
                d3 = d4 - dArray[j * 2];
                d2 = 1.0 - d3;
                n5 = (this.t1[j] + (int)dArray[j * 2]) * n2 + i;
                n6 = (this.t1[j] + (int)d4) * n2 + i;
                if (!this.debugFunction) continue;
                System.out.println("inx0=" + this.t1[j] + " e=" + (int)dArray[j * 2] + " n=" + n2 + " i=" + i);
            }
            if (this.debugFunction) {
                System.out.println("works j count=" + n + " inx0=" + n5 + " inx1=" + n6);
                System.out.println(this.samples[n5] + " " + this.samples[n6]);
            }
            d = (double)this.samples[n5] * d3 + (double)this.samples[n6] * d2;
            double d5 = this.decode[i * 2];
            double d6 = this.decode[i * 2 + 1];
            fArray2[i] = (float)(d * (d6 - d5) + d5);
        }
        this.clip(fArray2, this.range);
        if (this.debugFunction) {
            float[] fArray4 = new float[fArray2.length];
            float[] fArray5 = new float[fArray2.length];
            this.computexpdf(fArray, fArray4, fArray3);
            for (int i = 0; i < fArray2.length; ++i) {
                fArray5[i] = fArray4[i] - fArray2[i];
                if (fArray5[i] < 0.0f) {
                    fArray5[i] = -fArray5[i];
                }
                if (!(fArray5[i] > 0.1f)) continue;
                System.out.println(i + " diff=" + fArray5[i] + " new=" + fArray4[i] + " old=" + fArray2[i]);
                System.exit(1);
            }
        }
    }

    public final void computexpdf(float[] fArray, float[] fArray2, float[] fArray3) {
        this.clip(fArray, fArray3);
        int n = fArray3.length;
        int n2 = fArray3.length / 2;
        int n3 = this.range.length / 2;
        double[] dArray = new double[n * 2];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[1 << n];
        int[] nArray = new int[n2];
        this.preCalcValues(fArray, fArray3, n2, n3, dArray, dArray2, dArray3, nArray);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 < 1 << n2; ++n6) {
                int n7 = i;
                n5 = n6;
                for (n4 = 0; n4 < n2; ++n4) {
                    n7 += nArray[n4] * (int)dArray[n4 * 2 + (n5 & 1)];
                    n5 >>= 1;
                }
                dArray4[n6] = this.samples[n7];
            }
            n5 = 0;
            n6 = 0;
            n5 = 1 << n2;
            while (n6 < n2) {
                for (n4 = 0; n4 < n5; n4 += 2) {
                    dArray4[n4 >> 1] = dArray2[n6] * dArray4[n4] + dArray3[n6] * dArray4[n4 + 1];
                }
                ++n6;
                n5 >>= 1;
            }
            float f = this.decode[i * 2];
            float f2 = this.decode[i * 2 + 1];
            fArray2[i] = (float)(dArray4[0] * (double)(f2 - f) + (double)f);
        }
        this.clip(fArray2, this.range);
    }

    private void preCalcValues(float[] fArray, float[] fArray2, int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray) {
        int n3;
        nArray[0] = n2;
        for (n3 = 1; n3 < n; ++n3) {
            nArray[n3] = nArray[n3 - 1] * this.size[n3 - 1];
        }
        if (this.debugFunction) {
            System.out.println("----------------------------");
        }
        for (n3 = 0; n3 < n; ++n3) {
            float f = this.encode[n3 * 2];
            float f2 = fArray2[n3 * 2];
            float f3 = this.encode[n3 * 2 + 1];
            float f4 = fArray2[n3 * 2 + 1];
            double d = f + (fArray[n3] - f2) * (f3 - f) / (f4 - f2);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)(this.size[n3] - 1)) {
                d = this.size[n3] - 1;
            }
            dArray[n3 * 2] = d;
            double d2 = dArray[n3 * 2 + 1] = dArray[n3 * 2] + 1.0;
            if (d2 >= (double)this.size[n3]) {
                dArray[n3 * 2 + 1] = dArray[n3 * 2];
            }
            dArray3[n3] = d - (double)((int)dArray[n3 * 2]);
            dArray2[n3] = 1.0 - dArray3[n3];
        }
    }
}

