/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.JPedalListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.specificImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DefaultFormFactory
implements FormFactory {
    private static final boolean debugUnimplemented = false;
    private Map duplicates = new HashMap();
    private static boolean showIconImages = false;
    private AcroRenderer acrorend;
    private boolean printAllouts;
    private boolean printouts = this.printAllouts = false;
    private ActionHandler formsActionHandler;

    private DefaultFormFactory() {
    }

    public DefaultFormFactory(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    public void reset(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
        this.duplicates.clear();
    }

    public Object[] getComponentsByName(Component[] componentArray, String string, Object object) {
        String string2 = (String)this.duplicates.get(string);
        int n = (Integer)object;
        boolean bl = true;
        int n2 = n;
        while (bl) {
            if (n + 1 < componentArray.length && componentArray[n + 1] != null && FormUtils.removeStateToCheck(componentArray[n + 1].getName(), false).equals(string)) {
                ++n;
                continue;
            }
            bl = false;
        }
        int n3 = n + 1 - n2;
        Object[] objectArray = new Component[n3];
        int n4 = 0;
        while (n4 < n3) {
            objectArray[n4] = componentArray[n2];
            if (n2 == n) break;
            ++n4;
            ++n2;
        }
        if (string2 != null && string2.indexOf(44) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n5 = stringTokenizer.countTokens();
            Object[] objectArray2 = objectArray;
            objectArray = new Component[n3 + n5];
            System.arraycopy(objectArray2, 0, objectArray, 0, n3);
            for (int i = 0; i < n5; ++i) {
                int n6 = Integer.parseInt(stringTokenizer.nextToken());
                objectArray[i + n3] = componentArray[n6];
            }
        }
        return objectArray;
    }

    public Object[] returnAllComponents(Component[] componentArray) {
        return componentArray;
    }

    public Component annotationButton(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        return jButton;
    }

    public Component comboBox(FormObject formObject) {
        boolean[] blArray;
        String[] stringArray = formObject.getItemsList();
        JComboBox<Object> jComboBox = stringArray == null ? new JComboBox() : new JComboBox<String>(stringArray);
        String string = formObject.getSelectedItem();
        if (formObject.getValuesMap() != null) {
            jComboBox.setSelectedItem(formObject.getValuesMap().get(string));
        } else {
            jComboBox.setSelectedItem(string);
        }
        if (this.printouts) {
            System.out.println("currently selected value=" + string);
        }
        if ((blArray = formObject.getFieldFlags())[18]) {
            if (this.printouts) {
                System.out.println("drop list and an editable text box");
            }
            jComboBox.setEditable(true);
        } else {
            if (this.printouts) {
                System.out.println("only a drop list");
            }
            jComboBox.setEditable(false);
        }
        this.setupUniversalFeatures(jComboBox, formObject);
        if (blArray[1]) {
            jComboBox.setEditable(false);
            jComboBox.setEnabled(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jComboBox);
            }
        }
        return jComboBox;
    }

    public Component checkBoxBut(FormObject formObject) {
        JCheckBox jCheckBox = new JCheckBox();
        this.setupButton(jCheckBox, formObject);
        this.setupUniversalFeatures(jCheckBox, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jCheckBox.setEnabled(false);
            jCheckBox.setDisabledIcon(jCheckBox.getIcon());
            jCheckBox.setDisabledSelectedIcon(jCheckBox.getSelectedIcon());
        }
        return jCheckBox;
    }

    public Component listField(FormObject formObject) {
        String[] stringArray = formObject.getItemsList();
        JList<Object> jList = stringArray != null ? new JList<String>(stringArray) : new JList();
        if (!formObject.getFieldFlags()[21]) {
            jList.setSelectionMode(0);
        }
        if (formObject.getTopIndex() != null) {
            jList.setSelectedIndices(formObject.getTopIndex());
            if (this.printouts) {
                System.out.println("topIndex should be=" + ConvertToString.convertArrayToString(formObject.getTopIndex()));
            }
        } else {
            String string = formObject.getSelectedItem();
            if (formObject.getValuesMap() != null) {
                jList.setSelectedValue(formObject.getValuesMap().get(string), true);
            } else {
                jList.setSelectedValue(string, true);
            }
            if (this.printouts) {
                System.out.println("currently selected value=" + string);
            }
        }
        this.setupUniversalFeatures(jList, formObject);
        return jList;
    }

    public Component multiLinePassword(FormObject formObject) {
        String string = formObject.getTextString();
        int n = formObject.getMaxTextLength();
        JPasswordField jPasswordField = n != -1 ? new JPasswordField(string, n) : new JPasswordField(string);
        jPasswordField.setEchoChar('*');
        if (this.printouts) {
            System.out.println("there is a password to be entered that can be MULTILINED");
        }
        this.setupUniversalFeatures(jPasswordField, formObject);
        this.setupTextFeatures(jPasswordField, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jPasswordField.setEnabled(false);
            jPasswordField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jPasswordField);
            }
        }
        return jPasswordField;
    }

    public Component multiLineText(FormObject formObject) {
        JTextArea jTextArea = new JTextArea(formObject.getTextString());
        jTextArea.setLineWrap(true);
        this.setupUniversalFeatures(jTextArea, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jTextArea.setEnabled(false);
            jTextArea.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jTextArea);
            }
        }
        return jTextArea;
    }

    public Component signature(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        return jButton;
    }

    public Component pushBut(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        return jButton;
    }

    public Component radioBut(FormObject formObject) {
        JRadioButton jRadioButton = new JRadioButton();
        this.setupButton(jRadioButton, formObject);
        this.setupUniversalFeatures(jRadioButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jRadioButton.setEnabled(false);
            jRadioButton.setDisabledIcon(jRadioButton.getIcon());
            jRadioButton.setDisabledSelectedIcon(jRadioButton.getSelectedIcon());
        }
        return jRadioButton;
    }

    public Component singleLinePassword(FormObject formObject) {
        JPasswordField jPasswordField = new JPasswordField(formObject.getTextString());
        jPasswordField.setEchoChar('*');
        int n = formObject.getMaxTextLength();
        if (n != -1) {
            jPasswordField.setColumns(n);
            if (this.printouts) {
                System.out.println("textlength added=" + n);
            }
        }
        this.setupUniversalFeatures(jPasswordField, formObject);
        this.setupTextFeatures(jPasswordField, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jPasswordField.setEnabled(false);
            jPasswordField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jPasswordField);
            }
        }
        return jPasswordField;
    }

    public Component singleLineText(FormObject formObject) {
        JTextField jTextField = new JTextField(formObject.getTextString());
        this.setupUniversalFeatures(jTextField, formObject);
        this.setupTextFeatures(jTextField, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jTextField.setEnabled(false);
            jTextField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jTextField);
            }
        }
        return jTextField;
    }

    private void setupTextFeatures(JTextField jTextField, FormObject formObject) {
        if (formObject.getAllignment() != -1) {
            jTextField.setHorizontalAlignment(formObject.getAllignment());
        }
    }

    private void setupButton(AbstractButton abstractButton, FormObject formObject) {
        int n;
        String string = formObject.getNormalCaption();
        abstractButton.setText(string);
        abstractButton.setContentAreaFilled(false);
        String string2 = formObject.getDownCaption();
        String string3 = formObject.getRolloverCaption();
        if (string2 != null || string3 != null) {
            abstractButton.addMouseListener(this.formsActionHandler.setupChangingCaption(string, string3, string2));
        }
        if (formObject.isAppearancesUsed()) {
            this.appearanceImages(formObject, abstractButton, showIconImages);
        }
        if ((n = formObject.getTextPosition()) != -1) {
            switch (n) {
                case 0: {
                    abstractButton.setIcon(null);
                    abstractButton.setText(string);
                    break;
                }
                case 1: {
                    abstractButton.setText(null);
                    break;
                }
                case 2: {
                    abstractButton.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    abstractButton.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    abstractButton.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    abstractButton.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    abstractButton.setText(null);
                }
            }
        }
        Insets insets = new Insets(0, 0, 0, 0);
        abstractButton.setMargin(insets);
    }

    private void appearanceImages(FormObject formObject, AbstractButton abstractButton, boolean bl) {
        String string = formObject.getDefaultState();
        if (this.printouts) {
            System.out.println("default state=" + string);
        }
        if (string != null && string.equals(formObject.getNormalOnState())) {
            abstractButton.setSelected(true);
        }
        if (formObject.hasNormalOff()) {
            abstractButton.setText(null);
            abstractButton.setIcon(new FixImageIcon(formObject.getNormalOffImage()));
            if (bl) {
                ShowGUIMessage.showGUIMessage("normalAppOffImage", formObject.getNormalOffImage(), "normalAppOff");
            }
        }
        if (formObject.hasNormalOn()) {
            abstractButton.setText(null);
            abstractButton.setSelectedIcon(new FixImageIcon(formObject.getNormalOnImage()));
            if (bl) {
                ShowGUIMessage.showGUIMessage("normalAppOnImage", formObject.getNormalOnImage(), "normalAppOn");
            }
        }
        if (formObject.hasNoDownIcon()) {
            abstractButton.setPressedIcon(abstractButton.getIcon());
        } else {
            BufferedImage bufferedImage = formObject.getNormalOffImage();
            BufferedImage bufferedImage2 = formObject.getNormalOnImage();
            BufferedImage bufferedImage3 = null;
            BufferedImage bufferedImage4 = null;
            if (formObject.hasOffsetDownIcon() && !formObject.hasDownImage()) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage4 = this.createPressedLook(bufferedImage2);
                        bufferedImage3 = this.createPressedLook(bufferedImage);
                    } else {
                        bufferedImage3 = this.createPressedLook(bufferedImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage3 = this.createPressedLook(bufferedImage2);
                }
            } else if (formObject.hasInvertDownIcon()) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage3 = this.invertImage(bufferedImage);
                        bufferedImage4 = this.invertImage(bufferedImage2);
                    } else {
                        bufferedImage3 = this.invertImage(bufferedImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage3 = this.invertImage(bufferedImage2);
                }
            } else {
                bufferedImage3 = formObject.getDownOffImage();
                bufferedImage4 = formObject.getDownOnImage();
            }
            if (bufferedImage3 == null && bufferedImage4 == null) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage3 = this.invertImage(bufferedImage);
                        bufferedImage4 = this.invertImage(bufferedImage2);
                    } else {
                        bufferedImage3 = this.invertImage(bufferedImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage3 = this.invertImage(bufferedImage2);
                }
            }
            if (bl) {
                ShowGUIMessage.showGUIMessage("downAppOffImage", formObject.getDownOffImage(), "downAppOff");
                ShowGUIMessage.showGUIMessage("downAppOnImage", formObject.getDownOnImage(), "downAppOn");
            }
            if (bufferedImage3 == null || bufferedImage4 == null) {
                if (bufferedImage3 != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage3));
                } else if (bufferedImage4 != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage4));
                }
                if (this.printouts) {
                    System.out.println("CHECK there is an off or on down image not both does this work, DefaultAcro.createAppearanceImages");
                }
            } else {
                if (abstractButton.isSelected()) {
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage4));
                } else {
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage3));
                }
                abstractButton.addActionListener(this.formsActionHandler.setupChangingDownIcon(bufferedImage3, bufferedImage4));
            }
        }
        if (formObject.hasRolloverOff()) {
            abstractButton.setRolloverEnabled(true);
            abstractButton.setText(null);
            abstractButton.setRolloverIcon(new FixImageIcon(formObject.getRolloverOffImage()));
            if (bl) {
                ShowGUIMessage.showGUIMessage("rolloverAppOffImage", formObject.getRolloverOffImage(), "rolloverAppOff");
            }
        }
        if (formObject.hasRolloverOn()) {
            abstractButton.setRolloverEnabled(true);
            abstractButton.setText(null);
            abstractButton.setRolloverSelectedIcon(new FixImageIcon(formObject.getRolloverOnImage()));
            if (bl) {
                ShowGUIMessage.showGUIMessage("rolloverAppOnImage", formObject.getRolloverOnImage(), "rolloverAppOn");
            }
        }
    }

    private BufferedImage invertImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        byte[] byArray = new byte[256];
        for (int i = 0; i < 200; ++i) {
            byArray[i] = (byte)(256 - i);
        }
        ByteLookupTable byteLookupTable = new ByteLookupTable(0, byArray);
        LookupOp lookupOp = new LookupOp(byteLookupTable, null);
        lookupOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private BufferedImage createPressedLook(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null) + 2, image.getHeight(null) + 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(image, 1, 1, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void setupUniversalFeatures(JComponent jComponent, FormObject formObject) {
        Color color;
        jComponent.setOpaque(false);
        Font font = formObject.getTextFont();
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.setForeground(formObject.getTextColor());
        Border border = this.createBorderStyle(formObject.getBorder(), formObject.getBorderColor(), Color.white);
        jComponent.setBorder(border);
        if (this.printouts) {
            System.out.println("borderStyle=" + border);
        }
        if ((color = formObject.getBackgroundColor()) != null) {
            jComponent.setBackground(color);
            jComponent.setOpaque(true);
        }
        this.setupMouseListener(jComponent, formObject);
        if (this.printouts) {
            System.out.println("flagNum=" + formObject.getCharacteristics());
        }
    }

    private void setupMouseListener(Component component, FormObject formObject) {
        Map map;
        boolean[] blArray = formObject.getCharacteristics();
        if (blArray[0] || blArray[1] || blArray[5]) {
            component.setVisible(false);
        }
        JPedalListener jPedalListener = new JPedalListener(formObject, this.acrorend, this.formsActionHandler);
        if (component instanceof JComboBox) {
            ((JComboBox)component).getComponent(0).addMouseListener(jPedalListener);
            ((JComboBox)component).getComponent(0).addKeyListener(jPedalListener);
            ((JComboBox)component).getComponent(0).addFocusListener(jPedalListener);
            ((JComboBox)component).getComponent(0).addComponentListener(jPedalListener);
            ((JComboBox)component).getComponent(0).addInputMethodListener(jPedalListener);
            ((JComboBox)component).getComponent(0).addHierarchyListener(jPedalListener);
        } else {
            component.addMouseListener(jPedalListener);
            component.addKeyListener(jPedalListener);
            component.addFocusListener(jPedalListener);
            component.addComponentListener(jPedalListener);
            component.addInputMethodListener(jPedalListener);
            component.addHierarchyListener(jPedalListener);
        }
        Object object = formObject.getAobj();
        if (object != null && object instanceof Map && (map = (Map)object).containsKey("S") && ((String)map.get("S")).indexOf("URI") != -1) {
            String string = (String)map.get("URI");
            ((JComponent)component).setToolTipText(string);
        }
    }

    private Border createBorderStyle(Object object, Color color, Color color2) {
        Object v;
        String string;
        if (this.printouts) {
            System.out.println("createBorderStyle() color=" + color + " background color=" + color2 + "\n\tfield=" + object);
        }
        Map map = new HashMap<String, String>();
        if (object == null) {
            map.put("S", "/S");
            map.put("W", "1");
        } else if (object instanceof Map) {
            map = (Map)object;
        } else {
            LogWriter.writeFormLog("{DefaultFormFactory.createBorderStyle} border stream is String DefaultFormFactory.createBorderStyle", false);
        }
        if (color2 == null && this.printouts) {
            System.out.println("background border color null");
        }
        if (color == null) {
            if (this.printouts) {
                System.out.println("border color null");
            }
            return null;
        }
        Border border = null;
        String string2 = (String)map.get("W");
        int n = 1;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if (this.printouts) {
            System.out.println("width=" + string2);
        }
        string = (string = (String)map.get("S")) == null ? "S" : Strip.checkRemoveLeadingSlach(string);
        if (this.printouts) {
            System.out.println("style=" + string);
        }
        if (string.equals("U")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() U CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createMatteBorder(0, 0, n, 0, color);
        } else if (string.equals("I")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() I CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createEtchedBorder(color, color2);
        } else if (string.equals("B")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() B CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createBevelBorder(1, color, color2);
        } else if (string.equals("S")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() S CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createLineBorder(color, n);
        } else if (!string.equals("D") || (v = map.get("D")) instanceof String || v instanceof Map) {
            // empty if block
        }
        return border;
    }

    public Object getFormValue(Component[] componentArray, Object object) {
        Object object2 = "";
        if (object != null) {
            int n = (Integer)object;
            object2 = componentArray[n] instanceof JCheckBox ? Boolean.valueOf(((JCheckBox)componentArray[n]).isSelected()) : (componentArray[n] instanceof JComboBox ? ((JComboBox)componentArray[n]).getSelectedItem() : (componentArray[n] instanceof JList ? ((JList)componentArray[n]).getSelectedValues() : (componentArray[n] instanceof JRadioButton ? Boolean.valueOf(((JRadioButton)componentArray[n]).isSelected()) : (componentArray[n] instanceof JTextComponent ? ((JTextComponent)componentArray[n]).getText() : ""))));
        }
        return object2;
    }

    public void setFormValue(Component[] componentArray, Object object, Object object2) {
        if (object2 != null) {
            int n = (Integer)object2;
            if (componentArray[n] instanceof JCheckBox) {
                ((JCheckBox)componentArray[n]).setSelected(Boolean.valueOf((String)object));
            } else if (componentArray[n] instanceof JComboBox) {
                ((JComboBox)componentArray[n]).setSelectedItem(object);
            } else if (componentArray[n] instanceof JList) {
                ((JList)componentArray[n]).setSelectedValue(object, false);
            } else if (componentArray[n] instanceof JRadioButton) {
                ((JRadioButton)componentArray[n]).setText((String)object);
            } else if (componentArray[n] instanceof JTextComponent) {
                ((JTextComponent)componentArray[n]).setText((String)object);
            }
        }
    }

    public String getComponentName(Component[] componentArray, int n, ArrayList arrayList, String string) {
        String string2;
        Component component = componentArray[n];
        if (component != null && (string2 = FormUtils.removeStateToCheck(component.getName(), false)) != null && !string.equals(string2)) {
            String string3 = (String)this.duplicates.get(string2);
            if (string3 != null) {
                this.duplicates.put(string2, string3 + ',' + n);
            } else {
                this.duplicates.put(string2, String.valueOf(n));
            }
            arrayList.add(string2);
            string = string2;
        }
        return string;
    }

    public void showForms(Component[] componentArray) {
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == null) continue;
                componentArray[i].setBackground(Color.green);
                componentArray[i].setForeground(Color.lightGray);
                componentArray[i].setVisible(true);
                componentArray[i].setEnabled(true);
                ((JComponent)componentArray[i]).setOpaque(true);
                if (componentArray[i] instanceof AbstractButton) {
                    if (componentArray[i] instanceof JRadioButton) continue;
                    ((AbstractButton)componentArray[i]).setIcon(null);
                    continue;
                }
                if (!(componentArray[i] instanceof JComboBox)) continue;
                ((JComboBox)componentArray[i]).setEditable(false);
            }
        }
    }
}

