/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfPanel;
import org.jpedal.exception.PdfException;
import org.jpedal.external.LinkHandler;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.DefaultFormFactory;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.decoding.AnnotStream;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GenericComponentData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.specificImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DefaultAcroRenderer
implements AcroRenderer {
    public static final boolean useXFACode = true;
    private Map lastValidValue = new HashMap();
    private Map lastUnformattedValue = new HashMap();
    private Map rawFormData = new HashMap();
    private int[] trackPagesRendered;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private static final boolean debugUnimplemented = false;
    int[] xReached;
    int[] yReached;
    FormFactory formFactory;
    public static final int ANNOTATION = 1;
    public static final int FORM = 2;
    public static final int XFAFORM = 3;
    public int type = 0;
    private Map nameToCompIndex;
    private GenericComponentData compData = new GenericComponentData();
    private Map typeValues;
    private Component[] allFields;
    private JScrollPane[] scroll;
    private boolean[] firstTimeDisplayed;
    private PdfPageData pageData;
    private int insetW;
    private int insetH;
    private float lastScaling = -1.0f;
    private int oldRotation = 0;
    private int oldIndent = 0;
    private List acroFormDataList;
    private int formCount = 0;
    private int fieldCount = 0;
    private int nextFreeField = 0;
    private int currentPage;
    private int startID;
    private int pageHeight;
    private int cropOtherY;
    private PdfDecoder panel;
    protected int pageCount = 0;
    private float displayScaling;
    private PdfObjectReader currentPdfFile;
    private FormDecoder formDecoder;
    private String lastNameAdded = "";
    private Map additionFieldsMap = new HashMap();
    private float scaling = 0.0f;
    private int rotation;
    private int startPage;
    private int endPage;
    private int indent;
    ActionHandler formsActionHandler;
    LinkHandler linkHandler;
    private Javascript javascript;
    private Set sigObject = null;

    public void resetHandler(Object object, PdfDecoder pdfDecoder, int n) {
        if (n == 5) {
            this.formsActionHandler = object != null ? (ActionHandler)object : new DefaultActionHandler();
            this.formsActionHandler.init(pdfDecoder, this.currentPdfFile, this.javascript, this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
            }
        } else if (n == 7) {
            this.linkHandler = object != null ? (LinkHandler)object : null;
        }
    }

    public void removeDisplayComponentsFromScreen(PdfPanel pdfPanel) {
        pdfPanel.removeAll();
    }

    public Object getLastValidValue(String string) {
        return this.lastValidValue.get(string);
    }

    public Object getLastUnformattedValue(String string) {
        return this.lastUnformattedValue.get(string);
    }

    public void init(Object object, int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader) {
        this.sigObject = null;
        boolean bl = true;
        this.currentPdfFile = pdfObjectReader;
        if (this.formsActionHandler != null) {
            this.formsActionHandler.setFileAccess(pdfObjectReader);
        }
        this.insetW = n;
        this.insetH = n2;
        this.pageData = pdfPageData;
        if (object == null) {
            this.acroFormDataList = null;
            this.formCount = 0;
            this.fieldCount = 0;
        } else if (this.type == 2) {
            PdfFormData pdfFormData = (PdfFormData)object;
            if (!pdfFormData.hasXFAFormData()) {
                this.formDecoder = new FormStream(pdfObjectReader);
            }
            this.acroFormDataList = pdfFormData.getFormData();
            this.formCount = pdfFormData.getTotalCount();
            this.fieldCount = this.acroFormDataList.size();
        } else if (this.type == 1) {
            PdfAnnots pdfAnnots = (PdfAnnots)object;
            this.formDecoder = new AnnotStream(pdfObjectReader);
            this.acroFormDataList = pdfAnnots.getAnnotRawDataList();
            int n3 = this.acroFormDataList.size();
            this.formCount += n3;
            this.fieldCount = n3;
            bl = false;
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        this.additionFieldsMap.clear();
        this.nextFreeField = 0;
        if (bl) {
            if (this.formDecoder != null) {
                this.formDecoder.resetItems();
            }
            this.compData.resetComponents(this.formCount, false);
            this.firstTimeDisplayed = new boolean[this.formCount + 1];
            this.allFields = new Component[this.formCount + 1];
            this.scroll = new JScrollPane[this.formCount + 1];
            this.nameToCompIndex = new HashMap(this.formCount + 1);
            this.typeValues = new HashMap();
            this.trackPagesRendered = new int[this.pageCount + 1];
            for (int i = 0; i < this.pageCount + 1; ++i) {
                this.trackPagesRendered[i] = -1;
            }
        } else {
            this.compData.resetComponents(this.formCount, true);
            Component[] componentArray = this.allFields;
            JScrollPane[] jScrollPaneArray = this.scroll;
            boolean[] blArray = this.firstTimeDisplayed;
            this.firstTimeDisplayed = new boolean[this.formCount + 1];
            this.allFields = new Component[this.formCount + 1];
            this.scroll = new JScrollPane[this.formCount + 1];
            for (int i = 0; i < componentArray.length && componentArray[i] != null; ++i) {
                this.firstTimeDisplayed[i] = blArray[i];
                this.allFields[i] = componentArray[i];
                this.scroll[i] = jScrollPaneArray[i];
                ++this.nextFreeField;
            }
        }
        if (this.formFactory == null) {
            this.formFactory = new DefaultFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
        }
    }

    public void createDisplayComponentsForPage(int n, PdfDecoder pdfDecoder, float f, int n2) {
        this.scaling = f;
        this.rotation = n2;
        int n3 = this.pageData.getMediaBoxHeight(n);
        int n4 = this.pageData.getCropBoxHeight(n) + this.pageData.getCropBoxY(n);
        this.cropOtherY = 0;
        if (n3 != n4) {
            this.cropOtherY = n3 - n4;
        }
        this.pageHeight = n3;
        this.displayScaling = f;
        if (this.formsActionHandler != null) {
            this.formsActionHandler.setPageAccess(this.pageHeight, this.insetH);
        }
        this.currentPage = n;
        if (pdfDecoder != null) {
            this.panel = pdfDecoder;
        }
        if (this.trackPagesRendered == null) {
            return;
        }
        int n5 = this.trackPagesRendered[n];
        if (n5 == -1) {
            Object object;
            this.startID = this.nextFreeField;
            this.trackPagesRendered[n] = this.nextFreeField;
            if (this.type == 2) {
                this.formDecoder.resetItems();
            }
            FormObject[] formObjectArray = null;
            int n6 = 0;
            if (this.type == 3) {
                formObjectArray = new FormObject[this.fieldCount];
            }
            for (int i = this.fieldCount - 1; i > -1; --i) {
                Object object2;
                Object object3;
                Object object4;
                object = (Map)this.acroFormDataList.get(i);
                int n7 = -1;
                Object object5 = this.currentPdfFile.resolveToMapOrString("PageNumber", object.get("PageNumber"));
                if (object5 != null) {
                    n7 = Integer.parseInt((String)object5);
                }
                if (n7 == -1 && this.type == 1) {
                    n7 = n;
                }
                if (n7 == -1 && object.containsKey("Kids") && (object4 = this.currentPdfFile.resolveToMapOrString("Kids", object.get("Kids"))) instanceof Map) {
                    object3 = (Map)object4;
                    object2 = object3.keySet().iterator();
                    int n8 = 0;
                    int n9 = -1;
                    while (object2.hasNext()) {
                        Object object6;
                        String string = (String)object2.next();
                        Object object7 = this.currentPdfFile.resolveToMapOrString(string, object3.get(string));
                        if (object7 instanceof Map && (object6 = this.currentPdfFile.resolveToMapOrString("PageNumber", ((Map)object7).get("PageNumber"))) != null) {
                            n9 = Integer.parseInt((String)object6);
                        }
                        if (n9 == n) {
                            n7 = n9;
                        }
                        ++n8;
                    }
                }
                if (n7 != n) continue;
                object4 = new ButtonGroup();
                object2 = null;
                if (this.type == 3) {
                    object3 = null;
                    object2 = this.formDecoder.createAppearanceString((Map)object, this.currentPdfFile);
                    if (object2 == null) continue;
                    formObjectArray[n6++] = object2;
                    this.rawFormData.put(((FormObject)object2).getFieldName(), object2);
                } else {
                    object2 = this.formDecoder.createAppearanceString((Map)object, this.currentPdfFile);
                    if (object2 == null) continue;
                    this.rawFormData.put(((FormObject)object2).getFieldName(), object2);
                    object3 = this.createField((FormObject)object2, (ButtonGroup)object4, this.nextFreeField);
                }
                this.checkButtonGroupAndApply(n, f, n2, n7, (ButtonGroup)object4, (Component)object3, (FormObject)object2);
            }
            if (this.additionFieldsMap.get(String.valueOf(n)) != null) {
                ArrayList arrayList = (ArrayList)this.additionFieldsMap.get(String.valueOf(n));
                object = arrayList.iterator();
                while (object.hasNext()) {
                    this.apply((Component)object.next(), n, f, n2);
                }
            }
        }
    }

    private void checkButtonGroupAndApply(int n, float f, int n2, int n3, ButtonGroup buttonGroup, Component component, FormObject formObject) {
        if (buttonGroup.getButtonCount() > 1) {
            AbstractButton[] abstractButtonArray = FormUtils.sortGroupSmallestFirst(buttonGroup);
            for (int i = 0; i < buttonGroup.getButtonCount(); ++i) {
                Object object;
                if (abstractButtonArray[i].getLabel().equals(String.valueOf(n))) {
                    object = formObject.getCurrentState();
                    String string = formObject.getOnState();
                    if (object != null && ((String)object).equals(FormUtils.removeStateToCheck(abstractButtonArray[i].getName(), true)) || string != null && string.equals(FormUtils.removeStateToCheck(abstractButtonArray[i].getName(), true))) {
                        abstractButtonArray[i].setSelected(true);
                    }
                    this.apply(abstractButtonArray[i], n3, f, n2);
                    continue;
                }
                if (this.additionFieldsMap.get(abstractButtonArray[i].getLabel()) != null) {
                    object = (ArrayList)this.additionFieldsMap.get(abstractButtonArray[i].getLabel());
                    ((ArrayList)object).add(abstractButtonArray[i]);
                    this.additionFieldsMap.put(abstractButtonArray[i].getLabel(), object);
                    continue;
                }
                object = new ArrayList();
                ((ArrayList)object).add(abstractButtonArray[i]);
                this.additionFieldsMap.put(abstractButtonArray[i].getLabel(), object);
            }
        } else if (component != null) {
            if (formObject.getFieldFlags()[14] && component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBounds(formObject.getBoundingRectangle());
                abstractButton.setText(String.valueOf(formObject.getPageNumber()));
                new ButtonGroup().add(abstractButton);
            }
            this.apply(component, n3, f, n2);
        }
    }

    public void displayComponentsOnscreen(int n, int n2, PdfPanel pdfPanel, float f, int n3) {
        this.startPage = n;
        this.endPage = n2++;
        for (int i = n; i < n2; ++i) {
            this.startID = this.trackPagesRendered.length > i ? this.trackPagesRendered[i] : -1;
            int n4 = this.startID;
            if (this.startID == -1) continue;
            while (this.compData.pageMap[n4] >= n && this.compData.pageMap[n4] < n2) {
                if (this.allFields[n4] != null) {
                    this.scaleComponent(this.compData.pageMap[n4], f, n3, n4, this.allFields[n4], true);
                    if (pdfPanel != null) {
                        pdfPanel.add(this.allFields[n4]);
                        String string = FormUtils.removeStateToCheck(this.allFields[n4].getName(), false);
                        this.firstTimeDisplayed[n4] = false;
                    }
                }
                if (++n4 != this.compData.pageMap.length) continue;
            }
        }
    }

    public void removePageRangeFromDisplay(int n, int n2, PdfPanel pdfPanel) {
        try {
            for (int i = n; i < n2; ++i) {
                int n3 = this.trackPagesRendered[i];
                if (n3 == -1) continue;
                while (this.compData.pageMap[n3] >= n && this.compData.pageMap[n3] <= n2) {
                    if (this.allFields[n3] != null) {
                        pdfPanel.remove(this.allFields[n3]);
                    }
                    if (++n3 != this.compData.pageMap.length) continue;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void apply(Component component, int n, float f, int n2) {
        String string = FormUtils.removeStateToCheck(component.getName(), false);
        if (string != null && !this.lastNameAdded.equals(string)) {
            this.nameToCompIndex.put(string, new Integer(this.nextFreeField));
            this.lastNameAdded = string;
        }
        int n3 = this.compData.fontSizes[this.nextFreeField];
        if (component != null) {
            Rectangle rectangle = component.getBounds();
            if (rectangle != null) {
                float f2 = rectangle.x;
                float f3 = rectangle.y;
                float f4 = rectangle.width + rectangle.x;
                float f5 = rectangle.height + rectangle.y;
                this.compData.boundingBoxs[this.nextFreeField][0] = f2;
                this.compData.boundingBoxs[this.nextFreeField][1] = f3;
                this.compData.boundingBoxs[this.nextFreeField][2] = f4;
                this.compData.boundingBoxs[this.nextFreeField][3] = f5;
            }
            this.allFields[this.nextFreeField] = component;
            this.scroll[this.nextFreeField] = null;
            this.compData.fontSize[this.nextFreeField] = n3;
            this.firstTimeDisplayed[this.nextFreeField] = true;
            this.scaleComponent(n, f, n2, this.nextFreeField, component, true);
        }
        this.compData.pageMap[this.nextFreeField] = n;
        ++this.nextFreeField;
    }

    private Component createField(FormObject formObject, ButtonGroup buttonGroup, int n) {
        Component component = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n2 = formObject.getType();
            if (n2 != -1) {
                bl3 = n2 == 0;
                bl4 = n2 == 2;
                bl5 = n2 == 1;
                boolean bl7 = bl6 = n2 == 3;
            }
            if (bl6) {
                if (this.sigObject == null) {
                    this.sigObject = new HashSet();
                }
                this.sigObject.add(formObject);
            }
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean[] blArray = formObject.getFieldFlags();
            if (blArray != null) {
                bl8 = blArray[1];
                bl9 = blArray[2];
                bl10 = blArray[3];
            }
            if (bl3) {
                bl2 = false;
                bl = false;
                boolean bl11 = false;
                boolean bl12 = false;
                if (blArray != null) {
                    bl2 = blArray[16];
                    bl = blArray[15];
                    bl11 = blArray[14];
                    bl12 = blArray[25];
                }
                if (bl2) {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.PUSHBUTTON);
                    component = this.formFactory.pushBut(formObject);
                } else if (bl) {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.RADIOBUTTON);
                    if (formObject.getKidData() != null) {
                        Map map = formObject.getKidData();
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            FormObject formObject2 = (FormObject)map.get(iterator.next());
                            Component component2 = this.createField(formObject2, buttonGroup, ++n);
                            try {
                                AbstractButton abstractButton = (AbstractButton)component2;
                                abstractButton.setBounds(formObject2.getBoundingRectangle());
                                abstractButton.setText(String.valueOf(formObject2.getPageNumber()));
                                buttonGroup.add(abstractButton);
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    component = this.formFactory.radioBut(formObject);
                } else {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.CHECKBOXBUTTON);
                    if (formObject.getKidData() != null) {
                        Map map = formObject.getKidData();
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            FormObject formObject3 = (FormObject)map.get(iterator.next());
                            Component component3 = this.createField(formObject3, buttonGroup, ++n);
                            try {
                                AbstractButton abstractButton = (AbstractButton)component3;
                                abstractButton.setBounds(formObject3.getBoundingRectangle());
                                abstractButton.setText(String.valueOf(formObject3.getPageNumber()));
                                buttonGroup.add(abstractButton);
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    component = this.formFactory.checkBoxBut(formObject);
                }
            } else if (bl4) {
                bl2 = false;
                bl = false;
                boolean bl13 = false;
                boolean bl14 = false;
                boolean bl15 = false;
                boolean bl16 = false;
                if (blArray != null) {
                    bl2 = blArray[12];
                    bl = blArray[13];
                    bl13 = blArray[23];
                    bl14 = blArray[25];
                    bl15 = blArray[20];
                    bl16 = blArray[22];
                }
                if (bl2) {
                    if (bl) {
                        this.typeValues.put(formObject.getFieldName(), FormFactory.MULTILINEPASSWORD);
                        component = this.formFactory.multiLinePassword(formObject);
                    } else {
                        this.typeValues.put(formObject.getFieldName(), FormFactory.MULTILINETEXT);
                        component = this.formFactory.multiLineText(formObject);
                    }
                } else if (bl) {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.SINGLELINEPASSWORD);
                    component = this.formFactory.singleLinePassword(formObject);
                } else {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.SINGLELINETEXT);
                    component = this.formFactory.singleLineText(formObject);
                }
                String string = formObject.getUserName();
                if (string != null) {
                    ((JTextComponent)component).setToolTipText(string);
                }
            } else if (bl5) {
                bl2 = false;
                bl = false;
                boolean bl17 = false;
                boolean bl18 = false;
                boolean bl19 = false;
                boolean bl20 = false;
                if (blArray != null) {
                    bl2 = blArray[17];
                    bl = blArray[21];
                    bl17 = blArray[19];
                    bl18 = blArray[18];
                    bl19 = blArray[22];
                    bl20 = blArray[26];
                }
                if (bl2) {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.COMBOBOX);
                    component = this.formFactory.comboBox(formObject);
                } else {
                    this.typeValues.put(formObject.getFieldName(), FormFactory.LIST);
                    component = this.formFactory.listField(formObject);
                }
            } else if (bl6) {
                this.typeValues.put(formObject.getFieldName(), FormFactory.SIGNATURE);
                component = this.formFactory.signature(formObject);
            } else if (this.type == 1) {
                this.typeValues.put(formObject.getFieldName(), FormFactory.ANNOTATION);
                component = this.formFactory.annotationButton(formObject);
            } else {
                return null;
            }
            String string = formObject.getFieldName();
            if (string != null) {
                String string2 = formObject.getStateTocheck();
                if (string2 != null && string2.length() > 0) {
                    string = string + "-(" + string2 + ')';
                }
                component.setName(string);
            }
            if (formObject.getBoundingRectangle() != null) {
                Rectangle rectangle = formObject.getBoundingRectangle();
                component.setBounds(rectangle);
            }
            String string3 = formObject.getDefaultValue();
            string3 = formObject.getValuesMap() != null ? (String)formObject.getValuesMap().get(Strip.checkRemoveLeadingSlach(string3)) : Strip.checkRemoveLeadingSlach(string3);
            this.compData.setDefaults(n, formObject.getTextSize(), string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return component;
    }

    public Component[] getDisplayComponentsForPage(int n) {
        return this.allFields;
    }

    public void resetScaledLocation(float f, int n, int n2) {
        this.indent = n2;
        this.displayScaling = f;
        this.rotation = n;
        if (this.trackPagesRendered == null) {
            return;
        }
        if (f != this.lastScaling || n != this.oldRotation || n2 != this.oldIndent) {
            this.oldRotation = n;
            this.lastScaling = f;
            this.oldIndent = n2;
            int n3 = this.startPage < this.trackPagesRendered.length ? this.trackPagesRendered[this.startPage] : 0;
            if (this.allFields != null && this.currentPage > 0 && n3 != -1 && this.compData.pageMap.length > n3) {
                while (this.compData.pageMap[n3] >= this.startPage && this.compData.pageMap[n3] <= this.endPage && this.allFields[n3] != null) {
                    if (this.panel != null) {
                        if (this.scroll[n3] == null) {
                            this.panel.remove(this.allFields[n3]);
                        } else {
                            this.panel.remove(this.scroll[n3]);
                        }
                    }
                    this.scaleComponent(this.compData.pageMap[n3], f, n, n3, this.allFields[n3], true);
                    if (this.panel != null) {
                        float f2 = this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1];
                        int n4 = this.allFields[n3].getPreferredSize().height;
                        if (this.allFields[n3] instanceof JList && f2 < (float)n4) {
                            JList jList = (JList)this.allFields[n3];
                            if (this.scroll[n3] != null) {
                                this.scroll[n3].remove(jList);
                            }
                            this.scroll[n3] = new JScrollPane(jList);
                            this.scroll[n3].setVerticalScrollBarPolicy(20);
                            this.scroll[n3].setHorizontalScrollBarPolicy(30);
                            this.scroll[n3].setLocation(jList.getLocation());
                            this.scroll[n3].setPreferredSize(jList.getPreferredSize());
                            this.scroll[n3].setSize(jList.getSize());
                            int n5 = jList.getSelectedIndex();
                            if (n5 > -1) {
                                jList.ensureIndexIsVisible(n5);
                            }
                            this.panel.add(this.scroll[n3]);
                        } else {
                            this.panel.add(this.allFields[n3]);
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    private void scaleComponent(int n, float f, int n2, int n3, Component component, boolean bl) {
        if (component == null) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.pageData.getMediaBoxWidth(n) - this.pageData.getCropBoxWidth(n) - this.pageData.getCropBoxX(n);
        if (n2 == 0) {
            int n9 = this.pageData.getCropBoxX(n);
            float f2 = this.compData.boundingBoxs[n3][0] - (float)n9 + (float)this.insetW;
            if (!bl) {
                f2 += (float)n9;
            }
            float f3 = (float)this.pageData.getMediaBoxHeight(n) - this.compData.boundingBoxs[n3][3] - (float)this.cropOtherY + (float)this.insetH;
            float f4 = this.compData.boundingBoxs[n3][2] - this.compData.boundingBoxs[n3][0];
            float f5 = this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1];
            n4 = (int)((f2 - (float)this.insetW) * f + (float)this.insetW);
            n5 = (int)((f3 - (float)this.insetH) * f + (float)this.insetH);
            n6 = (int)(f4 * f);
            n7 = (int)(f5 * f);
        } else if (n2 == 90) {
            float f6 = this.compData.boundingBoxs[n3][1] - (float)this.pageData.getCropBoxY(n) + (float)this.insetW;
            float f7 = this.compData.boundingBoxs[n3][0] - (float)this.pageData.getCropBoxX(n) + (float)this.insetH;
            float f8 = this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1];
            float f9 = this.compData.boundingBoxs[n3][2] - this.compData.boundingBoxs[n3][0];
            n4 = (int)((f6 - (float)this.insetH) * f + (float)this.insetH);
            n5 = (int)((f7 - (float)this.insetW) * f + (float)this.insetW);
            n6 = (int)(f8 * f);
            n7 = (int)(f9 * f);
        } else if (n2 == 180) {
            int n10 = (int)((float)this.pageData.getMediaBoxWidth(n) - this.compData.boundingBoxs[n3][2] - (float)n8) + this.insetW;
            int n11 = (int)(this.compData.boundingBoxs[n3][1] - (float)this.pageData.getCropBoxY(n)) + this.insetH;
            int n12 = (int)(this.compData.boundingBoxs[n3][2] - this.compData.boundingBoxs[n3][0]);
            int n13 = (int)(this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1]);
            n4 = (int)((float)(n10 - this.insetW) * f + (float)this.insetW);
            n5 = (int)((float)(n11 - this.insetH) * f + (float)this.insetH);
            n6 = (int)((float)n12 * f);
            n7 = (int)((float)n13 * f);
        } else if (n2 == 270) {
            float f10 = (float)this.pageData.getMediaBoxHeight(n) - this.compData.boundingBoxs[n3][3] - (float)this.cropOtherY + (float)this.insetW;
            float f11 = (float)this.pageData.getMediaBoxWidth(n) - this.compData.boundingBoxs[n3][2] - (float)n8 + (float)this.insetH;
            float f12 = this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1];
            float f13 = this.compData.boundingBoxs[n3][2] - this.compData.boundingBoxs[n3][0];
            n4 = (int)((f10 - (float)this.insetH) * f + (float)this.insetH);
            n5 = (int)((f11 - (float)this.insetW) * f + (float)this.insetW);
            n6 = (int)(f12 * f);
            n7 = (int)(f13 * f);
        }
        if (this.xReached != null) {
            n4 += this.xReached[n];
            n5 += this.yReached[n];
        }
        component.setBounds(this.indent + n4, n5, n6, n7);
        Font font = component.getFont();
        if (font != null) {
            int n14;
            int n15 = this.compData.fontSize[n3];
            if (n15 == -1) {
                n15 = 8;
            }
            if (n15 == 0) {
                int n16;
                String string;
                int n17 = (int)(this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1]);
                int n18 = (int)(this.compData.boundingBoxs[n3][2] - this.compData.boundingBoxs[n3][0]);
                if (n2 == 90 || n2 == 270) {
                    int n19 = n17;
                    n17 = n18;
                    n18 = n19;
                }
                n15 = n17 = (int)((double)n17 * 0.85);
                if (component instanceof JTextComponent) {
                    int n20 = ((JTextComponent)component).getText().length();
                    if (n20 * n17 / 2 > n18) {
                        if (n20 > 0) {
                            n18 /= n20;
                        }
                        n15 = n18;
                    }
                } else if (component instanceof JButton && (string = ((JButton)component).getText()) != null && (n16 = string.length()) * n17 / 2 > n18) {
                    if (n16 > 0) {
                        n18 /= n16;
                    }
                    n15 = n18;
                }
            }
            if ((n14 = (int)((float)n15 * f)) < 1) {
                n14 = 1;
            }
            Font font2 = new Font(font.getFontName(), font.getStyle(), n14);
            component.setFont(font2);
        }
        if (component != null && component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Icon icon = abstractButton.getIcon();
            if (icon instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
        }
        if (bl) {
            // empty if block
        }
    }

    public void renderFormsOntoG2(Graphics2D graphics2D, int n, float f, int n2) {
        AffineTransform affineTransform;
        block12: {
            affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = graphics2D.getTransform();
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(0.0, -this.pageHeight - this.insetH);
            graphics2D.setTransform(affineTransform2);
            int n3 = this.trackPagesRendered[n];
            try {
                Component[] componentArray = this.allFields;
                if (componentArray == null || n3 == -1) break block12;
                JPanel jPanel = new JPanel();
                int n4 = this.indent;
                this.indent = 0;
                while (this.compData.pageMap[n3] == n) {
                    Component component = componentArray[n3];
                    if (component != null && component.isVisible()) {
                        float f2 = this.compData.boundingBoxs[n3][3] - this.compData.boundingBoxs[n3][1];
                        int n5 = component.getPreferredSize().height;
                        if (component instanceof JList && ((JList)component).getSelectedIndex() != -1 && f2 < (float)n5) {
                            JList jList = (JList)component;
                            jPanel.add(component);
                            ListModel listModel = jList.getModel();
                            Object[] objectArray = new Object[listModel.getSize()];
                            int n6 = jList.getSelectedIndex();
                            int n7 = 0;
                            objectArray[n7++] = listModel.getElementAt(n6);
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (i == n6) continue;
                                objectArray[n7++] = listModel.getElementAt(i);
                            }
                            jList.setListData(objectArray);
                            jList.setSelectedIndex(0);
                            try {
                                this.renderComponent(graphics2D, n3, jList, n2);
                                jPanel.remove(jList);
                            }
                            catch (Exception exception) {}
                        } else {
                            jPanel.add(component);
                            try {
                                this.renderComponent(graphics2D, n3, component, n2);
                                jPanel.remove(component);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (++n3 != this.compData.pageMap.length) continue;
                    break;
                }
                this.indent = n4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        graphics2D.setTransform(affineTransform);
        if (this.currentPage == n && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void renderComponent(Graphics2D graphics2D, int n, Component component, int n2) {
        if (component != null) {
            boolean bl = false;
            if (component instanceof JComboBox) {
                if (((JComboBox)component).isEditable()) {
                    bl = true;
                    ((JComboBox)component).setEditable(false);
                }
                if (!UIManager.getLookAndFeel().isNativeLookAndFeel() && ((JComboBox)component).getComponentCount() > 0) {
                    this.renderComponent(graphics2D, n, ((JComboBox)component).getComponent(0), n2);
                }
            }
            this.scaleComponent(this.currentPage, 1.0f, n2, n, component, false);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(component.getBounds().x - this.insetW, component.getBounds().y + this.cropOtherY);
            component.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
            if (bl) {
                ((JComboBox)component).setEditable(true);
            }
        }
    }

    public Object getFormDataAsObject(String string) {
        return this.rawFormData.get(string);
    }

    public Object getWidget(Object object) {
        if (object == null) {
            return null;
        }
        Object v = this.nameToCompIndex.get(object);
        if (v == null) {
            return null;
        }
        int n = (Integer)v;
        return this.allFields[n];
    }

    public Object getValue(Object object) {
        if (object == null) {
            return "";
        }
        Object object2 = "";
        Object v = this.nameToCompIndex.get(object);
        object2 = this.formFactory.getFormValue(this.allFields, v);
        return object2;
    }

    public void setRollBackValue(Object object, Object object2) {
        this.lastUnformattedValue.put(object, this.getValue(object));
    }

    public void setValue(String string, Object object, boolean bl, boolean bl2) {
        if (bl) {
            this.lastValidValue.put(string, object);
        }
        if (bl2) {
            this.lastUnformattedValue.put(string, this.getValue(string));
        }
        Object v = this.nameToCompIndex.get(string);
        this.formFactory.setFormValue(this.allFields, object, v);
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    public Javascript getJavaScriptObject() {
        return this.javascript;
    }

    public void setJavaScriptObject(Javascript javascript, Object object) {
        this.javascript = javascript;
    }

    public Object[] getComponentsByName(String string) {
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i, null, this.scaling, this.rotation);
        }
        if (string == null) {
            return this.formFactory.returnAllComponents(this.allFields);
        }
        Object v = this.nameToCompIndex.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return this.formFactory.getComponentsByName(this.allFields, string, v);
        }
        LogWriter.writeFormLog("{stream} ERROR DefaultAcroRenderer.getComponentByName() Object NOT Integer and NOT null", false);
        return null;
    }

    public List getComponentNameList() throws PdfException {
        if (this.trackPagesRendered == null | this.fieldCount == 0) {
            return null;
        }
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i, null, this.scaling, this.rotation);
        }
        return this.getComponentNameList(-1);
    }

    public List getComponentNameList(int n) throws PdfException {
        if (this.trackPagesRendered == null | this.fieldCount == 0) {
            return null;
        }
        if (n != -1 && this.trackPagesRendered[n] == -1) {
            return null;
        }
        int n2 = n == -1 ? 0 : this.trackPagesRendered[n];
        ArrayList arrayList = new ArrayList();
        String string = "";
        String string2 = "";
        while (n == -1 || this.compData.pageMap[n2] == n) {
            string = this.formFactory.getComponentName(this.allFields, n2, arrayList, string);
            if (++n2 != this.compData.pageMap.length) continue;
            break;
        }
        return arrayList;
    }

    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
    }

    public void openFile(int n) {
        this.pageCount = n;
        this.type = 2;
        this.lastValidValue.clear();
        this.lastUnformattedValue.clear();
        this.rawFormData.clear();
    }

    public List getAllComponents() throws PdfException {
        return null;
    }

    public void setPageDisplacements(int[] nArray, int[] nArray2) {
        this.xReached = nArray;
        this.yReached = nArray2;
    }

    public String[] getDefaultValues() {
        return this.compData.getDefaultValues();
    }

    public Integer getTypeValueByName(String string) {
        return (Integer)this.typeValues.get(string);
    }

    public void loseFocus() {
        this.panel.grabFocus();
    }

    public Iterator getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public Map getSignatureObject(String string) {
        Map map = this.currentPdfFile.readObject(string, false, null);
        Object v = map.get("V");
        if (v == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Name", "x");
        hashMap.put("Reason", "x");
        hashMap.put("Location", "x");
        hashMap.put("M", "x");
        hashMap.put("Cert", "x");
        map = v instanceof String ? this.currentPdfFile.readObject((String)v, false, hashMap) : (Map)v;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            byte[] byArray = (byte[])map.get(k);
            if (byArray == null || k.equals("Cert")) continue;
            map.put(k, this.currentPdfFile.getTextString(byArray));
        }
        return map;
    }
}

