/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.DurationFormat;
import com.projity.options.CalendarOption;
import com.projity.options.ScheduleOption;
import com.projity.util.MathUtils;

public class Duration
extends Number
implements Comparable {
    private static final long serialVersionUID = 1489291902577173002L;
    private long encodedMillis;
    protected boolean work = false;
    public static final long MAX_DURATION = 105120000000L;
    public static final Duration ZERO = new Duration(0L);
    private static int SHIFT = 57;
    private static long ESTIMATED_BIT = 32L << SHIFT;
    private static long ELAPSED_BIT = 16L << SHIFT;
    private static long PERCENT_BIT = 15L << SHIFT;
    private static long YEARS_BIT = 14L << SHIFT;
    private static long MONTHS_BIT = 13L << SHIFT;
    private static long WEEKS_BIT = 12L << SHIFT;
    private static long DAYS_BIT = 11L << SHIFT;
    private static long HOURS_BIT = 10L << SHIFT;
    private static long MINUTES_BIT = 9L << SHIFT;
    private static long SECONDS_BIT = 8L << SHIFT;
    private static long NON_TEMPORAL_BIT = 7L << SHIFT;
    private static long UNITS_MASK = 15L << SHIFT;
    private static long ELAPSED_AND_UNITS_MASK = 31L << SHIFT;
    private static long MILLIS_MASK = 63L << SHIFT ^ 0xFFFFFFFFFFFFFFFFL;

    private Duration(Double d) {
        this(d == null ? 0L : d.longValue());
    }

    public Duration(long l) {
        this.encodedMillis = l;
    }

    public String toString() {
        return DurationFormat.getInstance().format(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Duration) {
            return this.encodedMillis == ((Duration)object).encodedMillis;
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Duration)) {
            throw new ClassCastException();
        }
        return MathUtils.signum(Duration.getValue(this.encodedMillis) - Duration.getValue(((Duration)object).getEncodedMillis()));
    }

    public long getEncodedMillis() {
        return this.encodedMillis;
    }

    public void setEncodedMillis(long l) {
        this.encodedMillis = l;
    }

    public void setWork(boolean bl) {
        this.work = bl;
    }

    public boolean isWork() {
        return this.work;
    }

    public static long clear(long l) {
        return l & ELAPSED_AND_UNITS_MASK;
    }

    public static boolean isZero(long l) {
        return Duration.millis(l) == 0L;
    }

    private static long getBits(long l, long l2) {
        if (l2 < 0L) {
            l2 = -l2;
        }
        return l2 & l;
    }

    private static long setBits(long l, long l2) {
        boolean bl;
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 = -l2;
        }
        l2 |= l;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    private static long clearBits(long l, long l2) {
        boolean bl;
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 = -l2;
        }
        l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    private static long setBits(long l, long l2, long l3) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        long l4 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        l = l4 | l3;
        if (bl) {
            l = -l;
        }
        return l;
    }

    public static boolean isElapsed(long l) {
        return Duration.getBits(ELAPSED_BIT, l) == ELAPSED_BIT;
    }

    public static long setAsElapsed(long l) {
        return Duration.setBits(l, ELAPSED_BIT, ELAPSED_BIT);
    }

    public static boolean isEstimated(long l) {
        return Duration.getBits(ESTIMATED_BIT, l) == ESTIMATED_BIT;
    }

    public static long setAsEstimated(long l, boolean bl) {
        if (bl) {
            return Duration.setBits(ESTIMATED_BIT, l);
        }
        return Duration.clearBits(ESTIMATED_BIT, l);
    }

    public static boolean hasUnits(long l) {
        return Duration.getBits(UNITS_MASK, l) != 0L;
    }

    public static long millis(long l) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        l &= MILLIS_MASK;
        if (bl) {
            l = -l;
        }
        return l;
    }

    public static float getPercentAsDecimal(long l) {
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        return Float.intBitsToFloat(n);
    }

    public static long setPercentAsDecimal(long l, float f) {
        l &= 0xFFFFFFFF00000000L;
        return l |= (long)Float.floatToIntBits(f);
    }

    public static boolean isPercent(long l) {
        return Duration.getBits(UNITS_MASK, l) == PERCENT_BIT;
    }

    public static long setAsPercent(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, PERCENT_BIT);
    }

    public static long setAsElapsedPercent(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | PERCENT_BIT);
    }

    public static long setAsNonTemporal(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, NON_TEMPORAL_BIT);
    }

    public static long setAsSeconds(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, SECONDS_BIT);
    }

    public static long setAsElapsedSeconds(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | SECONDS_BIT);
    }

    public static long setAsMinutes(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, MINUTES_BIT);
    }

    public static long setAsElapsedMinutes(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | MINUTES_BIT);
    }

    public static long setAsHours(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, HOURS_BIT);
    }

    public static long setAsElapsedHours(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | SECONDS_BIT);
    }

    public static long setAsDays(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, DAYS_BIT);
    }

    public static long setAsElapsedDays(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | DAYS_BIT);
    }

    public static long setAsWeeks(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, WEEKS_BIT);
    }

    public static long setAsElapsedWeeks(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | WEEKS_BIT);
    }

    public static long setAsMonths(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, MONTHS_BIT);
    }

    public static long setAsElapsedMonths(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | MONTHS_BIT);
    }

    public static long setAsYears(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, YEARS_BIT);
    }

    public static long setAsElapsedYears(long l) {
        return Duration.setBits(l, ELAPSED_AND_UNITS_MASK, ELAPSED_BIT | YEARS_BIT);
    }

    public static long useTimeUnitOfInNone(long l, long l2) {
        if (Duration.getType(l) == -1) {
            return Duration.setAsTimeUnit(l, Duration.getType(l2));
        }
        return l;
    }

    public static long setAsTimeUnit(long l, int n) {
        switch (n) {
            case 6: {
                return Duration.setAsPercent(l);
            }
            case 13: {
                return Duration.setAsElapsedPercent(l);
            }
            case -2: {
                return Duration.setAsNonTemporal(l);
            }
            case 0: {
                return Duration.setAsMinutes(l);
            }
            case 7: {
                return Duration.setAsElapsedMinutes(l);
            }
            case 1: {
                return Duration.setAsHours(l);
            }
            case 8: {
                return Duration.setAsElapsedHours(l);
            }
            case 2: {
                return Duration.setAsDays(l);
            }
            case 9: {
                long l2 = Duration.setAsDays(l);
                long l3 = Duration.setAsElapsedDays(l);
                return Duration.setAsElapsedDays(l);
            }
            case 3: {
                return Duration.setAsWeeks(l);
            }
            case 10: {
                return Duration.setAsElapsedWeeks(l);
            }
            case 4: {
                return Duration.setAsMonths(l);
            }
            case 11: {
                return Duration.setAsElapsedMonths(l);
            }
            case 5: {
                return Duration.setAsYears(l);
            }
            case 12: {
                return Duration.setAsElapsedYears(l);
            }
        }
        return l;
    }

    public static double timeUnitFactor(int n) {
        double d = 1.0;
        if (n == -1) {
            n = ScheduleOption.getInstance().getDurationEnteredIn();
        }
        switch (n) {
            case -2: {
                return 1.0;
            }
            case 0: 
            case 7: {
                return 60000.0;
            }
            case 1: 
            case 8: {
                return 3600000.0;
            }
            case 2: {
                return CalendarOption.getInstance().getHoursPerDay() * 60.0 * 60.0 * 1000.0;
            }
            case 9: {
                return 8.64E7;
            }
            case 3: {
                return CalendarOption.getInstance().getHoursPerWeek() * 60.0 * 60.0 * 1000.0;
            }
            case 10: {
                return 6.048E8;
            }
            case 4: {
                return CalendarOption.getInstance().hoursPerMonth() * 60.0 * 60.0 * 1000.0;
            }
            case 11: {
                return 2.592E9;
            }
            case 5: {
                return 365.0 * CalendarOption.getInstance().getHoursPerDay() * 60.0 * 60.0 * 1000.0;
            }
            case 12: {
                return 1.471228928E9;
            }
        }
        return d;
    }

    public static long getInstance(double d, int n) {
        long l = 0L;
        l = n == 6 || n == 13 ? Duration.setPercentAsDecimal(l, (float)d) : Math.round(d * Duration.timeUnitFactor(n));
        l = Duration.setAsTimeUnit(l, n);
        return l;
    }

    public static double getValue(long l) {
        int n = Duration.getEffectiveType(l);
        if (n == 6 || n == 13) {
            return Duration.getPercentAsDecimal(l);
        }
        return (double)Duration.millis(l) / Duration.timeUnitFactor(n);
    }

    public static int getType(long l) {
        long l2 = Duration.getBits(ELAPSED_AND_UNITS_MASK, l);
        if (l2 == PERCENT_BIT) {
            return 6;
        }
        if (l2 == (ELAPSED_BIT | PERCENT_BIT)) {
            return 13;
        }
        if (l2 == YEARS_BIT) {
            return 5;
        }
        if (l2 == (ELAPSED_BIT | YEARS_BIT)) {
            return 12;
        }
        if (l2 == MONTHS_BIT) {
            return 4;
        }
        if (l2 == (ELAPSED_BIT | MONTHS_BIT)) {
            return 11;
        }
        if (l2 == WEEKS_BIT) {
            return 3;
        }
        if (l2 == (ELAPSED_BIT | WEEKS_BIT)) {
            return 10;
        }
        if (l2 == DAYS_BIT) {
            return 2;
        }
        if (l2 == (ELAPSED_BIT | DAYS_BIT)) {
            return 9;
        }
        if (l2 == HOURS_BIT) {
            return 1;
        }
        if (l2 == (ELAPSED_BIT | HOURS_BIT)) {
            return 8;
        }
        if (l2 == MINUTES_BIT) {
            return 0;
        }
        if (l2 == (ELAPSED_BIT | MINUTES_BIT)) {
            return 7;
        }
        if (l2 == NON_TEMPORAL_BIT) {
            return -2;
        }
        return -1;
    }

    public static int getEffectiveType(long l) {
        int n = Duration.getType(l);
        if (n == -1) {
            n = ScheduleOption.getInstance().getDurationEnteredIn();
        }
        return n;
    }

    public static Duration getInstanceFromDouble(Double d) {
        return new Duration(d);
    }

    @Override
    public double doubleValue() {
        return Duration.millis(this.encodedMillis);
    }

    @Override
    public float floatValue() {
        return Duration.millis(this.encodedMillis);
    }

    @Override
    public int intValue() {
        return (int)Duration.millis(this.encodedMillis);
    }

    @Override
    public long longValue() {
        return Duration.millis(this.encodedMillis);
    }

    public double getAsHours() {
        return this.doubleValue() / Duration.timeUnitFactor(1);
    }

    public double getAsDays() {
        return this.doubleValue() / Duration.timeUnitFactor(2);
    }
}

