/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.snapshot.SnapshottableImpl;
import com.projity.strings.Messages;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public final class BaselineDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    boolean hasTasksSelected;
    boolean entire = true;
    private Form form;
    JComboBox baseline;
    JRadioButton entireProject;
    JRadioButton selectedTasks;
    ButtonGroup radioGroup;

    public final void setHasTasksSelected(boolean bl) {
        this.hasTasksSelected = bl;
        this.selectedTasks.setEnabled(bl);
        if (!bl) {
            this.entire = true;
        }
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            this.selectedTasks.setSelected(!this.entire);
            this.entireProject.setSelected(this.entire);
            this.baseline.setSelectedIndex(this.form.getBaselineNumber());
        } else {
            this.form.setEntireProject(this.entire);
            this.form.setBaselineNumber(this.baseline.getSelectedIndex());
        }
        return true;
    }

    public static BaselineDialog getInstance(GraphicManager graphicManager, Form form, boolean bl, boolean bl2) {
        BaselineDialog baselineDialog = null;
        if (baselineDialog == null) {
            baselineDialog = new BaselineDialog(graphicManager.getFrame(), form, bl2);
            graphicManager.setBaselineDialog(baselineDialog);
        } else {
            baselineDialog.setHasTasksSelected(bl2);
        }
        baselineDialog.setTitle(Messages.getString(bl ? "Text.SaveBaseline" : "Text.ClearBaseline"));
        baselineDialog.addDocHelp(bl ? "Save_Baseline_Dialog" : "Clear_Baseline_Dialog");
        return baselineDialog;
    }

    private BaselineDialog(Frame frame, Form form, boolean bl) {
        super(frame, "", true);
        this.hasTasksSelected = bl;
        this.form = form != null ? form : new Form();
    }

    protected void initControls() {
        this.baseline = new JComboBox<String>(SnapshottableImpl.getSnapshotNames());
        this.entireProject = new JRadioButton(Messages.getString("Text.EntireProject"));
        this.selectedTasks = new JRadioButton(Messages.getString("Text.SelectedTasks"));
        this.entireProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaselineDialog.this.entire = ((JRadioButton)actionEvent.getSource()).isSelected();
            }
        });
        this.selectedTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaselineDialog.this.entire = !((JRadioButton)actionEvent.getSource()).isSelected();
            }
        });
        this.radioGroup = new ButtonGroup();
        this.radioGroup.add(this.entireProject);
        this.radioGroup.add(this.selectedTasks);
        this.setHasTasksSelected(this.hasTasksSelected);
        this.bind(true);
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, fill:80dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("BaselineDialog.Baseline"));
        defaultFormBuilder.append(this.baseline);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addSeparator("");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("BaselineDialog.For"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.entireProject);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.selectedTasks);
        return defaultFormBuilder.getPanel();
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    public static class Form {
        int baselineNumber = 0;
        boolean entireProject = true;

        public int getBaselineNumber() {
            return this.baselineNumber;
        }

        public void setBaselineNumber(int n) {
            this.baselineNumber = n;
        }

        public boolean isEntireProject() {
            return this.entireProject;
        }

        public void setEntireProject(boolean bl) {
            this.entireProject = bl;
        }
    }
}

