/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.association.AssociationList;
import com.projity.configuration.Configuration;
import com.projity.dialog.InformationDialog;
import com.projity.dialog.util.FieldComponentMap;
import com.projity.field.Field;
import com.projity.help.HelpUtil;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyNodeModelDataFactory;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.frames.DocumentSelectedEvent;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.key.HasId;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;

public class TaskInformationDialog
extends InformationDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane taskTabbedPane;
    private int notesTabIndex;
    private int resourcesTabIndex;
    protected SpreadSheet predecessorsSpreadSheet;
    public static final String DEPENDENCY_SPREADSHEET = "dependencySpreadsheet";
    protected SpreadSheet successorsSpreadSheet;
    protected SpreadSheet assignmentSpreadSheet;

    public static TaskInformationDialog getInstance(Frame frame, Task task, boolean bl) {
        return new TaskInformationDialog(frame, task, bl);
    }

    private TaskInformationDialog(Frame frame, Task task, boolean bl) {
        super(frame, Messages.getString("TaskInformationDialog.TaskInformation"));
        this.setObjectClass(Task.class);
        this.setObject(task);
        this.addDocHelp("Task_Information_Dialog");
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        String string = Messages.getString("TaskInformationDialog.TaskInformation");
        if (object != null) {
            string = string + " - " + ((HasId)object).getId();
        }
        this.setTitle(string);
    }

    @Override
    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("350dlu:grow", "fill:250dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this.taskTabbedPane = new JTabbedPane();
        this.taskTabbedPane.addTab(Messages.getString("TaskInformationDialog.General"), this.createGeneralPanel());
        this.taskTabbedPane.addTab(Messages.getString("TaskInformationDialog.Predecessors"), this.createPredecessorsPanel());
        this.taskTabbedPane.addTab(Messages.getString("TaskInformationDialog.Successors"), this.createSuccessorsPanel());
        String string = Messages.getString("TaskInformationDialog.Resources");
        this.taskTabbedPane.addTab(string, this.createResourcesPanel());
        this.resourcesTabIndex = this.taskTabbedPane.indexOfTab(string);
        this.taskTabbedPane.addTab(Messages.getString("TaskInformationDialog.Advanced"), this.createAdvancedPanel());
        String string2 = Messages.getString("TaskInformationDialog.Notes");
        this.taskTabbedPane.addTab(string2, this.createNotesPanel());
        this.notesTabIndex = this.taskTabbedPane.indexOfTab(string2);
        defaultFormBuilder.add(this.taskTabbedPane);
        this.mainComponent = this.taskTabbedPane;
        return defaultFormBuilder.getPanel();
    }

    public void showNotes() {
        this.taskTabbedPane.setSelectedIndex(this.notesTabIndex);
    }

    public void showResources() {
        this.taskTabbedPane.setSelectedIndex(this.resourcesTabIndex);
    }

    @Override
    protected JComponent createHeaderFieldsPanel(FieldComponentMap fieldComponentMap) {
        FormLayout formLayout = new FormLayout("p,3dlu,300dlu", "p,3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        fieldComponentMap.append(defaultFormBuilder, "Field.name");
        defaultFormBuilder.nextLine();
        return defaultFormBuilder.getPanel();
    }

    private JComponent createGeneralPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("max(50dlu;pref), 3dlu, 90dlu 10dlu, p, 3dlu,90dlu,60dlu", "p, 3dlu,p, 3dlu,p, 3dlu, p, 3dlu, p, 3dlu, p,3dlu, p, 3dlu,p, 3dlu, fill:50dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 8));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.duration");
        fieldComponentMap.append(defaultFormBuilder, "Field.estimated");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.percentComplete");
        fieldComponentMap.append(defaultFormBuilder, "Field.priority");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.cost");
        fieldComponentMap.append(defaultFormBuilder, "Field.work");
        defaultFormBuilder.nextLine(4);
        defaultFormBuilder.addSeparator(Messages.getString("TaskInformationDialog.Dates"));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.start");
        fieldComponentMap.append(defaultFormBuilder, "Field.finish");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.baselineStart");
        fieldComponentMap.append(defaultFormBuilder, "Field.baselineFinish");
        return defaultFormBuilder.getPanel();
    }

    private JComponent createAdvancedPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("max(50dlu;pref), 3dlu, 90dlu, 10dlu, p, 3dlu,90dlu,30dlu", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu, fill:50dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 8));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.wbs");
        fieldComponentMap.append(defaultFormBuilder, "Field.markTaskAsMilestone", 3);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addSeparator(Messages.getString("TaskInformationDialog.ConstrainTask"));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.constraintType");
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.constraintDate");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.deadline");
        defaultFormBuilder.nextLine(4);
        defaultFormBuilder.addSeparator("\t");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.taskType");
        fieldComponentMap.append(defaultFormBuilder, "Field.effortDriven", 3);
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.taskCalendar");
        fieldComponentMap.append(defaultFormBuilder, "Field.ignoreResourceCalendar", 3);
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.earnedValueMethod");
        return defaultFormBuilder.getPanel();
    }

    public JComponent createPredecessorsPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p:grow", "p,3dlu,p,3dlu,fill:150dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Spreadsheet.Dependency.predecessors") + ":");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.createPredecessorsSpreadsheet());
        JPanel jPanel = defaultFormBuilder.getPanel();
        HelpUtil.addDocHelp(jPanel, "Linking");
        return jPanel;
    }

    protected JScrollPane createPredecessorsSpreadsheet() {
        TaskInformationDialog taskInformationDialog = this;
        this.predecessorsSpreadSheet = new DependencySpreadSheet(this, true);
        this.predecessorsSpreadSheet.setSpreadSheetCategory(DEPENDENCY_SPREADSHEET);
        this.predecessorsSpreadSheet.setCanModifyColumns(false);
        this.predecessorsSpreadSheet.setCanSelectFieldArray(false);
        this.predecessorsSpreadSheet.setActions(new String[]{"Delete"});
        SpreadSheetUtils.createCollectionSpreadSheet(this.predecessorsSpreadSheet, this.object == null ? new AssociationList() : ((Task)this.object).getPredecessorList(), "View.TaskInformation.Predecessors", DEPENDENCY_SPREADSHEET, "Spreadsheet.Dependency.predecessors", true, new DependencyNodeModelDataFactory(), 0);
        return SpreadSheetUtils.makeSpreadsheetScrollPane(this.predecessorsSpreadSheet);
    }

    protected void updatePredecessorsSpreadsheet() {
        SpreadSheetUtils.updateCollectionSpreadSheet(this.predecessorsSpreadSheet, this.object == null ? new AssociationList() : ((Task)this.object).getPredecessorList(), new DependencyNodeModelDataFactory(), 0);
    }

    public JComponent createSuccessorsPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p:grow", "p,3dlu,p,3dlu,fill:150dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 1));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Spreadsheet.Dependency.successors") + ":");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.createSuccessorsSpreadsheet());
        JPanel jPanel = defaultFormBuilder.getPanel();
        HelpUtil.addDocHelp(jPanel, "Linking");
        return jPanel;
    }

    protected JScrollPane createSuccessorsSpreadsheet() {
        this.successorsSpreadSheet = new DependencySpreadSheet(this, false);
        this.successorsSpreadSheet.setSpreadSheetCategory(DEPENDENCY_SPREADSHEET);
        this.successorsSpreadSheet.setCanModifyColumns(false);
        this.successorsSpreadSheet.setCanSelectFieldArray(false);
        this.successorsSpreadSheet.setActions(new String[]{"Delete"});
        SpreadSheetUtils.createCollectionSpreadSheet(this.successorsSpreadSheet, this.object == null ? new AssociationList() : ((Task)this.object).getSuccessorList(), "View.TaskInformation.Successors", DEPENDENCY_SPREADSHEET, "Spreadsheet.Dependency.successors", false, new DependencyNodeModelDataFactory(), 0);
        return SpreadSheetUtils.makeSpreadsheetScrollPane(this.successorsSpreadSheet);
    }

    protected void updateSuccessorsSpreadsheet() {
        SpreadSheetUtils.updateCollectionSpreadSheet(this.successorsSpreadSheet, this.object == null ? new AssociationList() : ((Task)this.object).getSuccessorList(), new DependencyNodeModelDataFactory(), 0);
    }

    public JComponent createResourcesPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p:grow,0dlu,right:p", "p,3dlu,p,3dlu,fill:150dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 3));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("TaskInformationDialog.Resources") + ":", (Component)this.getAssignResourceButton());
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)this.createAssignmentSpreadsheet(), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 3));
        JPanel jPanel = defaultFormBuilder.getPanel();
        HelpUtil.addDocHelp(jPanel, "Assign_Resources");
        return jPanel;
    }

    protected JScrollPane createAssignmentSpreadsheet() {
        this.assignmentSpreadSheet = SpreadSheetUtils.createFilteredSpreadsheet(GraphicManager.getInstance(this).getCurrentFrame(), false, "View.TaskInformation.Assignments", "resourceAssignmentSpreadsheet", "Spreadsheet.Assignment.resourceUsage", true, new String[]{"Delete"});
        this.assignmentSpreadSheet.setActions(new String[]{"Delete"});
        this.updateAssignmentSpreadsheet();
        return SpreadSheetUtils.makeSpreadsheetScrollPane(this.assignmentSpreadSheet);
    }

    protected void updateAssignmentSpreadsheet() {
        SpreadSheetUtils.updateFilteredSpreadsheet(this.assignmentSpreadSheet, this.object == null ? new AssociationList() : ((NormalTask)this.object).getAssignments());
        ((SpreadSheetModel)this.assignmentSpreadSheet.getModel()).fireUpdateAll();
    }

    @Override
    public void updateAll() {
        this.activateListeners();
        super.updateAll();
        this.updatePredecessorsSpreadsheet();
        this.updateSuccessorsSpreadsheet();
        this.updateAssignmentSpreadsheet();
    }

    @Override
    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        if (this.assignmentSpreadSheet == null) {
            return;
        }
        DocumentFrame documentFrame = documentSelectedEvent.getCurrent();
        if (documentFrame != null) {
            NodeModelCache nodeModelCache = documentFrame.createCache(false, Messages.getString("View.TaskInformation.Assignments"));
            this.assignmentSpreadSheet.setCache(nodeModelCache);
        }
    }

    @Override
    protected void activateListeners() {
        super.activateListeners();
        this.predecessorsSpreadSheet.getCache().setReceiveEvents(true);
        this.successorsSpreadSheet.getCache().setReceiveEvents(true);
    }

    @Override
    protected void desactivateListeners() {
        super.desactivateListeners();
        this.predecessorsSpreadSheet.getCache().setReceiveEvents(false);
        this.successorsSpreadSheet.getCache().setReceiveEvents(false);
    }

    @Override
    protected boolean hasHelpButton() {
        return true;
    }

    private class DependencySpreadSheet
    extends SpreadSheet {
        InformationDialog dlg;
        Field clickField;
        boolean predecessor;

        DependencySpreadSheet(InformationDialog informationDialog, boolean bl) {
            this.dlg = informationDialog;
            this.clickField = Configuration.getFieldFromId(bl ? "Field.predecessorName" : "Field.successorName");
            this.predecessor = bl;
        }

        @Override
        public void doDoubleClick(int n, int n2) {
        }

        @Override
        public void doClick(int n, int n2) {
            Field field;
            Object object = this.getCurrentRowImpl();
            if (object != null && (field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2 + 1)) == this.clickField) {
                NormalTask normalTask = (NormalTask)(this.predecessor ? ((Dependency)object).getLeft() : ((Dependency)object).getRight());
                this.dlg.setObject(normalTask);
                this.dlg.updateAll();
                normalTask.getDocument().getObjectSelectionEventManager().fire(this, normalTask);
            }
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            Field field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2 + 1);
            if (field == this.clickField) {
                JLabel jLabel = (JLabel)component;
                jLabel.setText("<html><a href=\"\">" + jLabel.getText() + "</a></html>");
            }
            return component;
        }
    }
}

