/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.costing;

import com.projity.configuration.Settings;
import com.projity.datatype.Rate;
import com.projity.field.FieldContext;
import com.projity.interval.InvalidValueObjectForIntervalException;
import com.projity.pm.costing.Cost;
import com.projity.pm.costing.CostRate;
import com.projity.pm.costing.CostRateTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class CostRateTables
implements Cost,
Serializable,
Cloneable {
    public static final int DEFAULT = 0;
    protected CostRateTable[] costRateTableArray = new CostRateTable[Settings.NUM_COST_RATES];
    String[] names = null;

    String getName(int n) {
        if (this.names == null) {
            this.names = Settings.COST_RATE_NAMES.split(";");
        }
        return this.names[n];
    }

    public CostRateTable getCostRateTable(int n) {
        if (this.costRateTableArray[n] == null) {
            this.costRateTableArray[n] = new CostRateTable(this.getName(n));
        }
        return this.costRateTableArray[n];
    }

    public Object clone() {
        try {
            int n;
            CostRateTables costRateTables = (CostRateTables)super.clone();
            if (this.names != null) {
                costRateTables.names = new String[this.names.length];
            } else {
                for (n = 0; n < this.names.length; ++n) {
                    costRateTables.names[n] = this.names[n] == null ? null : new String(this.names[n]);
                }
            }
            if (this.costRateTableArray != null) {
                costRateTables.costRateTableArray = new CostRateTable[this.costRateTableArray.length];
                for (n = 0; n < this.costRateTableArray.length; ++n) {
                    CostRateTable costRateTable = costRateTables.costRateTableArray[n] = this.costRateTableArray[n] == null ? null : (CostRateTable)this.costRateTableArray[n].clone();
                    if (costRateTables.costRateTableArray[n] == null) continue;
                    costRateTables.costRateTableArray[n].initAfterCloning();
                }
            }
            return costRateTables;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setCostRateTable(int n, CostRateTable costRateTable) {
        this.costRateTableArray[n] = costRateTable;
    }

    private CostRate getCurrent() {
        return (CostRate)this.costRateTableArray[0].findCurrent();
    }

    @Override
    public double getCostPerUse() {
        return this.getCurrent().getCostPerUse();
    }

    @Override
    public Rate getOvertimeRate() {
        return this.getCurrent().getOvertimeRate();
    }

    @Override
    public Rate getStandardRate() {
        return this.getCurrent().getStandardRate();
    }

    @Override
    public void setCostPerUse(double d) {
        this.getCurrent().setCostPerUse(d);
    }

    @Override
    public void setOvertimeRate(Rate rate) {
        this.getCurrent().setOvertimeRate(rate);
    }

    @Override
    public void setStandardRate(Rate rate) {
        this.getCurrent().setStandardRate(rate);
    }

    public CostRateTables() {
        this.costRateTableArray[0] = new CostRateTable(this.getName(0));
    }

    @Override
    public long getEffectiveDate() {
        return this.getCurrent().getEffectiveDate();
    }

    @Override
    public void setEffectiveDate(long l) throws InvalidValueObjectForIntervalException {
        this.getCurrent().setEffectiveDate(l);
    }

    @Override
    public boolean isReadOnlyEffectiveDate(FieldContext fieldContext) {
        return this.getCurrent().isReadOnlyEffectiveDate(fieldContext);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.names);
        ArrayList[] arrayListArray = new ArrayList[this.costRateTableArray.length];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = this.costRateTableArray[i] == null ? null : this.costRateTableArray[i].getValueObjects();
        }
        objectOutputStream.writeObject(arrayListArray);
    }

    public static CostRateTables deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        CostRateTables costRateTables = new CostRateTables();
        costRateTables.names = (String[])objectInputStream.readObject();
        ArrayList[] arrayListArray = (ArrayList[])objectInputStream.readObject();
        costRateTables.costRateTableArray = new CostRateTable[arrayListArray.length];
        for (int i = 0; i < arrayListArray.length; ++i) {
            costRateTables.costRateTableArray[i] = arrayListArray[i] == null ? null : new CostRateTable(costRateTables.names[i], arrayListArray[i]);
        }
        return costRateTables;
    }

    @Override
    public boolean fieldHideOvertimeRate(FieldContext fieldContext) {
        return this.getCurrent().fieldHideOvertimeRate(fieldContext);
    }
}

