/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network;

import com.projity.graphic.configuration.BarStyle;
import com.projity.pm.graphic.graph.GraphInteractor;
import com.projity.pm.graphic.graph.GraphPopupMenu;
import com.projity.strings.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class NetworkPopupMenu
extends GraphPopupMenu {
    private static final long serialVersionUID = -3722404084932322411L;

    public NetworkPopupMenu(GraphInteractor graphInteractor) {
        super(graphInteractor);
    }

    @Override
    protected void init() {
        this.removeAll();
        final JMenu jMenu = new JMenu(Messages.getString("Network.Popup.barStylesMenu"));
        CollectionUtils.forAllDo(this.interactor.getGraph().getBarStyles().getRows(), new Closure(){

            @Override
            public void execute(Object object) {
                BarStyle barStyle = (BarStyle)object;
                BarMenuAction barMenuAction = new BarMenuAction(barStyle);
                jMenu.add(barMenuAction);
            }
        });
        this.add(jMenu);
    }

    private class BarMenuAction
    extends JRadioButtonMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 8977876028186923345L;
        BarStyle style;

        BarMenuAction(BarStyle barStyle) {
            super(barStyle.getName());
            this.style = barStyle;
            this.setSelected(barStyle.isActive());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.style.setActive(this.isSelected());
            NetworkPopupMenu.this.interactor.getGraph().getModel().updateAll(true);
        }
    }
}

