/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.common;

import com.projity.configuration.Dictionary;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.GradientCorner;
import com.projity.pm.graphic.spreadsheet.selection.SpreadSheetColumnsPopupMenu;
import com.projity.pm.graphic.spreadsheet.selection.SpreadSheetSelectionModel;
import com.projity.pm.graphic.spreadsheet.selection.TimeSpreadSheetColumnsPopupMenu;
import com.projity.pm.graphic.spreadsheet.time.TimeSpreadSheet;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpreadSheetCorner
extends GradientCorner
implements ListSelectionListener {
    protected CommonSpreadSheet spreadSheet;

    public SpreadSheetCorner(CommonSpreadSheet commonSpreadSheet) {
        if (commonSpreadSheet.isCanSelectFieldArray()) {
            this.setToolTipText("dummy");
        }
        this.spreadSheet = commonSpreadSheet;
        if (commonSpreadSheet instanceof SpreadSheet) {
            commonSpreadSheet.getRowHeader().getSelectionModel().addListSelectionListener(this);
        }
        if (!Environment.isNewLaf()) {
            this.setBorder(new LineBorder(Color.LIGHT_GRAY));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CommonSpreadSheet commonSpreadSheet = SpreadSheetCorner.this.spreadSheet;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    CommonSpreadSheet commonSpreadSheet2;
                    if (commonSpreadSheet instanceof CommonSpreadSheet && commonSpreadSheet.getSpreadSheetCategory() != null && (commonSpreadSheet2 = commonSpreadSheet).isCanSelectFieldArray()) {
                        if (commonSpreadSheet instanceof TimeSpreadSheet) {
                            TimeSpreadSheetColumnsPopupMenu timeSpreadSheetColumnsPopupMenu = new TimeSpreadSheetColumnsPopupMenu((TimeSpreadSheet)commonSpreadSheet2, commonSpreadSheet2.getSpreadSheetCategory());
                            timeSpreadSheetColumnsPopupMenu.show(commonSpreadSheet2, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            SpreadSheetColumnsPopupMenu spreadSheetColumnsPopupMenu = new SpreadSheetColumnsPopupMenu(commonSpreadSheet2, commonSpreadSheet2.getSpreadSheetCategory());
                            spreadSheetColumnsPopupMenu.show(commonSpreadSheet2, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                } else {
                    SpreadSheetSelectionModel spreadSheetSelectionModel = commonSpreadSheet.getSelection();
                    spreadSheetSelectionModel.getColumnSelection().setSelectionInterval(0, commonSpreadSheet.getColumnCount() - 1);
                    spreadSheetSelectionModel.getRowSelection().setSelectionInterval(0, commonSpreadSheet.getRowCount() - 1);
                    commonSpreadSheet.getRowHeader().getSelectionModel().setSelectionInterval(0, commonSpreadSheet.getRowCount() - 1);
                    if (Environment.isMac()) {
                        SpreadSheetCorner.this.setSelected(true);
                    }
                }
            }
        });
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return "<html>" + Dictionary.getCategoryText(this.spreadSheet.getSpreadSheetCategory()) + ": " + this.spreadSheet.getFieldArray() + "<br>" + Messages.getString("Text.rightClickSelectToSpreadsheet") + "<html>";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (Environment.isMac()) {
            if (this.selected) {
                this.setSelected(false);
            }
        } else {
            this.setSelected(listSelectionModel.getMinSelectionIndex() >= 0);
        }
    }
}

