/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.JDictionary;
import info.jdictionary.events.NewJDictionaryVersionEvent;
import info.jdictionary.listeners.NewJDictionaryVersionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class NewJDictionaryVersionChecker
extends Thread {
    private URL url;
    private float latestVersion;
    private boolean isNewerAvailable = false;
    private Vector newJDictionaryVersionListeners = new Vector();

    public NewJDictionaryVersionChecker() {
        try {
            this.url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("LatestFile")))));
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    public void run() {
        this.latestVersion = this.getLatestVersion();
        if (this.latestVersion > JDictionary.getJDictionaryVersion()) {
            this.isNewerAvailable = true;
            this.notifyNewJDictionaryVersionListeners(this.latestVersion);
        }
    }

    private float getLatestVersion() {
        if (this.url == null) {
            return 0.0f;
        }
        byte[] b = new byte[32];
        try {
            DataInputStream dis = new DataInputStream(this.url.openStream());
            dis.read(b);
        }
        catch (IOException e) {
            float f = 0.0f;
            return f;
        }
        Float f = new Float(new String(b));
        return f.floatValue();
    }

    void notifyNewJDictionaryVersionListeners(float latestVersion) {
        Vector tmpList;
        NewJDictionaryVersionEvent event = new NewJDictionaryVersionEvent(this, latestVersion);
        NewJDictionaryVersionChecker newJDictionaryVersionChecker = this;
        synchronized (newJDictionaryVersionChecker) {
            tmpList = (Vector)this.newJDictionaryVersionListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((NewJDictionaryVersionListener)tmpList.elementAt(i)).newJDictionaryVersionAvailable(event);
        }
    }

    public synchronized void addNewJDictionaryVersionListener(NewJDictionaryVersionListener listener) {
        this.newJDictionaryVersionListeners.addElement(listener);
    }

    public synchronized void removeNewJDictionaryVersionListener(NewJDictionaryVersionListener listener) {
        this.newJDictionaryVersionListeners.removeElement(listener);
    }
}

