/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.modules;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.Plugin;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.gui.OutputTabbedPane;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultOutput
extends JPanel {
    DefaultFrameAssembler assembler;
    HashMap outputCache = new HashMap();
    BorderLayout borderLayout = new BorderLayout();

    public DefaultOutput(DefaultFrameAssembler assembler) {
        this.assembler = assembler;
        this.setLayout(this.borderLayout);
        assembler.getJDictionary().getPluginManager().addPluginSelectionListener(new PluginSelectionListener(){

            public void pluginSelected(PluginSelectionEvent e) {
                if (e.getSelectedPlugin() != null) {
                    if (e.getSelectedSubPlugin() == null) {
                        DefaultOutput.this.show(e.getSelectedPlugin());
                    } else {
                        DefaultOutput.this.show(e.getSelectedPlugin(), e.getSelectedSubPlugin());
                    }
                }
            }
        });
    }

    private void show(PluginInfoSheet sheet) {
        JTabbedPane outputTabbedPane = (JTabbedPane)this.outputCache.get(sheet);
        if (outputTabbedPane == null) {
            outputTabbedPane = this.buildOutputTabbedPane(sheet);
        }
        if (this.getComponentCount() > 0 && this.getComponent(0) == outputTabbedPane) {
            return;
        }
        this.removeAll();
        this.add(outputTabbedPane);
        this.startPlugin(outputTabbedPane);
    }

    private void show(PluginInfoSheet sheet, String name) {
        JTabbedPane outputTabbedPane = (JTabbedPane)this.outputCache.get(sheet);
        if (outputTabbedPane == null) {
            outputTabbedPane = this.buildOutputTabbedPane(sheet);
        }
        for (int i = 0; i < outputTabbedPane.getTabCount(); ++i) {
            if (!outputTabbedPane.getTitleAt(i).equals(name)) continue;
            if (this.getComponentCount() > 0 && this.getComponent(0) instanceof OutputTabbedPane && (JTabbedPane)this.getComponent(0) == outputTabbedPane) {
                if (((JTabbedPane)this.getComponent(0)).getSelectedIndex() != i) {
                    outputTabbedPane.setSelectedIndex(i);
                    this.startPlugin(outputTabbedPane);
                }
                return;
            }
            this.removeAll();
            this.add(outputTabbedPane);
            outputTabbedPane.setSelectedIndex(i);
            this.startPlugin(outputTabbedPane);
            return;
        }
        this.show(sheet);
    }

    public void show(final Component comp) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultOutput.this.removeAll();
                DefaultOutput.this.add(comp);
                DefaultOutput.this.assembler.outputScrollPane.validate();
                DefaultOutput.this.assembler.outputScrollPane.repaint();
                DefaultOutput.this.assembler.getJDictionary().getPluginManager().selectPlugin(null, null);
            }
        });
    }

    OutputTabbedPane buildOutputTabbedPane(PluginInfoSheet sheet) {
        OutputTabbedPane outputTabbedPane = new OutputTabbedPane(sheet);
        ArrayList plugin = this.assembler.getJDictionary().getPluginManager().getPlugin(sheet);
        for (int count = plugin.size() - 1; count >= 0; --count) {
            Plugin pluginPiece = (Plugin)plugin.get(count);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            outputTabbedPane.add(pluginPiece.toString(), jPanel);
        }
        outputTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DefaultOutput.this.outputTabbedPane_stateChanged(e);
            }
        });
        this.outputCache.put(sheet, outputTabbedPane);
        return outputTabbedPane;
    }

    void outputTabbedPane_stateChanged(ChangeEvent e) {
        OutputTabbedPane outputTabbedPane = (OutputTabbedPane)e.getSource();
        this.startPlugin(outputTabbedPane);
        this.assembler.getJDictionary().getPluginManager().selectPlugin(outputTabbedPane.getSheet(), outputTabbedPane.getTitleAt(outputTabbedPane.getSelectedIndex()));
    }

    void startPlugin(JTabbedPane outputTabbedPane) {
        int selectedIndex = outputTabbedPane.getSelectedIndex();
        final JPanel contentPane = (JPanel)outputTabbedPane.getComponentAt(selectedIndex);
        if (contentPane.getComponentCount() > 0) {
            this.assembler.outputScrollPane.validate();
            this.assembler.outputScrollPane.repaint();
            return;
        }
        ArrayList plugin = this.assembler.getJDictionary().getPluginManager().getPlugin(((OutputTabbedPane)outputTabbedPane).getSheet());
        final Plugin pluginPiece = (Plugin)plugin.get(plugin.size() - (selectedIndex + 1));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                pluginPiece.construct(contentPane);
                pluginPiece.start();
                DefaultOutput.this.assembler.outputScrollPane.validate();
                DefaultOutput.this.assembler.outputScrollPane.repaint();
            }
        });
    }
}

