package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * this class will not work properly if you are using the DefaultListCellRenderer.
 * Use the slightly modified CustomListCellRenderer instead.
 */
public class KunststoffListUI extends BasicListUI {
  private boolean isToolkitTrueColor = false;
  private Color colBg;
  private Color col1;
  private Color col2;

  private int shadow = 48;

  public KunststoffListUI(JComponent list) {
    // this will be needed for the decision if a big gradient or a small shadow
    // should be painted. On 16-bit colors the big gradient looks awkward, therefore
    // we will then paint a small shadow instead
    isToolkitTrueColor = isToolkitTrueColor(list);
  }

  public static ComponentUI createUI(JComponent list) {
    return new KunststoffListUI(list);
  }


  /**
   * Returns true if the display uses 24- or 32-bit color depth
   */
  private boolean isToolkitTrueColor(Component c) {
    int pixelsize = c.getToolkit().getColorModel().getPixelSize();
    return pixelsize >= 24;
  }


  public void update(Graphics g, JComponent c) {
    if (c.isOpaque()) {
      Graphics2D g2D = (Graphics2D) g;
      colBg = c.getBackground();
      int red = colBg.getRed();
      int green = colBg.getGreen();
      int blue = colBg.getBlue();
      g2D.setColor(colBg);
      g2D.fill(g.getClipBounds());

      col1 = new Color(red>=shadow?red-shadow:0, green>=shadow?green-shadow:0, blue>=shadow?blue-shadow:0);
      col2 = getTranslucentColor(col1, 0);
      Rectangle cb = g.getClipBounds();
      if (isToolkitTrueColor) {
        // paint big gradient
        GradientPaint gradient = new GradientPaint(0f, 0f, colBg, (float) list.getWidth(), 0f, new Color(224, 224, 224));
        g2D.setPaint(gradient);
        g2D.fill(cb);
      } else {
        // paint shadow
        g2D.setColor(colBg);
        g2D.fill(cb);
        GradientPaint gradientTop = new GradientPaint(0f, 0f, col1, 0f, 5f, col2);
        g2D.setPaint(gradientTop);
        g2D.fill(new Rectangle(cb.x, cb.y, cb.width, 20));
        GradientPaint gradientLeft = new GradientPaint(0f, 0f, col1, 5f, 0f, col2);
        g2D.setPaint(gradientLeft);
        g2D.fill(new Rectangle(cb.x, cb.y, 20, cb.height));
      }
    }
    paint(g, c);
  }

  // helper to simplify creation of translucent colors
  private static Color getTranslucentColor(Color c, int alpha) {
    return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
  }

}