/*
 * 01/09/2002 - 20:43:57
 *
 * ImageBank.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary;

import javax.swing.ImageIcon;
import java.net.URL;


public class ImageBank {
    static String path;
    static ImageBank imageBank;
    static {
        imageBank = new ImageBank();
        //creating path in the jDictionary.jar file
        path = "/" + JDictionary.getString("ResourcesDirName") + "/" + JDictionary.getString("ImagesDirName") + "/" + JDictionary.getLanguage() + "/";
        if(imageBank.getClass().getResource(path) == null)
            path = "/" + JDictionary.getString("ResourcesDirName") + "/" + JDictionary.getString("ImagesDirName") + "/default/";

    }

    public static ImageIcon MainHeaderLeftSide = new ImageIcon(imageBank.getURLForFile("MainHeaderLeftSide.png"));
    public static ImageIcon MainHeaderRightSide = new ImageIcon(imageBank.getURLForFile("MainHeaderRightSide.png"));
    public static ImageIcon AboutHeader = new ImageIcon(imageBank.getURLForFile("AboutHeader.png"));
    public static ImageIcon AboutText = new ImageIcon(imageBank.getURLForFile("AboutText.png"));
    public static ImageIcon AllPluginsDeactivatedHeader = new ImageIcon(imageBank.getURLForFile("AllPluginsDeactivatedHeader.png"));
    public static ImageIcon AllPluginsDeactivatedText = new ImageIcon(imageBank.getURLForFile("AllPluginsDeactivatedText.png"));
    public static ImageIcon DownloadHeader = new ImageIcon(imageBank.getURLForFile("DownloadHeader.png"));
    public static ImageIcon NoPluginsHeader = new ImageIcon(imageBank.getURLForFile("NoPluginsHeader.png"));
    public static ImageIcon NoPluginsText = new ImageIcon(imageBank.getURLForFile("NoPluginsText.png"));
    public static ImageIcon RemoveHeader = new ImageIcon(imageBank.getURLForFile("ActivateHeader.png"));
    public static ImageIcon NewVersionHeader = new ImageIcon(imageBank.getURLForFile("NewVersionHeader.png"));
    public static ImageIcon Spacer = new ImageIcon(imageBank.getURLForFile("Spacer.jpg"));

     final URL getURLForFile(String fileName) {
        return getClass().getResource(path + fileName);
    }



}


