/*
 * 01/09/2002 - 20:43:57
 *
 * NewVersionInfoPanel.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import info.jdictionary.*;
import javax.swing.*;
import java.awt.*;
import java.net.*;


public class NewVersionInfoPanel extends JPanel {

    JLabel header = new JLabel(ImageBank.NewVersionHeader);
    JLabel text;
    JLabel waitText = new JLabel(JDictionary.getString("InfoAboutNewVersion"), IconBank.info, 0);
    BorderLayout borderLayout = new BorderLayout();
    JPanel jPanel = new JPanel();
    BoxLayout boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);

    public NewVersionInfoPanel() {
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {

        setLayout(boxLayout);
        setBackground(Color.white);
        jPanel.setLayout(borderLayout);
        jPanel.setBackground(Color.white);
        jPanel.setAlignmentX((float) 0.0);
        jPanel.add(waitText, BorderLayout.CENTER);
        this.add(header, null);
        this.add(jPanel, null);
        downloadInfos();

    }

    void downloadInfos() {
        new Thread() {
            public void run() {
                URL textURL = null;
                try {
                    textURL = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoAboutNewVersionFile"));
                } catch (java.net.MalformedURLException e) {}
                text = new JLabel(new ImageIcon(textURL));
                jPanel.removeAll();
                jPanel.add(text, BorderLayout.CENTER);
                jPanel.validate();
            }
        }
        .start();
    }
}
