/*
 * 01/09/2002 - 20:43:57
 *
 * PluginLoader.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.pluginstuff;

import java.io.*;
import java.util.jar.*;
import java.util.zip.*;


public class PluginLoader extends ClassLoader {
    String path;


    public PluginLoader(String path) {
        this.path = path;
    }


    public String getPath() {
        return path;
    }


    private byte[] loadClassData(String name) throws ClassNotFoundException {
        ZipFile jarFile = null;

        try {
            jarFile = new JarFile(path);
        }
        catch (java.io.IOException ex) {}

        byte[] b = null;
        if (!name.endsWith(".class"))
            name = (name + ".class");

        System.out.println("PluginLoader: I'm attempting to load file named: " + name + " form JAR: " + jarFile.getName());
        try {
            ZipEntry entry = jarFile.getEntry(name);
            if (entry != null) {
                int offset = 0;
                int loadedBytesCount = 0;
                int entryLength = (int) entry.getSize();
                b = new byte[entryLength];
                InputStream fin = jarFile.getInputStream(entry);
                while (loadedBytesCount < entryLength) {
                    entryLength -= loadedBytesCount;
                    offset += loadedBytesCount;
                    loadedBytesCount = fin.read(b, offset, entryLength);
                    //System.out.println("PluginLoader: Successfully loaded bytes count: " + (offset + loadedBytesCount) + " from file: " + entry.getName() + " from JAR: " + jarFile.getName());
                    if (loadedBytesCount == -1) {
                        System.err.println("PluginLoader: Wrong thing happened when I attempted to load the class named: " + name + "from jar named: " + jarFile.getName());
                        throw new ClassNotFoundException(name);
                    }
                }
                fin.close();
            } else
                System.out.println("PluginLoader: File Not Found: " + entry.getName());

        }
        catch (java.io.IOException ex) {
            System.out.println("PluginLoader: IOException");
            throw new ClassNotFoundException(name);
        }
       try {
            jarFile.close();
        } catch (java.io.IOException ex) {}

        return b;
    }


    public Class findClass(String name) {
        if (name.endsWith(".class")) {
            name = name.substring(0, (name.length() - 6));
        }
        byte[] b = null;
        try {
            b = loadClassData(name);
        } catch (java.lang.ClassNotFoundException ex) {
            System.out.println("PluginLoader: ClassNotFoundException " + ex);
        }
        Class c = defineClass(name, b, 0, b.length);

        return c;
    }
}