/*
 * Decompiled with CFR 0.152.
 */
import emsl.inch.ComponentPanel;
import emsl.inch.ComponentTransfer;
import emsl.objects.DocumentSize;
import emsl.text.AttributeList;
import emsl.text.EditPanel;
import emsl.text.TextData;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class Document
implements Serializable {
    private String name;
    private TextData textData;
    private DocumentSize documentSize;
    private Color color;
    private int totalPages;

    public Document() {
        this.setName("Untitled");
        this.setTextData(new TextData());
        this.setDocumentSize(new DocumentSize());
        this.setColor(Color.white);
        this.setTotalPages(1);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setTotalPages(int n) {
        this.totalPages = n;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTextData(TextData textData) {
        this.textData = textData;
    }

    public TextData getTextData() {
        return this.textData;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setDocumentSize(DocumentSize documentSize) {
        this.documentSize = documentSize;
    }

    public DocumentSize getDocumentSize() {
        return this.documentSize;
    }

    public String getAsText() {
        return this.getTextData().getString();
    }

    public void setAsText(String string) {
        TextData textData = new TextData();
        textData.insert(string, 1);
        this.setTextData(textData);
    }

    public Hashtable getAsHashtable() {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        hashtable.put("Color", this.getColor());
        hashtable.put("DocumentSize", this.getDocumentSize());
        hashtable.put("TotalPages", new Integer(this.getTotalPages()));
        hashtable.put("StyleList", this.getTextData().getStyleList());
        hashtable.put("OwnerList", this.getTextData().getOwnerList());
        hashtable.put("CharacterList", this.getTextData().getCharacterList().getCharacterList());
        Vector vector = this.getTextData().getCharacterList().getComponentList();
        int n = 0;
        while (n < vector.size()) {
            ComponentPanel componentPanel = (ComponentPanel)vector.elementAt(n);
            ComponentTransfer componentTransfer = new ComponentTransfer(componentPanel);
            hashtable.put("ComponentTransfer " + n, componentTransfer);
            Component component = componentPanel.getComponent();
            if (component != null) {
                hashtable.put("Component " + n, component);
            }
            ++n;
        }
        return hashtable;
    }

    public void setAsHashtable(Hashtable hashtable) {
        Serializable serializable;
        try {
            this.setColor((Color)hashtable.get("Color"));
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : Color not found");
        }
        try {
            this.setDocumentSize((DocumentSize)hashtable.get("DocumentSize"));
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : DocumentSize not found");
        }
        try {
            this.setTotalPages((Integer)hashtable.get("TotalPages"));
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : TotalPages not found");
        }
        TextData textData = new TextData();
        try {
            serializable = (AttributeList)hashtable.get("StyleList");
            if (serializable == null) {
                throw new Exception();
            }
            textData.setStyleList((AttributeList)serializable);
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : StyleList not found");
        }
        try {
            serializable = (AttributeList)hashtable.get("OwnerList");
            if (serializable == null) {
                throw new Exception();
            }
            textData.setOwnerList((AttributeList)serializable);
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : OwnerList not found");
        }
        try {
            serializable = (StringBuffer)hashtable.get("CharacterList");
            if (serializable == null) {
                throw new Exception();
            }
            textData.getCharacterList().setCharacterList((StringBuffer)serializable);
        }
        catch (Exception exception) {
            System.out.println("setAsHashtable : CharacterList not found");
        }
        serializable = new Vector();
        int n = 0;
        while (n < hashtable.size()) {
            try {
                ComponentTransfer componentTransfer = (ComponentTransfer)hashtable.get("ComponentTransfer " + n);
                EditPanel editPanel = new EditPanel();
                componentTransfer.setComponentPanel(editPanel);
                ((Vector)serializable).addElement(editPanel);
                Component component = (Component)hashtable.get("Component " + n);
                if (component != null) {
                    editPanel.setComponent(component);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        textData.getCharacterList().setComponentList((Vector)serializable);
        this.setTextData(textData);
    }
}

