/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;

public class GUIPageBar
extends GUIPanel
implements ActionListener {
    private Dimension iconSize;
    private GUIPanel panel;
    private ActionListener listener;
    private GUIChoice viewScale;
    private GUIChoice pageList;
    private GUIButton textMode;
    private GUIButton layoutMode;

    public GUIPageBar(ActionListener actionListener) {
        super(new Dimension(-1, -2), 1);
        this.setLayout(new BorderLayout());
        this.iconSize = new Dimension(33, 33);
        this.listener = actionListener;
        GUIPanel gUIPanel = new GUIPanel();
        this.add("West", gUIPanel);
        gUIPanel.setLayout(new FlowLayout(0, 10, 2));
        GUIPanel gUIPanel2 = new GUIPanel();
        this.add("East", gUIPanel2);
        gUIPanel2.setLayout(new FlowLayout(2, 10, 2));
        this.newGroup(gUIPanel2);
        this.add("New Page", "newPage.gif");
        this.newGroup(gUIPanel2);
        this.add("Page Up", "pageDown.gif");
        this.panel.add(this.createPageListChoice());
        this.add("Page Down", "pageUp.gif");
        this.newGroup(gUIPanel);
        this.panel.add(this.createViewScaleChoice());
        this.newGroup(gUIPanel);
        this.textMode = this.add("Text Mode", "textMode.gif");
        this.layoutMode = this.add("Layout Mode", "layoutMode.gif");
        this.textMode.setBehaviour(2);
        this.layoutMode.setBehaviour(2);
        this.setEditMode("Text");
    }

    private void newGroup(GUIPanel gUIPanel) {
        this.panel = new GUIPanel();
        this.panel.setLayout(new FlowLayout(0, 0, 1));
        gUIPanel.add(this.panel);
    }

    private GUIButton add(String string, String string2) {
        GUIButton gUIButton = new GUIButton(this.iconSize);
        gUIButton.setImage(this.getClass(), "icons", string2);
        gUIButton.setName(string);
        gUIButton.addActionListener(this);
        gUIButton.setTipText(string);
        this.panel.add(gUIButton);
        return gUIButton;
    }

    private GUIChoice createPageListChoice() {
        this.pageList = new GUIChoice(new Dimension(80, this.iconSize.height));
        this.pageList.addActionListener(this);
        this.pageList.setTipText("Select a Page");
        this.setPageNumbers(1);
        this.pageList.select("1", false);
        return this.pageList;
    }

    private void setPageNumbers(int n) {
        String string = "";
        int n2 = 1;
        while (n2 <= n) {
            string = String.valueOf(string) + n2 + ",";
            ++n2;
        }
        this.pageList.setChoices(string);
    }

    private GUIChoice createViewScaleChoice() {
        this.viewScale = new GUIChoice(new Dimension(100, this.iconSize.height));
        this.viewScale.setChoices("200 %, 175 %, 150 %, 125 %, 100 %, 75 %, 50 %, 25 %, Fit to Window");
        this.viewScale.addActionListener(this);
        this.viewScale.setTipText("Select a Viewing Scale");
        return this.viewScale;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Accessible accessible;
        String string = null;
        Object object = actionEvent.getSource();
        if (object instanceof GUIButton) {
            accessible = (GUIButton)object;
            string = accessible.getName();
        }
        if (object == this.pageList) {
            string = "Page Selected";
        }
        if (object == this.viewScale) {
            string = this.viewScale.getText();
        }
        if (object == this.textMode) {
            this.layoutMode.deSelect(true);
        }
        if (object == this.layoutMode) {
            this.textMode.deSelect(true);
        }
        if (string != null) {
            accessible = new MenuItem(string);
            ActionEvent actionEvent2 = new ActionEvent(accessible, 0, string);
            this.listener.actionPerformed(actionEvent2);
        }
    }

    public void setViewScale(String string) {
        this.viewScale.select(string, true);
    }

    public void setEditMode(String string) {
        if (string.indexOf("Layout") >= 0) {
            this.textMode.deSelect(true);
            this.layoutMode.select(true);
            return;
        }
        this.textMode.select(true);
        this.layoutMode.deSelect(true);
    }

    public boolean isEditMode() {
        return !this.textMode.isSelected();
    }

    public void setPageNumber(int n) {
        this.pageList.select(String.valueOf(n), true);
    }

    public void setTotalPages(int n) {
        this.setPageNumbers(n);
        this.setPageNumber(n);
    }

    public int getPageNumber() {
        String string = this.pageList.getText();
        try {
            int n = new Integer(string);
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }
}

