/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIAlertBox;
import emsl.awt.GUIPopUpManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class GUIFrame
extends Frame
implements ActionListener {
    private Object windowManager;
    private boolean isStandAlone;
    private boolean isUnsavedChanges;
    private KeyListener mainTextBook;
    private KeyListener focusTextPanel;

    public GUIFrame() {
        super("Java Application");
        this.setStandAlone(false);
        this.setUnsavedChanges(false);
        ((Component)this).setSize(new Dimension(650, 500));
        ((Component)this).setLocation(100, 100);
        ((Component)this).setBackground(new Color(150, 150, 255));
        this.enableEvents(64L);
        new GUIPopUpManager(this);
        this.setMainTextBook(null);
        this.setFocusTextPanel(null);
    }

    public void setWindowManager(Object object) {
        this.windowManager = object;
    }

    public Object getWindowManager() {
        return this.windowManager;
    }

    public void setMainTextBook(KeyListener keyListener) {
        this.mainTextBook = keyListener;
    }

    public KeyListener getMainTextBook() {
        return this.mainTextBook;
    }

    public void setFocusTextPanel(KeyListener keyListener) {
        if (keyListener == this.focusTextPanel) {
            return;
        }
        if (this.focusTextPanel instanceof FocusListener) {
            ((FocusListener)((Object)this.focusTextPanel)).focusLost(null);
        }
        this.focusTextPanel = keyListener;
    }

    public KeyListener getFocusTextPanel() {
        return this.focusTextPanel;
    }

    public void setStandAlone(boolean bl) {
        this.isStandAlone = bl;
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public void setUnsavedChanges(boolean bl) {
        this.isUnsavedChanges = bl;
    }

    public boolean isUnsavedChanges() {
        return this.isUnsavedChanges;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.quit();
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean quit() {
        if (!this.checkAndConfirmLoss("Quit")) {
            return false;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.isStandAlone()) {
            System.exit(0);
        }
        return true;
    }

    public boolean checkAndConfirmLoss(String string) {
        boolean bl;
        return !this.isUnsavedChanges() || (bl = this.confirmLoss(string));
    }

    public boolean confirmLoss(String string) {
        GUIAlertBox gUIAlertBox = new GUIAlertBox((Frame)this, "Confirm : " + string);
        gUIAlertBox.addExitButtons(string, "Cancel");
        gUIAlertBox.addText("Changes have been made to this document that");
        gUIAlertBox.addText("will be lost if you continue the option : " + string);
        gUIAlertBox.addText("");
        gUIAlertBox.addText("Please confirm your choice : " + string + "...");
        gUIAlertBox.display();
        gUIAlertBox.dispose();
        String string2 = gUIAlertBox.getExitButton();
        return !string2.equals("Cancel");
    }

    public static void main(String[] stringArray) {
        GUIFrame gUIFrame = new GUIFrame();
        ((Component)gUIFrame).setVisible(true);
        gUIFrame.setStandAlone(true);
    }
}

