/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

public class GUIMenuBar
extends MenuBar
implements ActionListener,
ItemListener {
    private ActionListener listener;
    private Hashtable menuList;

    public GUIMenuBar(ActionListener actionListener) {
        this.listener = actionListener;
        if (actionListener == null) {
            actionListener = this;
        }
        this.menuList = new Hashtable();
    }

    public Menu createMenu(String string) {
        Menu menu = new Menu(string);
        this.menuList.put(string, menu);
        return menu;
    }

    public void addMenu(Menu menu) {
        this.add(menu);
    }

    public Menu addMenu(String string) {
        Menu menu = this.createMenu(string);
        this.addMenu(menu);
        return menu;
    }

    public Menu addHelpMenu() {
        Menu menu = this.createMenu("Help");
        this.setHelpMenu(menu);
        return menu;
    }

    public void addSubMenu(Menu menu, Menu menu2) {
        menu.add(menu2);
    }

    public void addCheckMenuItem(Menu menu, String string, boolean bl) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        if (this.listener != null) {
            checkboxMenuItem.addItemListener(this);
        }
        menu.add(checkboxMenuItem);
        checkboxMenuItem.setState(bl);
    }

    public void addCheckMenuItem(Menu menu, String string) {
        this.addCheckMenuItem(menu, string, false);
    }

    public void setChecked(String string, String string2, boolean bl) {
        if (bl) {
            this.setMenuItemState(string, string2, 0, 1);
            return;
        }
        this.setMenuItemState(string, string2, 0, 2);
    }

    public void setChecked(String string, boolean bl) {
        if (bl) {
            this.setMenuItemState(string, "**AllEntries**", 0, 1);
            return;
        }
        this.setMenuItemState(string, "**AllEntries**", 0, 2);
    }

    public boolean getChecked(String string, String string2) {
        MenuItem menuItem = this.getMenuItem(string, string2);
        if (menuItem != null && menuItem instanceof CheckboxMenuItem) {
            return ((CheckboxMenuItem)menuItem).getState();
        }
        return false;
    }

    public MenuItem addMenuItem(Menu menu, String string, int n) {
        MenuItem menuItem = new MenuItem(string);
        if (this.listener != null) {
            menuItem.addActionListener(this.listener);
        }
        if (n != 0) {
            MenuShortcut menuShortcut = new MenuShortcut(n);
            menuItem.setShortcut(menuShortcut);
        }
        if (menu != null) {
            menu.add(menuItem);
        }
        return menuItem;
    }

    public void setEnabled(String string, String string2, boolean bl) {
        if (bl) {
            this.setMenuItemState(string, string2, 1, 0);
            return;
        }
        this.setMenuItemState(string, string2, 2, 0);
    }

    public void setEnabled(String string, boolean bl) {
        if (bl) {
            this.setMenuItemState(string, "**AllEntries**", 1, 0);
            return;
        }
        this.setMenuItemState(string, "**AllEntries**", 2, 0);
    }

    public boolean getEnabled(String string, String string2) {
        MenuItem menuItem = this.getMenuItem(string, string2);
        if (menuItem != null) {
            return menuItem.isEnabled();
        }
        return false;
    }

    public void addSeparator(Menu menu) {
        this.addMenuItem(menu, "-", 0);
    }

    private void setMenuItemState(String string, String string2, int n, int n2) {
        Menu menu = (Menu)this.menuList.get(string);
        if (menu == null) {
            return;
        }
        int n3 = 0;
        while (n3 < menu.getItemCount()) {
            MenuItem menuItem = menu.getItem(n3);
            String string3 = menuItem.getLabel();
            if (!string3.equals("-")) {
                if (string2.equals("**AllEntries**")) {
                    string3 = string2;
                }
                if (string2.equals(string3)) {
                    try {
                        if (n == 1) {
                            menuItem.setEnabled(true);
                        }
                        if (n == 2) {
                            menuItem.setEnabled(false);
                        }
                        if (n2 == 1) {
                            ((CheckboxMenuItem)menuItem).setState(true);
                        }
                        if (n2 == 2) {
                            ((CheckboxMenuItem)menuItem).setState(false);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++n3;
        }
    }

    public Menu getMenu(String string) {
        return (Menu)this.menuList.get(string);
    }

    public MenuItem getMenuItem(String string, String string2) {
        Menu menu = this.getMenu(string);
        if (menu == null) {
            return null;
        }
        int n = 0;
        while (n < menu.getItemCount()) {
            MenuItem menuItem = menu.getItem(n);
            if (string2.equals(menuItem.getLabel())) {
                return menuItem;
            }
            ++n;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof CheckboxMenuItem) {
            ActionEvent actionEvent = new ActionEvent(object, 0, "menuSelected");
            this.listener.actionPerformed(actionEvent);
        }
    }
}

