/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GUIPanel
extends Panel
implements KeyListener {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int OUTLINED = 3;
    public static final int THIN = 1;
    public static final int THICK = 2;
    public static final int MAXSIZE = -1;
    public static final int MINSIZE = -2;
    private int border = 0;
    private int thickness = 2;
    private Dimension preferredSize = null;
    private String label = null;
    private transient Frame topLevelFrame;
    private transient int dpi;

    public GUIPanel() {
        this.addKeyListener(this);
        this.topLevelFrame = null;
    }

    public GUIPanel(int n) {
        this();
        this.setBorder(n);
    }

    public GUIPanel(Dimension dimension) {
        this();
        this.setSize(dimension);
    }

    public GUIPanel(Dimension dimension, int n) {
        this();
        this.setBorder(n);
        this.setSize(dimension);
    }

    public void setSize(Dimension dimension) {
        this.preferredSize = new Dimension(dimension.width, dimension.height);
        if (this.getSize().width != dimension.width || this.getSize().height != dimension.height) {
            super.setSize(dimension);
        }
    }

    public Frame getParentFrame() {
        if (this.topLevelFrame != null) {
            return this.topLevelFrame;
        }
        Container container = this;
        do {
            if (!((container = container.getParent()) instanceof Frame)) continue;
            this.topLevelFrame = (Frame)container;
            return this.topLevelFrame;
        } while (container != null);
        this.topLevelFrame = null;
        return null;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorderThickness(int n) {
        this.thickness = n;
    }

    public int getBorderThickness() {
        return this.thickness;
    }

    public void setText(String string) {
        this.label = string;
    }

    public Rectangle getDrawableSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        if (this.label != null) {
            insets.top -= 9;
        }
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        return rectangle;
    }

    public Insets getInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.border == 3) {
            insets = new Insets(1, 1, 1, 1);
        }
        if (this.border == 1) {
            insets = new Insets(2, 2, 3, 3);
        }
        if (this.border == 1 && this.thickness == 1) {
            insets = new Insets(1, 1, 0, 0);
        }
        if (this.border == 2) {
            insets = new Insets(3, 3, 2, 2);
        }
        if (this.border == 2 && this.thickness == 1) {
            insets = new Insets(1, 1, 0, 0);
        }
        if (this.label != null) {
            insets.top += 15;
        }
        return insets;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            return super.getPreferredSize();
        }
        Dimension dimension = new Dimension(this.preferredSize);
        if (this.preferredSize.width == -1) {
            dimension.width = this.getParent().getSize().width - 20;
        }
        if (this.preferredSize.width == -2) {
            dimension.width = super.getPreferredSize().width;
        }
        if (this.preferredSize.height == -1) {
            dimension.height = this.getParent().getSize().height - 20;
        }
        if (this.preferredSize.height == -2) {
            dimension.height = super.getPreferredSize().height;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        super.paint(graphics);
    }

    public void paintBackground(Graphics graphics) {
        Rectangle rectangle = this.getDrawableSize();
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        if (this.label != null) {
            graphics.setFont(new Font("Dialog", 0, 10));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.getAscent() / 2;
            n2 = fontMetrics.stringWidth(this.label);
        }
        if (this.border == 0 || this.border == 3) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.border == 3) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, n, dimension.width - 1, dimension.height - 1 - n);
        }
        if (this.border == 1 || this.border == 2) {
            boolean bl = true;
            if (this.border == 2) {
                bl = false;
            }
            if (this.thickness != 1) {
                graphics.setColor(Color.lightGray);
                graphics.fill3DRect(0, n, dimension.width, dimension.height - n, bl);
            }
            graphics.setColor(this.getBackground());
            if (this.getBackground() == null) {
                graphics.setColor(Color.lightGray);
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.thickness == 1 && !bl) {
                graphics.setColor(Color.black);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(Color.white);
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3);
            }
        }
        if (this.label != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x + 2, 0, n2 + 4, 2 + n * 2);
            graphics.setColor(Color.black);
            graphics.drawString(this.label, rectangle.x + 4, n * 2);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
        Component[] componentArray = this.getComponents();
        try {
            int n = componentArray.length - 1;
            while (n >= 0) {
                Component component = componentArray[n];
                Rectangle rectangle = component.getBounds();
                Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (component.isVisible()) {
                    component.printAll(graphics2);
                }
                --n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public int getDPI() {
        if (this.dpi <= 0) {
            this.dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            String string = System.getProperty("os.name");
            if (string.startsWith("Windows")) {
                this.dpi = 72;
            }
        }
        return this.dpi;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Frame frame = this.getParentFrame();
        if (frame == null) {
            return;
        }
        if (!(frame instanceof GUIFrame)) {
            return;
        }
        GUIFrame gUIFrame = (GUIFrame)frame;
        KeyListener keyListener = gUIFrame.getFocusTextPanel();
        if (keyListener == null) {
            return;
        }
        keyListener.keyPressed(keyEvent);
    }
}

