/*
 * Decompiled with CFR 0.152.
 */
package emsl.beans;

import emsl.awt.GUIProgressBox;
import emsl.beans.BeanClassLoader;
import emsl.beans.BeanObjectInputStream;
import emsl.protocol.internal.InternalConnection;
import java.awt.Container;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BeanLoader {
    private BeanClassLoader beanClassLoader = new BeanClassLoader(this, this.beanBasePath);
    private Container parent;
    private int totalFilesToRead;
    private String beanBasePath = "Beans";
    private boolean debug;
    private GUIProgressBox progressBox;
    private Hashtable jarLowerCaseEntries;
    private Hashtable localBeanHashtable;

    public BeanLoader() {
        Beans.setDesignTime(true);
        Beans.setGuiAvailable(true);
        Properties properties = new Properties(System.getProperties());
        String string = properties.getProperty("java.protocol.handler.pkgs");
        ((Hashtable)properties).put("java.protocol.handler.pkgs", String.valueOf(string) + "|emsl.protocol");
        System.setProperties(properties);
        InternalConnection.setClassLoader(this.beanClassLoader);
        this.debug = false;
    }

    public BeanClassLoader getClassLoader() {
        return this.beanClassLoader;
    }

    public void setLocalBeanHashtable(Hashtable hashtable) {
        this.localBeanHashtable = hashtable;
    }

    public Hashtable getBeanHashtable() {
        Hashtable hashtable = this.beanClassLoader.getBeanList();
        if (this.localBeanHashtable != null) {
            Enumeration enumeration = this.localBeanHashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Class clazz = (Class)this.localBeanHashtable.get(string);
                if (string == null || clazz == null) continue;
                hashtable.put(string, clazz);
            }
        }
        return hashtable;
    }

    public Vector getBeanVector() {
        Hashtable hashtable = this.getBeanHashtable();
        Enumeration enumeration = hashtable.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return this.sortBeanList(vector);
    }

    private Vector sortBeanList(Vector vector) {
        boolean bl = true;
        do {
            try {
                bl = true;
                int n = 0;
                while (n < vector.size() - 1) {
                    String string = (String)vector.elementAt(n);
                    String string2 = (String)vector.elementAt(n + 1);
                    if (string2.compareTo(string) < 0) {
                        vector.setElementAt(string2, n);
                        vector.setElementAt(string, n + 1);
                        bl = false;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
        } while (!bl);
        return vector;
    }

    public void loadBeans(Container container) {
        this.parent = container;
        File file = new File(this.beanBasePath);
        this.progressBox = new GUIProgressBox(container, 0);
        this.progressBox.display();
        this.progressBox.setProgress(0, "Reading JAVA Applets and Beans...");
        this.totalFilesToRead = 0;
        this.findClasses(file, "Count");
        this.progressBox.setTotalIncrements(this.totalFilesToRead + 1);
        this.findClasses(file, "File");
        this.findClasses(file, "Manifest");
        this.progressBox.setProgress("Getting Bean Information...");
        this.progressBox.setProgress("Initializing Application...");
    }

    public void disposeProgressBox() {
        if (this.progressBox != null) {
            this.progressBox.dispose();
            this.progressBox = null;
        }
    }

    private void findClasses(File file, String string) {
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isFile()) {
                    ++this.totalFilesToRead;
                    if (file2.getName().toLowerCase().endsWith("jar")) {
                        this.totalFilesToRead += 4;
                    }
                    boolean bl = false;
                    if (string.equals("File")) {
                        bl = true;
                    }
                    if (string.equals("Manifest") && file2.getName().toLowerCase().endsWith("manifest.mf")) {
                        bl = true;
                    }
                    if (bl) {
                        this.findASingleClass(file2);
                    }
                }
                if (file2.isDirectory()) {
                    this.findClasses(file2, string);
                }
                ++n;
            }
        }
    }

    private void findASingleClass(File file) {
        String string = file.getParent();
        String string2 = file.getName();
        String string3 = string2.toLowerCase();
        if (this.progressBox != null) {
            this.progressBox.setProgress("Reading : " + file.getPath());
        }
        if (string3.endsWith(".class")) {
            this.readClassFile(string, string2);
            return;
        }
        if (string3.endsWith(".jar")) {
            this.readJarFile(string, string2);
            return;
        }
        if (string3.endsWith("manifest.mf")) {
            this.readManifestFile(string, string2);
            return;
        }
        this.beanClassLoader.setLocalResource(string2, string, this.readResourceFile(file));
        if (string3.endsWith(".ser")) {
            this.beanClassLoader.setBeanList(string2);
        }
    }

    private void readClassFile(String string, String string2) {
        try {
            this.beanClassLoader.setClassPath(string);
            string2 = string2.substring(0, string2.lastIndexOf(46));
            this.beanClassLoader.loadClass(string2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public byte[] readResourceFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void readJarFile(String string, String string2) {
        String string3;
        String string4;
        String string5 = String.valueOf(string) + File.separator + string2;
        if (this.progressBox != null) {
            this.progressBox.setProgress("Reading Archive : " + string5);
        }
        this.jarLowerCaseEntries = new Hashtable();
        Hashtable hashtable = this.extractJarFile(string, string2);
        if (hashtable == null) {
            return;
        }
        if (this.progressBox != null) {
            this.progressBox.setProgress("Extracting Files : " + string5);
        }
        this.beanClassLoader.addJarFileEntries(hashtable, string);
        if (this.progressBox != null) {
            this.progressBox.setProgress("Extracting Resources : " + string5);
        }
        Enumeration enumeration = this.jarLowerCaseEntries.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (!string4.endsWith(".class")) continue;
            string3 = (String)this.jarLowerCaseEntries.get(string4);
            this.readClassFile(string, string3);
        }
        if (this.progressBox != null) {
            this.progressBox.setProgress("Extracting Manifest : " + string5);
        }
        enumeration = this.jarLowerCaseEntries.keys();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (!string4.endsWith("manifest.mf")) continue;
            string3 = (String)this.jarLowerCaseEntries.get(string4);
            byte[] byArray = (byte[])hashtable.get(string3);
            this.readManifestFile(byArray);
        }
    }

    private void readManifestFile(String string, String string2) {
        try {
            File file = new File(string, string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            this.readManifestFile(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void readManifestFile(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        String string = null;
        do {
            try {
                string = lineNumberReader.readLine();
                String string2 = "";
                String string3 = string.substring(0, 5).toLowerCase();
                if (!string3.equals("name:")) continue;
                string2 = string.substring(5);
                string2 = string2.trim();
                string = lineNumberReader.readLine();
                boolean bl = false;
                if (string.toLowerCase().startsWith("java-bean") && string.toLowerCase().indexOf("true") > 0) {
                    bl = true;
                }
                if (string2.equals("")) {
                    bl = false;
                }
                if (!bl) continue;
                this.beanClassLoader.setBeanList(string2);
            }
            catch (Exception exception) {}
        } while (string != null);
    }

    private Hashtable extractJarFile(String string, String string2) {
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(string, string2));
        }
        catch (Exception exception) {
            System.out.println("Error opening Jar file");
            System.out.println(String.valueOf(exception.toString()));
            return null;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = null;
        while (enumeration.hasMoreElements()) {
            try {
                zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[2048];
                int n = 0;
                do {
                    if ((n = inputStream.read(byArray, 0, byArray.length)) <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n);
                } while (n > 0);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                String string3 = new String(zipEntry.getName().replace('\\', '.'));
                string3 = string3.replace('/', '.');
                string3 = string3.replace(':', '.');
                this.jarLowerCaseEntries.put(string3.toLowerCase(), string3);
                hashtable.put(string3, byArray2);
            }
            catch (Exception exception) {
                System.out.println("Zip Error in file : " + zipEntry.getName());
                System.out.println("Error : " + exception.toString());
            }
        }
        return hashtable;
    }

    public void printBeanList(Vector vector) {
        if (vector == null) {
            return;
        }
        System.out.println("Beans and Applet Classes loaded from disk...");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("   " + string);
        }
        System.out.println("");
    }

    public Object getInstanceOf(String string) {
        Hashtable hashtable = this.getBeanHashtable();
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v instanceof Class) {
            return this.getInstanceOfClass(string, (Class)v);
        }
        if (v instanceof String) {
            return this.getInstanceOfSerialized(string);
        }
        System.out.println("A beanList entry gave an erronous entry");
        System.out.println("ClassName : " + string + "   Entry : " + v);
        return null;
    }

    private Object getInstanceOfClass(String string, Class clazz) {
        if (this.debug) {
            System.out.println("Instancing a new bean from a Class file :" + string);
        }
        try {
            Object t = clazz.newInstance();
            return t;
        }
        catch (Exception exception) {
            System.out.println("An error occurred trying to make a new Bean");
            System.out.println(String.valueOf(exception.toString()));
            return null;
        }
    }

    private Object getInstanceOfSerialized(String string) {
        InputStream inputStream;
        if (this.debug) {
            System.out.println("Instancing a new bean from a Serialized file :" + string);
        }
        if ((inputStream = this.beanClassLoader.getResourceAsStream(String.valueOf(string) + ".ser")) == null) {
            System.out.println("Resource not found");
            return null;
        }
        try {
            BeanObjectInputStream beanObjectInputStream = new BeanObjectInputStream(this.beanClassLoader, inputStream);
            Object object = beanObjectInputStream.readObject();
            return object;
        }
        catch (Exception exception) {
            System.out.println("An error occurred trying to deserialize a Bean");
            System.out.println(String.valueOf(exception.toString()));
            return null;
        }
    }
}

