/*
 * Decompiled with CFR 0.152.
 */
package emsl.feedback;

import emsl.awt.GUIAlertBox;
import emsl.awt.GUIButton;
import emsl.awt.GUIFrame;
import emsl.awt.GUIProgressBox;
import emsl.feedback.Email;
import emsl.feedback.GUI;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Feedback
extends GUIFrame
implements ActionListener {
    private String mailServer;
    private String mailRecipient;
    private String softwareName;
    private String softwareVersion;
    private GUI gui;
    private GUIProgressBox progressBox;
    private Email email = null;

    public Feedback() {
        this.setTitle("Feedback Application");
        this.setLayout(new BorderLayout());
        this.setMailServer("pnl.gov");
        this.setMailRecipient("unknown@pnl.gov");
        this.setSoftwareName("Unknown");
        this.setSoftwareVersion("Unknown");
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.gui != null) {
                this.remove(this.gui);
            }
            this.gui = new GUI(this, this.softwareName, this.softwareVersion, this.mailRecipient, this.mailServer);
            this.add("Center", this.gui);
        }
        super.setVisible(bl);
    }

    public void setMailServer(String string) {
        this.mailServer = string;
    }

    public void setMailRecipient(String string) {
        this.mailRecipient = string;
    }

    public void setSoftwareName(String string) {
        this.softwareName = string;
    }

    public void setSoftwareVersion(String string) {
        this.softwareVersion = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof Email) {
            if (actionEvent.getID() == 0) {
                this.progressBox.setProgress(string);
            }
            if (actionEvent.getID() == 1) {
                GUIAlertBox gUIAlertBox = new GUIAlertBox((Frame)this, "Email Error");
                gUIAlertBox.addExitButtons("OK");
                gUIAlertBox.addText("An error occured trying to send the email message...");
                gUIAlertBox.addText("Mail Server : " + this.mailServer);
                gUIAlertBox.addText("Recipient : " + this.mailRecipient);
                gUIAlertBox.addText("Error : " + string);
                gUIAlertBox.addText("");
                gUIAlertBox.addText("This mail has Not been sent");
                gUIAlertBox.display();
                gUIAlertBox.dispose();
            }
        }
        if (object instanceof GUIButton) {
            if (string.equals("Reset")) {
                this.gui.reset();
            }
            if (string.equals("Send")) {
                this.sendEmail();
            }
            if (string.equals("Close")) {
                this.quit();
            }
        }
    }

    private void sendEmail() {
        this.progressBox = new GUIProgressBox(this);
        this.progressBox.setTotalIncrements(20);
        this.progressBox.display();
        this.progressBox.setProgress("Preparing email...");
        boolean bl = false;
        try {
            this.email = new Email();
            this.email.setMailServer(this.gui.getServer());
            this.email.setMailTo(this.mailRecipient);
            this.email.setMailFrom(this.gui.getSender());
            this.email.setMailSubject(this.gui.getSubject());
            this.email.setMailMessage(this.gui.getMessage());
            this.email.setActionListener(this);
            bl = this.email.sendMail();
        }
        catch (Exception exception) {}
        this.progressBox.dispose();
        if (bl) {
            GUIAlertBox gUIAlertBox = new GUIAlertBox((Frame)this, "Feedback Sent");
            gUIAlertBox.addExitButtons("OK");
            gUIAlertBox.addText("The message has been sent !");
            gUIAlertBox.addText("");
            gUIAlertBox.addText("Thank you for the feedback");
            gUIAlertBox.display();
            gUIAlertBox.dispose();
        }
        this.email = null;
    }

    public boolean quit() {
        if (this.email != null) {
            return false;
        }
        return super.quit();
    }

    public static void main(String[] stringArray) {
        Feedback feedback = new Feedback();
        feedback.setVisible(true);
        feedback.setStandAlone(true);
    }
}

