/*
 * Decompiled with CFR 0.152.
 */
package emsl.feedback;

import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIIcon;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUITextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GUI
extends Panel {
    private String softwareName;
    private String softwareVersion;
    private String softwareEmail;
    private String mailServer;
    private ActionListener listener;
    private GUITextField addressField;
    private GUITextField mailServerField;
    private GUITextField softwareVer;
    private GUITextField javaVersion;
    private GUITextField javaVendor;
    private GUITextField osName;
    private GUITextField osArch;
    private GUITextField osVersion;
    private TextArea mainTextArea;
    private GUIChoice subject;

    public GUI(ActionListener actionListener, String string, String string2, String string3, String string4) {
        this.listener = actionListener;
        this.softwareName = string;
        this.softwareVersion = string2;
        this.softwareEmail = string3;
        this.mailServer = string4;
        this.setLayout(new BorderLayout(10, 10));
        this.add("North", this.createWelcomePanel());
        this.add("Center", this.createMainPanel());
        this.add("South", this.createActionPanel());
        this.reset();
    }

    private Panel createWelcomePanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(50, 50);
        GUIIcon gUIIcon = new GUIIcon(dimension, this.getClass(), "", "emslring.gif");
        panel.add("West", gUIIcon);
        gUIIcon = new GUIIcon(dimension, "");
        panel.add("East", gUIIcon);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel.add("Center", panel2);
        GUIPanel gUIPanel = new GUIPanel(new Dimension(10, 20));
        panel.add("South", gUIPanel);
        GUIIcon gUIIcon2 = new GUIIcon(String.valueOf(this.softwareName) + " - Feedback Form");
        gUIIcon2.setFont(new Font("SansSerif", 2, 18));
        panel2.add("Center", gUIIcon2);
        gUIIcon2 = new GUIIcon("( Sends a message to : " + this.softwareEmail + " )");
        gUIIcon2.setFont(new Font("SansSerif", 0, 12));
        panel2.add("South", gUIIcon2);
        return panel;
    }

    private Panel createActionPanel() {
        Panel panel = new Panel();
        Dimension dimension = new Dimension(120, 30);
        GUIButton gUIButton = new GUIButton(dimension, "Send");
        gUIButton.addActionListener(this.listener);
        gUIButton.setTipText("Send Feedback Message");
        panel.add(gUIButton);
        gUIButton = new GUIButton(dimension, "Reset");
        gUIButton.addActionListener(this.listener);
        gUIButton.setTipText("Clear All Text and Reset Form");
        panel.add(gUIButton);
        gUIButton = new GUIButton(dimension, "Close");
        gUIButton.addActionListener(this.listener);
        gUIButton.setTipText("Close the Feedback Application");
        panel.add(gUIButton);
        return panel;
    }

    private Panel createMainPanel() {
        GUIPanel gUIPanel = new GUIPanel();
        gUIPanel.setLayout(new BorderLayout(10, 10));
        gUIPanel.add("North", this.createOptions());
        this.mainTextArea = new TextArea();
        gUIPanel.add("Center", this.mainTextArea);
        gUIPanel.add("South", this.createStatistics());
        return gUIPanel;
    }

    private Panel createStatistics() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 2, 0, 0));
        this.softwareVer = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.softwareVer, String.valueOf(this.softwareName) + " "));
        this.javaVersion = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.javaVersion, "Java Version "));
        this.javaVendor = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.javaVendor, "Java Vendor "));
        this.osName = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.osName, "OS Name "));
        this.osArch = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.osArch, "OS Architecture "));
        this.osVersion = new GUITextField(0, 20);
        panel.add(this.createStatistic(this.osVersion, "OS Version "));
        return panel;
    }

    private Panel createStatistic(GUITextField gUITextField, String string) {
        GUILabelPanel gUILabelPanel = new GUILabelPanel((Component)gUITextField, string, 100);
        gUILabelPanel.setTextAlignment(2);
        gUILabelPanel.setBehaviour(3);
        return gUILabelPanel;
    }

    private Panel createOptions() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 0, 5, 5));
        String string = "Bug Report (Non-Fatal), Bug Report (Fatal)";
        string = String.valueOf(string) + ",Suggestion, Request, Other (Please Specify)";
        this.subject = new GUIChoice(new Dimension(200, 30), string, ",");
        GUILabelPanel gUILabelPanel = new GUILabelPanel(this.subject, "Subject ");
        panel.add(gUILabelPanel);
        this.addressField = new GUITextField(0, 50);
        gUILabelPanel = new GUILabelPanel(this.addressField, "From ");
        panel.add(gUILabelPanel);
        this.mailServerField = new GUITextField(0, 50);
        gUILabelPanel = new GUILabelPanel(this.mailServerField, "Mail Server ");
        panel.add(gUILabelPanel);
        return panel;
    }

    public void reset() {
        String string = System.getProperty("user.name");
        String string2 = "";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
            int n = string2.lastIndexOf(46) - 1;
            int n2 = string2.lastIndexOf(46, n);
            if (n2 > 0) {
                this.mailServer = string2.substring(n2 + 1);
            }
        }
        catch (UnknownHostException unknownHostException) {}
        String string3 = String.valueOf(string) + "@" + string2;
        this.addressField.setText(string3);
        this.mailServerField.setText(this.mailServer);
        this.javaVersion.setText(System.getProperty("java.version"));
        this.javaVendor.setText(System.getProperty("java.vendor"));
        this.osName.setText(System.getProperty("os.name"));
        this.osArch.setText(System.getProperty("os.arch"));
        this.osVersion.setText(System.getProperty("os.version"));
        this.softwareVer.setText(this.softwareVersion);
        this.mainTextArea.setText("");
    }

    public String getSender() {
        return this.addressField.getText();
    }

    public String getServer() {
        return this.mailServerField.getText();
    }

    public String getSubject() {
        return String.valueOf(this.softwareName) + " ... " + this.subject.getText();
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Subject: " + this.subject.getText() + "\n\n");
        stringBuffer.append("From: " + this.getSender() + "\n\n");
        stringBuffer.append(String.valueOf(this.softwareName) + ": " + this.softwareVer.getText() + "\n");
        stringBuffer.append("Java Version: " + this.javaVersion.getText() + "\n");
        stringBuffer.append("Java Vendor: " + this.javaVendor.getText() + "\n");
        stringBuffer.append("OS Name: " + this.osName.getText() + "\n");
        stringBuffer.append("OS Architecture: " + this.osArch.getText() + "\n");
        stringBuffer.append("OS Version: " + this.osVersion.getText() + "\n");
        stringBuffer.append("\n\n" + this.mainTextArea.getText() + "\n\n");
        stringBuffer.append("\n---Message Ends\n");
        return stringBuffer.toString();
    }
}

