/*
 * Decompiled with CFR 0.152.
 */
package emsl.inch;

import emsl.inch.ComponentObjectInputStream;
import emsl.inch.InchPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ComponentPanel
extends InchPanel
implements ComponentListener,
Serializable {
    private transient Component component;

    public ComponentPanel() {
        this.setComponent(null);
        this.addComponentListener(this);
        this.setCursor(new Cursor(0));
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponentText(String string) {
        Label label = new Label(string);
        this.setComponentObject(label);
    }

    public void setComponent(Component component) {
        if (component == null) {
            this.setComponentText("No Bean");
            return;
        }
        this.setComponentObject(component);
    }

    private void setComponentObject(Component component) {
        if (this.getComponent() != null) {
            this.remove(this.getComponent());
        }
        this.component = component;
        this.add("Center", this.component);
        this.component.setCursor(new Cursor(0));
        this.resizeComponent();
    }

    public boolean isComponentVisible() {
        if (this.component == null) {
            return false;
        }
        return this.component.isVisible();
    }

    public void setComponentVisibility(boolean bl) {
        if (this.component != null) {
            this.component.setVisible(bl);
        }
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        Component component = this.getComponent();
        if (component != null) {
            boolean bl = false;
            if (color2 == null) {
                bl = true;
            } else if (color2.equals(component.getBackground())) {
                bl = true;
            }
            if (bl) {
                component.setBackground(color);
            }
        }
        super.setBackground(color);
    }

    public String[] getEditOptions() {
        return null;
    }

    public void setEditOption(String string) {
    }

    private void resizeComponent() {
        if (this.component == null) {
            return;
        }
        Rectangle rectangle = this.getScaledPixelBounds();
        Rectangle rectangle2 = new Rectangle(this.getBorderSize(), this.getBorderSize(), 0, 0);
        rectangle2.width = rectangle.width - this.getBorderSize() - this.getBorderSize();
        rectangle2.height = rectangle.height - this.getBorderSize() - this.getBorderSize();
        this.component.setBounds(rectangle2);
    }

    private int getBorderSize() {
        if (this.getBorder() == 0) {
            return 1;
        }
        if (this.getBorder() == 3) {
            return 2;
        }
        return 4;
    }

    public void setBorder(int n) {
        super.setBorder(n);
        this.resizeComponent();
    }

    public void validate() {
        super.validate();
        this.resizeComponent();
    }

    public void doLayout() {
        super.doLayout();
        this.resizeComponent();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeComponent();
    }

    public byte[] serializeComponent(Component component) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(component);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("Error serializing component :");
            System.out.println(exception.toString());
            return null;
        }
    }

    public Component deSerializeComponent(ClassLoader classLoader, byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ComponentObjectInputStream componentObjectInputStream = new ComponentObjectInputStream(classLoader, byteArrayInputStream);
            Component component = (Component)componentObjectInputStream.readObject();
            return component;
        }
        catch (Exception exception) {
            System.out.println("Error deSerializing component using ClassLoader " + classLoader);
            System.out.println(exception.toString());
            return null;
        }
    }

    public Component getComponentClone() {
        try {
            ClassLoader classLoader = this.getComponent().getClass().getClassLoader();
            byte[] byArray = this.serializeComponent(this.component);
            Component component = this.deSerializeComponent(classLoader, byArray);
            return component;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void copyAttributes(ComponentPanel componentPanel) {
        super.copyAttributes(componentPanel);
        if (this.getComponent() != null) {
            componentPanel.setComponent(this.getComponentClone());
        }
    }

    public Object clone() {
        ComponentPanel componentPanel = new ComponentPanel();
        this.copyAttributes(componentPanel);
        return componentPanel;
    }
}

