/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.awt.GUIProgressBox;
import emsl.text.TextData;
import emsl.text.TextPanel;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class TextBook
extends TextPanel {
    private int pageNumber;
    private int totalPages;
    private Vector pageList;

    public TextBook() {
    }

    public TextBook(TextData textData) {
        super(textData);
    }

    public void setTextData(TextData textData) {
        super.setTextData(textData);
        this.pageList = new Vector();
        this.setTotalPages(1);
        this.setPageNumber(1);
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int n) {
        if (n < 1) {
            n = 1;
        }
        this.totalPages = n;
        if (this.getPageNumber() > n) {
            this.setPageNumber(n);
        }
    }

    public void addPage() {
        this.setTotalPages(this.getTotalPages() + 1);
    }

    public void deletePage() {
        int n = this.getTotalPages() - 1;
        if (n <= 1) {
            n = 1;
        }
        this.setTotalPages(n);
    }

    public void pageUp() {
        if (this.getPageNumber() > 1) {
            this.setPageNumber(this.getPageNumber() - 1);
        } else {
            this.getTextCursor().cursorHome();
        }
        this.sendActionEvent("TextBook Page Change");
    }

    public void pageDown() {
        if (this.getPageNumber() < this.getTotalPages()) {
            this.setPageNumber(this.getPageNumber() + 1);
            this.getTextCursor().cursorHome();
        } else {
            this.getTextCursor().cursorEnd();
        }
        this.sendActionEvent("TextBook Page Change");
    }

    public void pageChange(int n) {
        int n2 = this.getPageNumber(n);
        this.setPageNumber(n2);
        this.sendActionEvent("TextBook Page Change");
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        if (n < 1) {
            return;
        }
        if (n > this.getTotalPages()) {
            return;
        }
        boolean bl = true;
        if (n > this.pageNumber) {
            bl = false;
        }
        this.pageNumber = n;
        int n2 = this.getPageRecord(this.getPageNumber(), true);
        if (n2 != -1) {
            this.getTextSelector().selectionOff();
            this.setTextDataStart(n2);
            this.layoutPage();
            if (!this.getTextCursor().isOnScreen()) {
                if (bl) {
                    this.getTextCursor().cursorEnd();
                    return;
                }
                this.getTextCursor().cursorHome();
            }
        }
    }

    public int getPageNumber(int n) {
        int n2 = 1;
        int n3 = 1;
        boolean bl = false;
        do {
            int n4;
            if ((n4 = this.getPageRecord(n2, true)) <= n) {
                n3 = n2;
            } else {
                bl = true;
            }
            if (++n2 <= this.getTotalPages()) continue;
            bl = true;
        } while (!bl);
        return n3;
    }

    public void reformatAll() {
        int n = this.getPageNumber();
        this.pageList = new Vector();
        this.setPageNumber(n);
    }

    public void setTextDataEnd(int n) {
        int n2 = this.getPageRecord(this.pageNumber + 1, false) - 1;
        super.setTextDataEnd(n);
        if (n2 != this.getTextDataEnd()) {
            this.deletePageRecords(this.getPageNumber() + 1);
            this.setPageRecord(this.getPageNumber() + 1, this.getTextDataEnd() + 1);
        }
    }

    private void setPageRecord(int n, int n2) {
        if (this.pageList.size() <= 0) {
            this.pageList.addElement(new Integer(0));
        }
        try {
            Integer n3 = new Integer(n2);
            if (this.pageList.size() >= n) {
                this.pageList.setElementAt(n3, n - 1);
                return;
            }
            this.pageList.addElement(n3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private int getPageRecord(int n, boolean bl) {
        if (this.pageList.size() <= 0) {
            this.pageList.addElement(new Integer(0));
        }
        try {
            Integer n2 = (Integer)this.pageList.elementAt(n - 1);
            int n3 = n2;
            return n3;
        }
        catch (Exception exception) {
            int n4 = 0;
            if (bl) {
                this.calculatePageRecords(n);
                n4 = this.getPageRecord(n, false);
            }
            return n4;
        }
    }

    private void calculatePageRecords(int n) {
        this.setMouseBusy();
        int n2 = this.pageNumber;
        this.pageNumber = this.pageList.size();
        int n3 = this.getPageRecord(this.pageNumber, false);
        boolean bl = false;
        GUIProgressBox gUIProgressBox = null;
        if (n - this.pageNumber > 2) {
            gUIProgressBox = new GUIProgressBox(this);
            gUIProgressBox.setTotalIncrements(n - this.pageNumber);
            gUIProgressBox.display();
        }
        do {
            if (gUIProgressBox != null) {
                gUIProgressBox.setProgress("Formating Page " + this.pageNumber);
            }
            this.setTextDataStart(n3);
            this.layoutAllText();
            ++this.pageNumber;
            n3 = this.getPageRecord(this.pageNumber, false);
            if (this.pageNumber > n) {
                bl = true;
            }
            if (n3 < this.getTextData().getSize() - 1) continue;
            bl = true;
        } while (!bl);
        if (gUIProgressBox != null) {
            gUIProgressBox.dispose();
        }
        this.setMouseNormal();
        this.pageNumber = n2;
    }

    private void deletePageRecords(int n) {
        if (this.pageList.size() < n) {
            return;
        }
        try {
            int n2 = this.pageList.size();
            while (n2 >= n) {
                this.pageList.removeElementAt(n2 - 1);
                --n2;
            }
            return;
        }
        catch (Exception exception) {
            this.pageList = new Vector();
            this.pageList.addElement(new Integer(0));
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (keyEvent.isAltDown()) {
            return;
        }
        if (keyEvent.isControlDown()) {
            return;
        }
        if (keyEvent.isMetaDown()) {
            return;
        }
        if (keyEvent.getKeyCode() == 34) {
            this.pageDown();
        }
        if (keyEvent.getKeyCode() == 33) {
            this.pageUp();
        }
    }

    public void print() {
        System.out.println("Page List ... Total Pages = " + this.getTotalPages());
        System.out.println("Currently tracked pages = " + this.pageList.size());
        int n = 1;
        while (n <= this.getTotalPages()) {
            System.out.println("Page " + n + " starts at " + this.getPageRecord(n, true));
            ++n;
        }
        System.out.println("");
    }
}

