/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.inch.ComponentPanel;
import emsl.inch.InchPanel;
import emsl.objects.TextStyle;
import emsl.system.UndoGroup;
import emsl.text.TextClipboard;
import emsl.text.TextCursor;
import emsl.text.TextData;
import emsl.text.TextLine;
import emsl.text.TextObject;
import emsl.text.TextSelector;
import emsl.text.TextUndo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class TextPanel
extends InchPanel
implements FocusListener {
    public static final int NONE = 0;
    public static final int SELECTABLE = 1;
    public static final int EDITABLE = 2;
    public static final int TAB_WIDTH = 36;
    private TextData textData;
    private int textDataStart;
    private int textDataEnd;
    private TextCursor textCursor;
    private TextSelector textSelector;
    private TextClipboard textClipboard;
    private TextUndo textUndo;
    private ActionListener actionListener;
    private Vector lineList;
    private int editable;
    private int lineRedrawStart;
    private int lineRedrawEnd;
    private Image offscreenImage;
    private Graphics offscreenGraphics;
    private Dimension offscreenSize;
    private Point mouseClickPt;
    private boolean isFocus;
    private boolean markerVisible;

    public TextPanel() {
        long l = 16L;
        this.enableEvents(l |= 0x20L);
        this.addFocusListener(this);
        this.textSelector = new TextSelector(this);
        this.textClipboard = new TextClipboard(this);
        this.textCursor = new TextCursor(this);
        this.textUndo = new TextUndo(this);
        this.isFocus = false;
        this.lineList = new Vector();
        this.setEditable(2);
        this.setTextData(new TextData());
        this.setMarkerVisible(false);
    }

    public TextPanel(TextData textData) {
        this();
        this.setTextData(textData);
    }

    public void setTextData(TextData textData) {
        this.textData = textData;
        this.setTextDataStart(0);
        this.textSelector.selectionOff();
        this.textCursor.cursorHome();
        this.textUndo.getUndoManager().resetUndo();
        this.removeAll();
    }

    public TextData getTextData() {
        return this.textData;
    }

    public void setTextDataStart(int n) {
        if (n > this.textData.getSize() - 1) {
            n = this.textData.getSize() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.textDataStart = n;
    }

    public int getTextDataStart() {
        return this.textDataStart;
    }

    public int getTextDataEnd() {
        return this.textDataEnd;
    }

    protected void setTextDataEnd(int n) {
        if (n < this.getTextDataStart()) {
            n = this.getTextDataStart();
        }
        this.textDataEnd = n;
    }

    public TextSelector getTextSelector() {
        return this.textSelector;
    }

    public TextCursor getTextCursor() {
        return this.textCursor;
    }

    public TextClipboard getTextClipboard() {
        return this.textClipboard;
    }

    public TextUndo getTextUndo() {
        return this.textUndo;
    }

    public int getEditable() {
        return this.editable;
    }

    public void setEditable(int n) {
        this.editable = n;
        if (this.editable == 0) {
            this.textSelector.selectionOff();
        }
        this.setMouseNormal();
        this.repaint();
        if (!this.isFocus) {
            return;
        }
        this.textCursor.setCursorColor(Color.red);
        if (this.editable == 0 || this.editable == 1) {
            this.textCursor.setCursorColor(null);
        }
    }

    public Vector getLineList() {
        return this.lineList;
    }

    public void setViewScale(int n) {
        this.setMouseBusy();
        super.setViewScale(n);
        this.updateBounds();
        this.drawAllText();
        this.repaint();
        this.setMouseNormal();
    }

    public void layoutPage() {
        this.setMouseBusy();
        this.layoutAllText();
        this.drawAllText();
        this.repaint();
        this.setMouseNormal();
    }

    public void layoutRange(int n, int n2) {
        this.setMouseBusy();
        this.layoutChangedText(n, n2);
        this.drawText(null);
        this.repaint();
        this.setMouseNormal();
    }

    public void layoutAfterChange(int n) {
        this.textSelector.selectionOff();
        if (n != -1) {
            this.layoutChangedText(n, -1);
            this.drawText(null);
            this.paintText();
        } else {
            this.repaint();
        }
        this.textCursor.setCursorPosition(this.textCursor.getCursorPosition());
    }

    public void layoutAllText() {
        this.lineList = new Vector();
        this.layoutChangedText(this.textDataStart, -1);
    }

    public void layoutChangedText(int n, int n2) {
        int n3;
        if (this.getTextData() == null) {
            return;
        }
        this.getLayoutStart(n);
        int n4 = 0;
        int n5 = this.getTextDataStart();
        TextLine textLine = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawStart);
        if (textLine != null) {
            n4 = textLine.getY();
        }
        if (textLine != null) {
            n5 = textLine.getStartIndex();
        }
        if (n2 > -1) {
            this.lineRedrawEnd = TextObject.getObjectIndex(this.lineList, n2);
        }
        this.lineRedrawEnd = n3 = this.layoutLines(n5, n4, this.lineRedrawStart, this.lineRedrawEnd);
        if (this.lineRedrawEnd >= this.lineList.size() - 1) {
            TextLine textLine2 = (TextLine)TextObject.getObjectAt(this.lineList, this.lineList.size() - 1);
            if (textLine2 != null) {
                this.setTextDataEnd(textLine2.getEndIndex());
            }
            this.textData.removeComponents(this.getTextDataStart(), this.getTextDataEnd());
        }
    }

    private void getLayoutStart(int n) {
        this.lineRedrawStart = TextObject.getObjectIndex(this.lineList, n);
        this.lineRedrawEnd = this.lineRedrawStart = Math.max(0, this.lineRedrawStart);
        if (this.lineRedrawStart == 0) {
            return;
        }
        TextLine textLine = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawStart);
        if (textLine == null) {
            return;
        }
        Vector vector = textLine.getWordList();
        int n2 = TextObject.getObjectIndex(vector, n);
        if (n2 >= 2) {
            return;
        }
        this.lineRedrawStart = Math.max(0, --this.lineRedrawStart);
    }

    private int layoutLines(int n, int n2, int n3, int n4) {
        int n5 = n3 - 1;
        int n6 = n;
        int n7 = n2;
        boolean bl = false;
        do {
            TextLine textLine;
            boolean bl2;
            if ((bl2 = this.compareSingleLine(textLine = this.layoutSingleLine(n6, n7), ++n5)) && n5 > n4) {
                return n5 - 1;
            }
            this.storeSingleLine(textLine, n5);
            if (n6 > this.textData.getSize()) {
                bl = true;
            }
            if (this.textData.isNewPage(textLine.getEndIndex() + 1)) {
                ++n5;
                bl = true;
            }
            n6 = textLine.getEndIndex() + 1;
            if ((n7 += textLine.getHeight()) > this.getPixelBounds().height) {
                bl = true;
            }
            if (!textLine.isEmpty()) continue;
            bl = true;
        } while (!bl);
        this.deleteTextLines(n5);
        return n5 - 1;
    }

    private void deleteTextLines(int n) {
        int n2 = this.lineList.size() - 1;
        while (n2 >= n) {
            try {
                this.lineList.removeElementAt(n2);
            }
            catch (Exception exception) {}
            --n2;
        }
    }

    private boolean compareSingleLine(TextLine textLine, int n) {
        TextLine textLine2 = (TextLine)TextObject.getObjectAt(this.lineList, n);
        return textLine.equals(textLine2);
    }

    private void storeSingleLine(TextLine textLine, int n) {
        try {
            this.lineList.setElementAt(textLine, n);
            return;
        }
        catch (Exception exception) {
            this.lineList.addElement(textLine);
            return;
        }
    }

    private TextLine layoutSingleLine(int n, int n2) {
        TextLine textLine = new TextLine(this.textData, n, this);
        textLine.layoutLine();
        textLine.setY(n2);
        return textLine;
    }

    private void shiftTextLinesStart(int n, int n2) {
        int n3 = 0;
        while (n3 < this.lineList.size()) {
            int n4;
            TextLine textLine = (TextLine)TextObject.getObjectAt(this.lineList, n3);
            if (textLine != null && (n4 = textLine.getStartIndex()) > n) {
                textLine.setStartIndex(n4 + n2);
            }
            ++n3;
        }
        this.setTextDataEnd(this.getTextDataEnd() + n2);
    }

    public void drawAllText() {
        this.lineRedrawStart = 0;
        this.lineRedrawEnd = this.lineList.size() - 1;
        this.drawText(null);
    }

    private void drawText(Graphics graphics) {
        if (graphics == null) {
            graphics = this.getGraphicsContext();
        }
        if (graphics == null) {
            return;
        }
        this.lineRedrawStart = Math.max(this.lineRedrawStart, 0);
        this.lineRedrawEnd = Math.min(this.lineRedrawEnd, this.lineList.size() - 1);
        TextLine textLine = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawStart);
        TextLine textLine2 = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawEnd);
        graphics.setClip(this.getLineBounds(textLine, textLine2, this.lineRedrawEnd));
        super.paint(graphics);
        TextStyle textStyle = null;
        int n = this.lineRedrawStart;
        while (n <= this.lineRedrawEnd) {
            TextLine textLine3 = (TextLine)TextObject.getObjectAt(this.lineList, n);
            if (textLine3 != null) {
                textStyle = textLine3.paint(graphics, textStyle, this.getViewScale(), this.isMarkerVisible());
            }
            ++n;
        }
        this.textSelector.paintNew();
    }

    private void paintText() {
        TextLine textLine = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawStart);
        TextLine textLine2 = (TextLine)TextObject.getObjectAt(this.lineList, this.lineRedrawEnd);
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getLineBounds(textLine, textLine2, this.lineRedrawEnd);
        graphics.setClip(rectangle);
        this.paint(graphics);
        if (this.isFocus) {
            this.requestFocus();
        }
    }

    private Rectangle getLineBounds(TextLine textLine, TextLine textLine2, int n) {
        try {
            Rectangle rectangle = this.getScaledPixelBounds();
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = 0;
            rectangle2.width = rectangle.width;
            rectangle2.y = Math.max(0, textLine.getY() * this.getViewScale() / 100);
            int n2 = (textLine2.getY() + textLine2.getHeight()) * this.getViewScale() / 100;
            n2 = Math.min(n2, rectangle.height + rectangle.y);
            if (n >= this.lineList.size() - 1) {
                n2 = rectangle.y + rectangle.height;
            }
            rectangle2.height = n2 - rectangle2.y;
            return rectangle2;
        }
        catch (Exception exception) {
            Rectangle rectangle = this.getScaledPixelBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            return rectangle;
        }
    }

    public void print(Graphics graphics) {
        this.lineRedrawStart = 0;
        this.lineRedrawEnd = this.lineList.size() - 1;
        this.drawText(graphics);
    }

    public void paint(Graphics graphics) {
        this.textCursor.cursorOff();
        if (graphics == null) {
            graphics = this.getGraphics();
        }
        if (this.offscreenImage == null || graphics == null) {
            return;
        }
        graphics.drawImage(this.offscreenImage, 0, 0, null);
        this.textCursor.cursorNew();
        if (!this.textSelector.isSelected()) {
            this.textCursor.cursorOn();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Graphics getGraphicsContext() {
        Rectangle rectangle = this.getScaledPixelBounds();
        if (this.offscreenImage != null) {
            if (this.offscreenSize == null) {
                this.offscreenSize = new Dimension(0, 0);
            }
            if (this.offscreenSize.width != rectangle.width) {
                this.offscreenImage = null;
            }
            if (this.offscreenSize.height != rectangle.height) {
                this.offscreenImage = null;
            }
        }
        if (this.offscreenImage == null) {
            try {
                this.offscreenImage = this.createImage(rectangle.width, rectangle.height);
                this.offscreenSize = new Dimension(rectangle.width, rectangle.height);
                this.offscreenGraphics = this.offscreenImage.getGraphics();
            }
            catch (Exception exception) {}
        }
        return this.offscreenGraphics;
    }

    public void setMouseBusy() {
        this.setCursor(new Cursor(3));
    }

    public void setMouseNormal() {
        int n = 2;
        if (this.getEditable() == 0) {
            n = 0;
        }
        this.setCursor(new Cursor(n));
    }

    public int getCharacterAt(int n, int n2) {
        TextLine textLine = (TextLine)TextObject.getObject(this.lineList, (double)n2);
        if (textLine == null) {
            return -1;
        }
        return textLine.getCharacterAt(n, n2);
    }

    public Rectangle getCharacterBounds(int n) {
        TextLine textLine;
        if (n > this.getTextDataEnd()) {
            n = this.getTextDataEnd();
        }
        if (n < this.getTextDataStart()) {
            n = this.getTextDataStart();
        }
        if ((textLine = (TextLine)TextObject.getObject(this.lineList, n)) == null) {
            return null;
        }
        return textLine.getCharacterBounds(n);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.getEditable() == 0) {
            return;
        }
        if (mouseEvent.getSource() != this) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point.x = point.x * 100 / this.getViewScale();
        point.y = point.y * 100 / this.getViewScale();
        if (mouseEvent.getID() == 501 && this.mouseClickPt == null) {
            this.textData.resetNextTextStyle();
            int n = mouseEvent.getModifiers();
            if (n != 16 && n != 0 && this.isFocus) {
                this.textClipboard.displayPopUp(mouseEvent);
                return;
            }
        }
        if (mouseEvent.getID() == 501 && this.mouseClickPt == null) {
            this.textData.resetNextTextStyle();
            this.requestFocus();
            if (this.textSelector.isSelected() && !this.isFocus) {
                return;
            }
            if (mouseEvent.getClickCount() <= 1) {
                this.textSelector.selectionOff();
                this.textSelector.setSelectionStart(point.x, point.y);
            }
            this.textCursor.setCursorPosition(point.x, point.y);
            this.mouseClickPt = point;
            this.repaint();
        }
        if (mouseEvent.getID() == 502) {
            if (this.mouseClickPt == null) {
                return;
            }
            switch (mouseEvent.getClickCount()) {
                case 2: {
                    this.textSelector.selectWord(point.x, point.y);
                    break;
                }
                case 3: {
                    this.textSelector.selectParagraph(point.x, point.y);
                    break;
                }
                default: {
                    if (this.mouseClickPt.equals(point)) break;
                    this.textSelector.setSelectionEnd(point.x, point.y);
                }
            }
            this.mouseClickPt = null;
            this.repaint();
            this.sendActionEvent("Mouse Released");
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (this.getEditable() == 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point.x = point.x * 100 / this.getViewScale();
        point.y = point.y * 100 / this.getViewScale();
        if (this.mouseClickPt == null) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            int n = this.textSelector.getSelectionEnd();
            this.textSelector.setSelectionEnd(point.x, point.y);
            if (n != this.textSelector.getSelectionEnd()) {
                this.repaint();
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getEditable() == 0) {
            return;
        }
        this.textCursor.setCursorColor(Color.red);
        this.textSelector.setSelectionColor(Color.green);
        if (this.textSelector.isSelected()) {
            this.repaint();
        }
        this.isFocus = true;
        this.sendActionEvent("Focus Gained");
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent != null) {
            return;
        }
        if (this.getEditable() == 0) {
            return;
        }
        this.textCursor.setCursorColor(null);
        this.textSelector.setSelectionColor(Color.lightGray);
        if (this.textSelector.isSelected()) {
            this.repaint();
        }
        this.isFocus = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.getEditable() != 2) {
            return;
        }
        if (keyEvent.isAltDown()) {
            return;
        }
        if (keyEvent.isControlDown()) {
            return;
        }
        if (keyEvent.isMetaDown()) {
            return;
        }
        int n = this.textCursor.getCursorPosition();
        int n2 = this.textSelector.getSelectionEnd();
        int n3 = this.textSelector.getSelectionStart();
        int n4 = -1;
        UndoGroup undoGroup = this.textUndo.getUndoGroup("Insert");
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (n3 != -1) {
                    this.textCursor.setCursorPosition(n3);
                }
                this.textCursor.cursorLeft();
                break;
            }
            case 39: {
                if (n2 != -1) {
                    this.textCursor.setCursorPosition(n2 - 1);
                }
                this.textCursor.cursorRight();
                break;
            }
            case 38: {
                this.textCursor.cursorUp();
                break;
            }
            case 40: {
                this.textCursor.cursorDown();
                break;
            }
            case 36: {
                this.textCursor.cursorHome();
                break;
            }
            case 35: {
                this.textCursor.cursorEnd();
                break;
            }
            case 127: {
                n4 = this.delete(n + 1, 1, undoGroup);
                undoGroup.setGroupName("Delete");
                break;
            }
            case 8: {
                n4 = this.delete(n, 1, undoGroup);
                undoGroup.setGroupName("Delete");
                break;
            }
            default: {
                char c = keyEvent.getKeyChar();
                if (c == '\u0000') {
                    return;
                }
                n4 = this.insert(c, n + 1, undoGroup);
            }
        }
        this.layoutAfterChange(n4);
        this.textData.resetNextTextStyle();
        this.textUndo.setUndoGroup(undoGroup);
        this.sendActionEvent("Key Pressed");
    }

    public void setMarkerVisible(boolean bl) {
        this.markerVisible = bl;
        this.layoutPage();
    }

    public boolean isMarkerVisible() {
        return this.markerVisible;
    }

    public int insert(char c, int n, UndoGroup undoGroup) {
        return this.insert(String.valueOf(c), n, undoGroup);
    }

    public int insert(String string, int n, UndoGroup undoGroup) {
        if (!this.textCursor.isOnScreen()) {
            return -1;
        }
        this.textCursor.cursorOff();
        if (this.textSelector.isSelected()) {
            n = this.delete(0, 0, undoGroup);
        }
        if (undoGroup != null) {
            this.textUndo.setUndoInsert(undoGroup, string, n, string.length());
        }
        int n2 = this.textData.insert(string, n);
        this.shiftTextLinesStart(n, n2);
        this.textCursor.setCursorPosition(n + n2 - 1);
        return n - 1;
    }

    public int insert(TextData textData, int n, UndoGroup undoGroup) {
        if (!this.textCursor.isOnScreen()) {
            return -1;
        }
        this.textCursor.cursorOff();
        if (this.textSelector.isSelected()) {
            n = this.delete(0, 0, undoGroup);
        }
        if (undoGroup != null) {
            this.textUndo.setUndoInsert(undoGroup, textData, n, textData.getSize() - 1);
        }
        int n2 = this.textData.insert(textData, n, false);
        this.shiftTextLinesStart(n, n2);
        this.textCursor.setCursorPosition(n + n2 - 1);
        return n - 1;
    }

    public int insert(ComponentPanel componentPanel, int n, UndoGroup undoGroup) {
        if (!this.textCursor.isOnScreen()) {
            return -1;
        }
        this.textCursor.cursorOff();
        if (this.textSelector.isSelected()) {
            n = this.delete(0, 0, undoGroup);
        }
        if (undoGroup != null) {
            this.textUndo.setUndoInsert(undoGroup, componentPanel, n, 1);
        }
        int n2 = this.textData.insert(componentPanel, n);
        this.shiftTextLinesStart(n, 1);
        this.textCursor.setCursorPosition(n + n2 - 1);
        return n;
    }

    public int delete(int n, int n2, UndoGroup undoGroup) {
        if (!this.textCursor.isOnScreen()) {
            return -1;
        }
        this.textCursor.cursorOff();
        int n3 = n + n2 - 1;
        if (this.textSelector.isSelected()) {
            n = this.textSelector.getSelectionStart();
            n3 = this.textSelector.getSelectionEnd();
            this.lineList = new Vector();
        }
        if (n > n3) {
            int n4 = n;
            n = n3;
            n3 = n4;
        }
        if (undoGroup != null) {
            this.textUndo.setUndoDelete(undoGroup, n, n3, this.textSelector.isSelected());
        }
        n2 = this.textData.delete(n, n3);
        this.shiftTextLinesStart(n, n2 * -1);
        this.textCursor.setCursorPosition(n - 1);
        return n;
    }

    public void setComponentVisible(boolean bl) {
        Vector vector = this.getTextData().getCharacterList().getComponentList();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!bl) {
                component.setVisible(false);
                continue;
            }
            if (component instanceof InchPanel) {
                ((InchPanel)component).updateBounds();
            }
            component.setVisible(true);
        }
    }

    public void setBackground(Color color) {
        this.getBackground();
        super.setBackground(color);
        Vector vector = this.getTextData().getCharacterList().getComponentList();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.setBackground(color);
        }
    }

    public void pageChange(int n) {
    }

    public void sendActionEvent(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }
}

