/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.rule.properties.BooleanMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.CharacterMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.CharacterProperty;
import net.sourceforge.pmd.lang.rule.properties.DoubleMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.DoubleProperty;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.FloatMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.FloatProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.rule.properties.LongMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.LongProperty;
import net.sourceforge.pmd.lang.rule.properties.MethodMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.MethodProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.lang.rule.properties.TypeMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.TypeProperty;
import net.sourceforge.pmd.util.StringUtil;

public class PropertyDescriptorFactory {
    public static String getPropertyDescriptorType(PropertyDescriptor<?> propertyDescriptor) {
        Class<?> type = propertyDescriptor.type();
        String typeName = null;
        if (!(propertyDescriptor instanceof EnumeratedProperty) && !(propertyDescriptor instanceof MethodProperty) && !(propertyDescriptor instanceof TypeProperty) && "java.lang".equals(type.getPackage().getName())) {
            typeName = type.getSimpleName();
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Cannot encode type for PropertyDescriptor class: " + type.getName());
        }
        return typeName;
    }

    public static PropertyDescriptor<?> createPropertyDescriptor(String name, String description, String type, String delimiter, String min, String max, String value) {
        return new PropertyDescriptorWrapper(PropertyDescriptorFactory.createRawPropertyDescriptor(name, description, type, delimiter, min, max, value));
    }

    private static PropertyDescriptor<?> createRawPropertyDescriptor(String name, String description, String type, String delimiter, String min, String max, String value) {
        if ("Boolean".equals(type)) {
            return new BooleanProperty(name, description, value, 0.0f);
        }
        if ("Boolean[]".equals(type)) {
            BooleanMultiProperty property2 = new BooleanMultiProperty(name, description, null, 0.0f);
            return new BooleanMultiProperty(name, description, (Boolean[])property2.valueFrom(value), 0.0f);
        }
        if ("Character".equals(type)) {
            return new CharacterProperty(name, description, CharacterProperty.charFrom(value), 0.0f);
        }
        if ("Character[]".equals(type)) {
            PropertyDescriptorFactory.checkDelimiter(name, type, delimiter);
            char delim = delimiter.charAt(0);
            CharacterMultiProperty property3 = new CharacterMultiProperty(name, description, null, 0.0f, delim);
            return new CharacterMultiProperty(name, description, property3.valueFrom(value), 0.0f, delim);
        }
        if ("Double".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            return new DoubleProperty(name, description, min, max, value, 0.0f);
        }
        if ("Double[]".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            DoubleMultiProperty property4 = new DoubleMultiProperty(name, description, 0.0, 0.0, null, 0.0f);
            return new DoubleMultiProperty(name, description, DoubleProperty.doubleFrom(min), DoubleProperty.doubleFrom(max), (Double[])property4.valueFrom(value), 0.0f);
        }
        if ("Float".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            return new FloatProperty(name, description, min, max, value, 0.0f);
        }
        if ("Float[]".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            FloatMultiProperty property5 = new FloatMultiProperty(name, description, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f);
            return new FloatMultiProperty(name, description, FloatProperty.floatFrom(min), FloatProperty.floatFrom(max), (Float[])property5.valueFrom(value), 0.0f);
        }
        if ("Integer".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            return new IntegerProperty(name, description, min, max, value, 0.0f);
        }
        if ("Integer[]".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            IntegerMultiProperty property6 = new IntegerMultiProperty(name, description, 0, 0, null, 0.0f);
            return new IntegerMultiProperty(name, description, IntegerProperty.intFrom(min), IntegerProperty.intFrom(max), (Integer[])property6.valueFrom(value), 0.0f);
        }
        if ("Long".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            return new LongProperty(name, description, min, max, value, 0.0f);
        }
        if ("Long[]".equals(type)) {
            PropertyDescriptorFactory.checkMinMax(name, type, min, max);
            LongMultiProperty property7 = new LongMultiProperty(name, description, 0L, 0L, null, 0.0f);
            return new LongMultiProperty(name, description, LongProperty.longFrom(min), LongProperty.longFrom(max), (Long[])property7.valueFrom(value), 0.0f);
        }
        if ("Type".equals(type)) {
            return new TypeProperty(name, description, value, (String[])null, 0.0f);
        }
        if ("Type[]".equals(type)) {
            return new TypeMultiProperty(name, description, value, (String[])null, 0.0f);
        }
        if ("Method".equals(type)) {
            return new MethodProperty(name, description, value, (String[])null, 0.0f);
        }
        if ("Method[]".equals(type)) {
            return new MethodMultiProperty(name, description, value, (String[])null, 0.0f);
        }
        if ("String".equals(type)) {
            return new StringProperty(name, description, value, 0.0f);
        }
        if ("String[]".equals(type)) {
            PropertyDescriptorFactory.checkDelimiter(name, type, delimiter);
            char delim = delimiter.charAt(0);
            StringMultiProperty property8 = new StringMultiProperty(name, description, null, 0.0f, delim);
            return new StringMultiProperty(name, description, property8.valueFrom(value), 0.0f, delim);
        }
        throw new IllegalArgumentException("Cannot define property type '" + type + "'.");
    }

    private static void checkDelimiter(String name, String type, String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            throw new IllegalArgumentException("Delimiter must be provided to create PropertyDescriptor for " + name + " of type " + type + ".");
        }
    }

    private static void checkMinMax(String name, String type, String min, String max) {
        if (StringUtil.isEmpty(min)) {
            throw new IllegalArgumentException("Min must be provided to create PropertyDescriptor for " + name + " of type " + type + ".");
        }
        if (StringUtil.isEmpty(max)) {
            throw new IllegalArgumentException("Max must be provided to create PropertyDescriptor for " + name + " of type " + type + ".");
        }
    }
}

