/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import javax.swing.JTextPane;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.designer.LineGetter;

public class CodeEditorTextPane
extends JTextPane
implements LineGetter {
    private String[] getLines() {
        return this.getText().split("\r\n|\r|\n");
    }

    @Override
    public String getLine(int number) {
        String[] lines = this.getLines();
        if (number < lines.length) {
            return lines[number];
        }
        throw new RuntimeException("Line number " + number + " not found");
    }

    private int getPosition(String[] lines, int line, int column) {
        int pos = 0;
        int count = 0;
        while (count < lines.length) {
            String tok = lines[count++];
            if (count == line) {
                int linePos = 0;
                int i = 0;
                while (linePos < column && linePos < tok.length()) {
                    ++linePos;
                    if (tok.charAt(i) == '\t') {
                        --linePos;
                        linePos += 8 - (linePos & 7);
                    }
                    ++i;
                }
                return pos + i - 1;
            }
            pos += tok.length() + 1;
        }
        throw new RuntimeException("Line " + line + " not found");
    }

    public void select(Node node) {
        String[] lines = this.getLines();
        if (node.getBeginLine() >= 0) {
            this.setSelectionStart(this.getPosition(lines, node.getBeginLine(), node.getBeginColumn()));
            this.setSelectionEnd(this.getPosition(lines, node.getEndLine(), node.getEndColumn()) + 1);
        }
        this.requestFocus();
    }
}

